/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.DefaultedFloat;
import fuzs.puzzleslib.api.event.v1.data.MutableFloat;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingAttackCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDeathCallback;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingHurtCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.BreakSpeedCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.ItemEntityEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTickEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricLivingEvents;
import fuzs.puzzleslib.fabric.api.event.v1.FabricPlayerEvents;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
abstract class PlayerFabricMixin
extends class_1309 {
    protected PlayerFabricMixin(class_1299<? extends class_1309> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick$0(CallbackInfo callback) {
        ((PlayerTickEvents.Start)FabricPlayerEvents.PLAYER_TICK_START.invoker()).onStartPlayerTick((class_1657)class_1657.class.cast((Object)this));
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick$1(CallbackInfo callback) {
        ((PlayerTickEvents.End)FabricPlayerEvents.PLAYER_TICK_END.invoker()).onEndPlayerTick((class_1657)class_1657.class.cast((Object)this));
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callback) {
        EventResult result = ((LivingAttackCallback)FabricLivingEvents.LIVING_ATTACK.invoker()).onLivingAttack(this, source, amount);
        if (result.isInterrupt()) {
            callback.setReturnValue((Object)false);
        }
    }

    @ModifyReturnValue(method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, at={@At(value="TAIL")})
    public class_1542 drop(@Nullable class_1542 itemEntity) {
        if (itemEntity != null && ((ItemEntityEvents.Toss)FabricPlayerEvents.ITEM_TOSS.invoker()).onItemToss((class_1657)class_1657.class.cast((Object)this), itemEntity).isInterrupt()) {
            return null;
        }
        return itemEntity;
    }

    @ModifyReturnValue(method={"getDestroySpeed"}, at={@At(value="TAIL")}, require=0)
    public float getDestroySpeed(float destroySpeed, class_2680 blockState) {
        DefaultedFloat defaultedFloat = DefaultedFloat.fromValue(destroySpeed);
        if (((BreakSpeedCallback)FabricPlayerEvents.BREAK_SPEED.invoker()).onBreakSpeed((class_1657)class_1657.class.cast((Object)this), blockState, defaultedFloat).isInterrupt()) {
            defaultedFloat.accept(-1.0f);
        }
        return defaultedFloat.getAsOptionalFloat().orElse(Float.valueOf(destroySpeed)).floatValue();
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    public void die(class_1282 damageSource, CallbackInfo callback) {
        EventResult result = ((LivingDeathCallback)FabricLivingEvents.LIVING_DEATH.invoker()).onLivingDeath(this, damageSource);
        if (result.isInterrupt()) {
            callback.cancel();
        }
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="HEAD")}, cancellable=true)
    protected void actuallyHurt(class_1282 damageSource, float damageAmount, CallbackInfo callback, @Share(value="damageAmount") LocalRef<DefaultedFloat> damageAmountRef) {
        if (!this.method_5679(damageSource)) {
            damageAmountRef.set((Object)DefaultedFloat.fromValue(damageAmount));
            if (((LivingHurtCallback)FabricLivingEvents.LIVING_HURT.invoker()).onLivingHurt((class_1309)class_1309.class.cast((Object)this), damageSource, (MutableFloat)damageAmountRef.get()).isInterrupt()) {
                callback.cancel();
            }
        }
    }

    @ModifyVariable(method={"actuallyHurt"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    protected float actuallyHurt(float damageAmount, class_1282 damageSource, @Share(value="damageAmount") LocalRef<DefaultedFloat> damageAmountRef) {
        if (!this.method_5679(damageSource)) {
            Objects.requireNonNull((DefaultedFloat)damageAmountRef.get(), "damage amount is null");
            damageAmount = ((DefaultedFloat)damageAmountRef.get()).getAsOptionalFloat().orElse(Float.valueOf(damageAmount)).floatValue();
        }
        return damageAmount;
    }
}

