/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.io._UtilKt;
import kotlinx.io.internal._Utf8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u0000\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u0004\u001a&\u0010\n\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u001a&\u0010\n\u001a\u00020\u0007*\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u001a\n\u0010\u000e\u001a\u00020\u0002*\u00020\u000f\u001a\n\u0010\u000e\u001a\u00020\u0002*\u00020\u0010\u001a\u0012\u0010\u000e\u001a\u00020\u0002*\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0001\u001a\n\u0010\u0012\u001a\u00020\u0004*\u00020\u000f\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0002*\u00020\u000f\u001a\u0014\u0010\u0014\u001a\u00020\u0002*\u00020\u000f2\b\b\u0002\u0010\u0015\u001a\u00020\u0001\u001a\f\u0010\u0016\u001a\u00020\u0004*\u00020\u0010H\u0002\u001a1\u0010\u0017\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0\u001aH\u0082\b\u001a\u0014\u0010\u001c\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\t\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u001d\u001a\u00020\u0002*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u00a8\u0006\u001e"}, d2={"utf8Size", "", "", "startIndex", "", "endIndex", "writeCodePointValue", "", "Lkotlinx/io/Sink;", "codePoint", "writeString", "string", "chars", "", "readString", "Lkotlinx/io/Source;", "Lkotlinx/io/Buffer;", "byteCount", "readCodePointValue", "readLine", "readLineStrict", "limit", "commonReadUtf8CodePoint", "commonWriteUtf8", "beginIndex", "charAt", "Lkotlin/Function1;", "", "commonWriteUtf8CodePoint", "commonReadUtf8", "kotlinx-io-core"})
@SourceDebugExtension(value={"SMAP\nUtf8.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utf8.kt\nkotlinx/io/Utf8Kt\n+ 2 -Util.kt\nkotlinx/io/_UtilKt\n+ 3 Sinks.kt\nkotlinx/io/SinksKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,613:1\n462#1,76:620\n462#1,76:700\n38#2:614\n38#2:618\n38#2:698\n97#2:779\n97#2:780\n97#2:781\n97#2:782\n97#2:783\n97#2:784\n97#2:785\n97#2:786\n97#2:787\n97#2:788\n363#3,3:615\n363#3:619\n364#3,2:696\n363#3:699\n364#3,2:776\n1#4:778\n*S KotlinDebug\n*F\n+ 1 Utf8.kt\nkotlinx/io/Utf8Kt\n*L\n168#1:620,76\n188#1:700,76\n86#1:614\n166#1:618\n186#1:698\n387#1:779\n389#1:780\n394#1:781\n396#1:782\n401#1:783\n403#1:784\n408#1:785\n410#1:786\n431#1:787\n434#1:788\n149#1:615,3\n168#1:619\n168#1:696,2\n188#1:699\n188#1:776,2\n*E\n"})
public final class Utf8Kt {
    public static final long utf8Size(@NotNull String $this$utf8Size, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$utf8Size, (String)"<this>");
        int size$iv = $this$utf8Size.length();
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        long result = 0L;
        int i = startIndex;
        while (i < endIndex) {
            char low;
            char c = $this$utf8Size.charAt(i);
            if (c < '\u0080') {
                long l = result;
                result = l + 1L;
                ++i;
                continue;
            }
            if (c < '\u0800') {
                result += (long)2;
                ++i;
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                result += (long)3;
                ++i;
                continue;
            }
            char c2 = low = i + 1 < endIndex ? $this$utf8Size.charAt(i + 1) : (char)'\u0000';
            if (c > '\udbff' || low < '\udc00' || low > '\udfff') {
                long l = result;
                result = l + 1L;
                ++i;
                continue;
            }
            result += (long)4;
            i += 2;
        }
        return result;
    }

    public static /* synthetic */ long utf8Size$default(String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        return Utf8Kt.utf8Size(string, n, n2);
    }

    public static final void writeCodePointValue(@NotNull Sink $this$writeCodePointValue, int codePoint) {
        Intrinsics.checkNotNullParameter((Object)$this$writeCodePointValue, (String)"<this>");
        Sink $this$writeToInternalBuffer$iv = $this$writeCodePointValue;
        boolean $i$f$writeToInternalBuffer = false;
        Buffer it = $this$writeToInternalBuffer$iv.getBuffer();
        boolean bl = false;
        Utf8Kt.commonWriteUtf8CodePoint(it, codePoint);
        $this$writeToInternalBuffer$iv.hintEmit();
    }

    public static final void writeString(@NotNull Sink $this$writeString, @NotNull String string, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$writeString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int size$iv = string.length();
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        Sink $this$writeToInternalBuffer$iv = $this$writeString;
        boolean $i$f$writeToInternalBuffer = false;
        Buffer it = $this$writeToInternalBuffer$iv.getBuffer();
        boolean bl = false;
        Buffer $this$commonWriteUtf8$iv = it;
        boolean $i$f$commonWriteUtf8 = false;
        int i$iv = startIndex;
        while (i$iv < endIndex) {
            int low$iv;
            char c$iv;
            block11: {
                block10: {
                    int n;
                    int p0 = i$iv++;
                    boolean bl2 = false;
                    c$iv = string.charAt(p0);
                    if (c$iv < '\u0080') {
                        Segment tail$iv = $this$commonWriteUtf8$iv.writableSegment(1);
                        byte[] data$iv = tail$iv.data;
                        int segmentOffset$iv = tail$iv.getLimit() - i$iv;
                        int runLimit$iv = Math.min(endIndex, 8192 - segmentOffset$iv);
                        data$iv[segmentOffset$iv + i$iv++] = (byte)c$iv;
                        while (i$iv < runLimit$iv) {
                            int p02 = i$iv;
                            $i$a$-commonWriteUtf8-Utf8Kt$writeString$1$1 = false;
                            c$iv = string.charAt(p02);
                            if (c$iv >= '\u0080') break;
                            data$iv[segmentOffset$iv + i$iv++] = (byte)c$iv;
                        }
                        int runSize$iv = i$iv + segmentOffset$iv - tail$iv.getLimit();
                        tail$iv.setLimit(tail$iv.getLimit() + runSize$iv);
                        $this$commonWriteUtf8$iv.setSizeMut($this$commonWriteUtf8$iv.getSizeMut() + (long)runSize$iv);
                        continue;
                    }
                    if (c$iv < '\u0800') {
                        Segment tail$iv = $this$commonWriteUtf8$iv.writableSegment(2);
                        tail$iv.data[tail$iv.getLimit()] = (byte)(c$iv >> 6 | 0xC0);
                        tail$iv.data[tail$iv.getLimit() + 1] = (byte)(c$iv & 0x3F | 0x80);
                        tail$iv.setLimit(tail$iv.getLimit() + 2);
                        $this$commonWriteUtf8$iv.setSizeMut($this$commonWriteUtf8$iv.getSizeMut() + 2L);
                        continue;
                    }
                    if (c$iv < '\ud800' || c$iv > '\udfff') {
                        Segment tail$iv = $this$commonWriteUtf8$iv.writableSegment(3);
                        tail$iv.data[tail$iv.getLimit()] = (byte)(c$iv >> 12 | 0xE0);
                        tail$iv.data[tail$iv.getLimit() + 1] = (byte)(c$iv >> 6 & 0x3F | 0x80);
                        tail$iv.data[tail$iv.getLimit() + 2] = (byte)(c$iv & 0x3F | 0x80);
                        tail$iv.setLimit(tail$iv.getLimit() + 3);
                        $this$commonWriteUtf8$iv.setSizeMut($this$commonWriteUtf8$iv.getSizeMut() + 3L);
                        ++i$iv;
                        continue;
                    }
                    if (i$iv + 1 < endIndex) {
                        int p03 = i$iv + 1;
                        $i$a$-commonWriteUtf8-Utf8Kt$writeString$1$1 = false;
                        n = string.charAt(p03);
                    } else {
                        n = low$iv = 0;
                    }
                    if (c$iv > '\udbff') break block10;
                    if (56320 <= low$iv ? low$iv < 57344 : false) break block11;
                }
                $this$commonWriteUtf8$iv.writeByte((byte)63);
                ++i$iv;
                continue;
            }
            int codePoint$iv = 65536 + ((c$iv & 0x3FF) << 10 | low$iv & 0x3FF);
            Segment tail$iv = $this$commonWriteUtf8$iv.writableSegment(4);
            tail$iv.data[tail$iv.getLimit()] = (byte)(codePoint$iv >> 18 | 0xF0);
            tail$iv.data[tail$iv.getLimit() + 1] = (byte)(codePoint$iv >> 12 & 0x3F | 0x80);
            tail$iv.data[tail$iv.getLimit() + 2] = (byte)(codePoint$iv >> 6 & 0x3F | 0x80);
            tail$iv.data[tail$iv.getLimit() + 3] = (byte)(codePoint$iv & 0x3F | 0x80);
            tail$iv.setLimit(tail$iv.getLimit() + 4);
            $this$commonWriteUtf8$iv.setSizeMut($this$commonWriteUtf8$iv.getSizeMut() + 4L);
            i$iv += 2;
        }
        $this$writeToInternalBuffer$iv.hintEmit();
    }

    public static /* synthetic */ void writeString$default(Sink sink, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = string.length();
        }
        Utf8Kt.writeString(sink, string, n, n2);
    }

    public static final void writeString(@NotNull Sink $this$writeString, @NotNull CharSequence chars, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$writeString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        int size$iv = chars.length();
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        Sink $this$writeToInternalBuffer$iv = $this$writeString;
        boolean $i$f$writeToInternalBuffer = false;
        Buffer it = $this$writeToInternalBuffer$iv.getBuffer();
        boolean bl = false;
        Buffer $this$commonWriteUtf8$iv = it;
        boolean $i$f$commonWriteUtf8 = false;
        int i$iv = startIndex;
        while (i$iv < endIndex) {
            int low$iv;
            char c$iv;
            block11: {
                block10: {
                    int n;
                    int p0 = i$iv++;
                    boolean bl2 = false;
                    c$iv = chars.charAt(p0);
                    if (c$iv < '\u0080') {
                        Segment tail$iv = $this$commonWriteUtf8$iv.writableSegment(1);
                        byte[] data$iv = tail$iv.data;
                        int segmentOffset$iv = tail$iv.getLimit() - i$iv;
                        int runLimit$iv = Math.min(endIndex, 8192 - segmentOffset$iv);
                        data$iv[segmentOffset$iv + i$iv++] = (byte)c$iv;
                        while (i$iv < runLimit$iv) {
                            int p02 = i$iv;
                            $i$a$-commonWriteUtf8-Utf8Kt$writeString$2$1 = false;
                            c$iv = chars.charAt(p02);
                            if (c$iv >= '\u0080') break;
                            data$iv[segmentOffset$iv + i$iv++] = (byte)c$iv;
                        }
                        int runSize$iv = i$iv + segmentOffset$iv - tail$iv.getLimit();
                        tail$iv.setLimit(tail$iv.getLimit() + runSize$iv);
                        $this$commonWriteUtf8$iv.setSizeMut($this$commonWriteUtf8$iv.getSizeMut() + (long)runSize$iv);
                        continue;
                    }
                    if (c$iv < '\u0800') {
                        Segment tail$iv = $this$commonWriteUtf8$iv.writableSegment(2);
                        tail$iv.data[tail$iv.getLimit()] = (byte)(c$iv >> 6 | 0xC0);
                        tail$iv.data[tail$iv.getLimit() + 1] = (byte)(c$iv & 0x3F | 0x80);
                        tail$iv.setLimit(tail$iv.getLimit() + 2);
                        $this$commonWriteUtf8$iv.setSizeMut($this$commonWriteUtf8$iv.getSizeMut() + 2L);
                        continue;
                    }
                    if (c$iv < '\ud800' || c$iv > '\udfff') {
                        Segment tail$iv = $this$commonWriteUtf8$iv.writableSegment(3);
                        tail$iv.data[tail$iv.getLimit()] = (byte)(c$iv >> 12 | 0xE0);
                        tail$iv.data[tail$iv.getLimit() + 1] = (byte)(c$iv >> 6 & 0x3F | 0x80);
                        tail$iv.data[tail$iv.getLimit() + 2] = (byte)(c$iv & 0x3F | 0x80);
                        tail$iv.setLimit(tail$iv.getLimit() + 3);
                        $this$commonWriteUtf8$iv.setSizeMut($this$commonWriteUtf8$iv.getSizeMut() + 3L);
                        ++i$iv;
                        continue;
                    }
                    if (i$iv + 1 < endIndex) {
                        int p03 = i$iv + 1;
                        $i$a$-commonWriteUtf8-Utf8Kt$writeString$2$1 = false;
                        n = chars.charAt(p03);
                    } else {
                        n = low$iv = 0;
                    }
                    if (c$iv > '\udbff') break block10;
                    if (56320 <= low$iv ? low$iv < 57344 : false) break block11;
                }
                $this$commonWriteUtf8$iv.writeByte((byte)63);
                ++i$iv;
                continue;
            }
            int codePoint$iv = 65536 + ((c$iv & 0x3FF) << 10 | low$iv & 0x3FF);
            Segment tail$iv = $this$commonWriteUtf8$iv.writableSegment(4);
            tail$iv.data[tail$iv.getLimit()] = (byte)(codePoint$iv >> 18 | 0xF0);
            tail$iv.data[tail$iv.getLimit() + 1] = (byte)(codePoint$iv >> 12 & 0x3F | 0x80);
            tail$iv.data[tail$iv.getLimit() + 2] = (byte)(codePoint$iv >> 6 & 0x3F | 0x80);
            tail$iv.data[tail$iv.getLimit() + 3] = (byte)(codePoint$iv & 0x3F | 0x80);
            tail$iv.setLimit(tail$iv.getLimit() + 4);
            $this$commonWriteUtf8$iv.setSizeMut($this$commonWriteUtf8$iv.getSizeMut() + 4L);
            i$iv += 2;
        }
        $this$writeToInternalBuffer$iv.hintEmit();
    }

    public static /* synthetic */ void writeString$default(Sink sink, CharSequence charSequence, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = charSequence.length();
        }
        Utf8Kt.writeString(sink, charSequence, n, n2);
    }

    @NotNull
    public static final String readString(@NotNull Source $this$readString) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        long req = 8192L;
        while ($this$readString.request(req)) {
            req *= (long)2;
        }
        return Utf8Kt.commonReadUtf8($this$readString.getBuffer(), $this$readString.getBuffer().getSize());
    }

    @NotNull
    public static final String readString(@NotNull Buffer $this$readString) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        return Utf8Kt.commonReadUtf8($this$readString, $this$readString.getSize());
    }

    @NotNull
    public static final String readString(@NotNull Source $this$readString, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        $this$readString.require(byteCount);
        return Utf8Kt.commonReadUtf8($this$readString.getBuffer(), byteCount);
    }

    public static final int readCodePointValue(@NotNull Source $this$readCodePointValue) {
        Intrinsics.checkNotNullParameter((Object)$this$readCodePointValue, (String)"<this>");
        if ($this$readCodePointValue instanceof Buffer) {
            return Utf8Kt.commonReadUtf8CodePoint((Buffer)$this$readCodePointValue);
        }
        $this$readCodePointValue.require(1L);
        byte b0 = $this$readCodePointValue.getBuffer().get(0L);
        if ((b0 & 0xE0) == 192) {
            $this$readCodePointValue.require(2L);
        } else if ((b0 & 0xF0) == 224) {
            $this$readCodePointValue.require(3L);
        } else if ((b0 & 0xF8) == 240) {
            $this$readCodePointValue.require(4L);
        }
        return Utf8Kt.commonReadUtf8CodePoint($this$readCodePointValue.getBuffer());
    }

    @Nullable
    public static final String readLine(@NotNull Source $this$readLine) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$readLine, (String)"<this>");
        if (!$this$readLine.request(1L)) {
            return null;
        }
        long lfIndex = SourcesKt.indexOf$default($this$readLine, (byte)10, 0L, 0L, 6, null);
        long l = lfIndex;
        if (l == -1L) {
            string = Utf8Kt.readString($this$readLine);
        } else if (l == 0L) {
            $this$readLine.skip(1L);
            string = "";
        } else {
            int skipBytes = 1;
            if ($this$readLine.getBuffer().get(lfIndex - 1L) == 13) {
                --lfIndex;
                ++skipBytes;
            }
            String string2 = Utf8Kt.readString($this$readLine, lfIndex);
            $this$readLine.skip(skipBytes);
            string = string2;
        }
        return string;
    }

    @NotNull
    public static final String readLineStrict(@NotNull Source $this$readLineStrict, long limit) {
        Intrinsics.checkNotNullParameter((Object)$this$readLineStrict, (String)"<this>");
        if (!(limit >= 0L)) {
            boolean bl = false;
            String string = "limit (" + limit + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        $this$readLineStrict.require(1L);
        long lfIndex = SourcesKt.indexOf($this$readLineStrict, (byte)10, 0L, limit);
        if (lfIndex == 0L) {
            $this$readLineStrict.skip(1L);
            return "";
        }
        if (lfIndex > 0L) {
            long skipBytes = 1L;
            if ($this$readLineStrict.getBuffer().get(lfIndex - 1L) == 13) {
                --lfIndex;
                ++skipBytes;
            }
            String str = Utf8Kt.readString($this$readLineStrict, lfIndex);
            $this$readLineStrict.skip(skipBytes);
            return str;
        }
        if ($this$readLineStrict.getBuffer().getSize() < limit) {
            throw new EOFException();
        }
        if (limit == Long.MAX_VALUE) {
            throw new EOFException();
        }
        if (!$this$readLineStrict.request(limit + 1L)) {
            throw new EOFException();
        }
        byte b = $this$readLineStrict.getBuffer().get(limit);
        if (b == 10) {
            String str = Utf8Kt.readString($this$readLineStrict, limit);
            $this$readLineStrict.skip(1L);
            return str;
        }
        if (b != 13 || !$this$readLineStrict.request(limit + (long)2)) {
            throw new EOFException();
        }
        if ($this$readLineStrict.getBuffer().get(limit + 1L) != 10) {
            throw new EOFException();
        }
        String res = Utf8Kt.readString($this$readLineStrict, limit);
        $this$readLineStrict.skip(2L);
        return res;
    }

    public static /* synthetic */ String readLineStrict$default(Source source, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = Long.MAX_VALUE;
        }
        return Utf8Kt.readLineStrict(source, l);
    }

    private static final int commonReadUtf8CodePoint(Buffer $this$commonReadUtf8CodePoint) {
        byte $this$and$iv;
        $this$commonReadUtf8CodePoint.require(1L);
        byte b0 = $this$commonReadUtf8CodePoint.get(0L);
        int codePoint = 0;
        int byteCount = 0;
        int min = 0;
        byte by = b0;
        int other$iv = 128;
        byte $i$f$and = 0;
        if (($this$and$iv & other$iv) == 0) {
            $this$and$iv = b0;
            other$iv = 127;
            $i$f$and = 0;
            codePoint = $this$and$iv & other$iv;
            byteCount = 1;
            min = 0;
        } else {
            $this$and$iv = b0;
            other$iv = 224;
            $i$f$and = 0;
            if (($this$and$iv & other$iv) == 192) {
                $this$and$iv = b0;
                other$iv = 31;
                $i$f$and = 0;
                codePoint = $this$and$iv & other$iv;
                byteCount = 2;
                min = 128;
            } else {
                $this$and$iv = b0;
                other$iv = 240;
                $i$f$and = 0;
                if (($this$and$iv & other$iv) == 224) {
                    $this$and$iv = b0;
                    other$iv = 15;
                    $i$f$and = 0;
                    codePoint = $this$and$iv & other$iv;
                    byteCount = 3;
                    min = 2048;
                } else {
                    $this$and$iv = b0;
                    other$iv = 248;
                    $i$f$and = 0;
                    if (($this$and$iv & other$iv) == 240) {
                        $this$and$iv = b0;
                        other$iv = 7;
                        $i$f$and = 0;
                        codePoint = $this$and$iv & other$iv;
                        byteCount = 4;
                        min = 65536;
                    } else {
                        $this$commonReadUtf8CodePoint.skip(1L);
                        return 65533;
                    }
                }
            }
        }
        if ($this$commonReadUtf8CodePoint.getSize() < (long)byteCount) {
            throw new EOFException("size < " + byteCount + ": " + $this$commonReadUtf8CodePoint.getSize() + " (to read code point prefixed 0x" + _UtilKt.toHexString(b0) + ')');
        }
        for (int i = 1; i < byteCount; ++i) {
            byte $this$and$iv2;
            byte b;
            $i$f$and = b = $this$commonReadUtf8CodePoint.get(i);
            int other$iv2 = 192;
            boolean $i$f$and2 = false;
            if (($this$and$iv2 & other$iv2) == 128) {
                codePoint <<= 6;
                $this$and$iv2 = b;
                other$iv2 = 63;
                $i$f$and2 = false;
                codePoint |= $this$and$iv2 & other$iv2;
                continue;
            }
            $this$commonReadUtf8CodePoint.skip(i);
            return 65533;
        }
        $this$commonReadUtf8CodePoint.skip(byteCount);
        return codePoint > 0x10FFFF ? 65533 : ((55296 <= codePoint ? codePoint < 57344 : false) ? 65533 : (codePoint < min ? 65533 : codePoint));
    }

    private static final void commonWriteUtf8(Buffer $this$commonWriteUtf8, int beginIndex, int endIndex, Function1<? super Integer, Character> charAt) {
        boolean $i$f$commonWriteUtf8 = false;
        int i = beginIndex;
        while (i < endIndex) {
            char low;
            char c;
            block9: {
                block8: {
                    c = ((Character)charAt.invoke((Object)i)).charValue();
                    if (c < '\u0080') {
                        Segment tail = $this$commonWriteUtf8.writableSegment(1);
                        byte[] data = tail.data;
                        int segmentOffset = tail.getLimit() - i;
                        int runLimit = Math.min(endIndex, 8192 - segmentOffset);
                        data[segmentOffset + i++] = (byte)c;
                        while (i < runLimit && (c = ((Character)charAt.invoke((Object)i)).charValue()) < '\u0080') {
                            data[segmentOffset + i++] = (byte)c;
                        }
                        int runSize = i + segmentOffset - tail.getLimit();
                        tail.setLimit(tail.getLimit() + runSize);
                        $this$commonWriteUtf8.setSizeMut($this$commonWriteUtf8.getSizeMut() + (long)runSize);
                        continue;
                    }
                    if (c < '\u0800') {
                        Segment tail = $this$commonWriteUtf8.writableSegment(2);
                        tail.data[tail.getLimit()] = (byte)(c >> 6 | 0xC0);
                        tail.data[tail.getLimit() + 1] = (byte)(c & 0x3F | 0x80);
                        tail.setLimit(tail.getLimit() + 2);
                        $this$commonWriteUtf8.setSizeMut($this$commonWriteUtf8.getSizeMut() + 2L);
                        ++i;
                        continue;
                    }
                    if (c < '\ud800' || c > '\udfff') {
                        Segment tail = $this$commonWriteUtf8.writableSegment(3);
                        tail.data[tail.getLimit()] = (byte)(c >> 12 | 0xE0);
                        tail.data[tail.getLimit() + 1] = (byte)(c >> 6 & 0x3F | 0x80);
                        tail.data[tail.getLimit() + 2] = (byte)(c & 0x3F | 0x80);
                        tail.setLimit(tail.getLimit() + 3);
                        $this$commonWriteUtf8.setSizeMut($this$commonWriteUtf8.getSizeMut() + 3L);
                        ++i;
                        continue;
                    }
                    char c2 = low = i + 1 < endIndex ? ((Character)charAt.invoke((Object)(i + 1))).charValue() : (char)'\u0000';
                    if (c > '\udbff') break block8;
                    if ('\udc00' <= low ? low < '\ue000' : false) break block9;
                }
                $this$commonWriteUtf8.writeByte((byte)63);
                ++i;
                continue;
            }
            int codePoint = 65536 + ((c & 0x3FF) << 10 | low & 0x3FF);
            Segment tail = $this$commonWriteUtf8.writableSegment(4);
            tail.data[tail.getLimit()] = (byte)(codePoint >> 18 | 0xF0);
            tail.data[tail.getLimit() + 1] = (byte)(codePoint >> 12 & 0x3F | 0x80);
            tail.data[tail.getLimit() + 2] = (byte)(codePoint >> 6 & 0x3F | 0x80);
            tail.data[tail.getLimit() + 3] = (byte)(codePoint & 0x3F | 0x80);
            tail.setLimit(tail.getLimit() + 4);
            $this$commonWriteUtf8.setSizeMut($this$commonWriteUtf8.getSizeMut() + 4L);
            i += 2;
        }
    }

    private static final void commonWriteUtf8CodePoint(Buffer $this$commonWriteUtf8CodePoint, int codePoint) {
        if (codePoint < 0 || codePoint > 0x10FFFF) {
            throw new IllegalArgumentException("Code point value is out of Unicode codespace 0..0x10ffff: 0x" + _UtilKt.toHexString(codePoint) + " (" + codePoint + ')');
        }
        if (codePoint < 128) {
            $this$commonWriteUtf8CodePoint.writeByte((byte)codePoint);
        } else if (codePoint < 2048) {
            Segment tail = $this$commonWriteUtf8CodePoint.writableSegment(2);
            tail.data[tail.getLimit()] = (byte)(codePoint >> 6 | 0xC0);
            tail.data[tail.getLimit() + 1] = (byte)(codePoint & 0x3F | 0x80);
            tail.setLimit(tail.getLimit() + 2);
            $this$commonWriteUtf8CodePoint.setSizeMut($this$commonWriteUtf8CodePoint.getSizeMut() + 2L);
        } else {
            boolean bl = 55296 <= codePoint ? codePoint < 57344 : false;
            if (bl) {
                $this$commonWriteUtf8CodePoint.writeByte((byte)63);
            } else if (codePoint < 65536) {
                Segment tail = $this$commonWriteUtf8CodePoint.writableSegment(3);
                tail.data[tail.getLimit()] = (byte)(codePoint >> 12 | 0xE0);
                tail.data[tail.getLimit() + 1] = (byte)(codePoint >> 6 & 0x3F | 0x80);
                tail.data[tail.getLimit() + 2] = (byte)(codePoint & 0x3F | 0x80);
                tail.setLimit(tail.getLimit() + 3);
                $this$commonWriteUtf8CodePoint.setSizeMut($this$commonWriteUtf8CodePoint.getSizeMut() + 3L);
            } else {
                Segment tail = $this$commonWriteUtf8CodePoint.writableSegment(4);
                tail.data[tail.getLimit()] = (byte)(codePoint >> 18 | 0xF0);
                tail.data[tail.getLimit() + 1] = (byte)(codePoint >> 12 & 0x3F | 0x80);
                tail.data[tail.getLimit() + 2] = (byte)(codePoint >> 6 & 0x3F | 0x80);
                tail.data[tail.getLimit() + 3] = (byte)(codePoint & 0x3F | 0x80);
                tail.setLimit(tail.getLimit() + 4);
                $this$commonWriteUtf8CodePoint.setSizeMut($this$commonWriteUtf8CodePoint.getSizeMut() + 4L);
            }
        }
    }

    private static final String commonReadUtf8(Buffer $this$commonReadUtf8, long byteCount) {
        if (!(byteCount >= 0L && byteCount <= Integer.MAX_VALUE)) {
            boolean $i$a$-require-Utf8Kt$commonReadUtf8$22 = false;
            String $i$a$-require-Utf8Kt$commonReadUtf8$22 = "byteCount (" + byteCount + ") is not within the range [0..2147483647)";
            throw new IllegalArgumentException($i$a$-require-Utf8Kt$commonReadUtf8$22.toString());
        }
        $this$commonReadUtf8.require(byteCount);
        if (byteCount == 0L) {
            return "";
        }
        Segment segment = $this$commonReadUtf8.getHead();
        Intrinsics.checkNotNull((Object)segment);
        Segment s = segment;
        if ((long)s.getPos() + byteCount > (long)s.getLimit()) {
            return _Utf8Kt.commonToUtf8String$default(SourcesKt.readByteArray($this$commonReadUtf8, (int)byteCount), 0, 0, 3, null);
        }
        String result = _Utf8Kt.commonToUtf8String(s.data, s.getPos(), s.getPos() + (int)byteCount);
        s.setPos(s.getPos() + (int)byteCount);
        $this$commonReadUtf8.setSizeMut($this$commonReadUtf8.getSizeMut() - byteCount);
        if (s.getPos() == s.getLimit()) {
            $this$commonReadUtf8.recycleHead$kotlinx_io_core();
        }
        return result;
    }
}

