/*
 * Decompiled with CFR 0.152.
 */
package net.ellerton.japng.chunks;

import java.util.Arrays;
import net.ellerton.japng.error.PngException;
import net.ellerton.japng.error.PngIntegrityException;

public class PngPalette {
    public final byte[] rgb888;
    public final int[] rgba8888;
    public final int numColours;
    public static final int LENGTH_RGB_BYTES = 3;
    public static final int BYTE_INITIAL_ALPHA = 255;

    public PngPalette(byte[] rgb888, int[] rgba8888) {
        this.rgb888 = rgb888;
        this.rgba8888 = rgba8888;
        this.numColours = rgb888.length / 3;
    }

    public static PngPalette from(byte[] source, int first, int length) throws PngException {
        if (length % 3 != 0) {
            throw new PngIntegrityException(String.format("Invalid palette data length: %d (not a multiple of 3)", length));
        }
        return new PngPalette(Arrays.copyOfRange(source, first, first + length), PngPalette.rgba8888From(source, first, length));
    }

    private static int[] rgba8888From(byte[] source, int first, int length) {
        int last = first + length;
        int numColours = length / 3;
        int[] rgba8888 = new int[numColours];
        int j = 0;
        for (int i = first; i < last; i += 3) {
            rgba8888[j] = source[i] << 24 | source[i + 1] << 16 | source[i + 2] << 8 | 0xFF;
            ++j;
        }
        return rgba8888;
    }
}

