/*
 * Decompiled with CFR 0.152.
 */
package net.ellerton.japng.reader;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.ellerton.japng.reader.PngSource;
import net.ellerton.japng.util.IoHelper;

public class PngAtOnceSource
implements PngSource {
    final byte[] bytes;
    private final ByteArrayInputStream bis;
    private final DataInputStream dis;

    public PngAtOnceSource(byte[] bytes) {
        this.bytes = bytes;
        this.bis = new ByteArrayInputStream(this.bytes);
        this.dis = new DataInputStream(this.bis);
    }

    @Override
    public int getLength() {
        return this.bytes == null ? 0 : this.bytes.length;
    }

    @Override
    public boolean supportsByteAccess() {
        return true;
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.bytes;
    }

    @Override
    public byte readByte() throws IOException {
        return this.dis.readByte();
    }

    @Override
    public short readUnsignedShort() throws IOException {
        return (short)this.dis.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.dis.readInt();
    }

    @Override
    public long skip(int chunkLength) throws IOException {
        return this.dis.skip(chunkLength);
    }

    @Override
    public int tell() {
        return this.bytes.length - this.bis.available();
    }

    @Override
    public int available() {
        return this.bis.available();
    }

    @Override
    public DataInputStream getDis() {
        return this.dis;
    }

    @Override
    public InputStream slice(int dataLength) throws IOException {
        ByteArrayInputStream slice = new ByteArrayInputStream(this.bytes, this.tell(), dataLength);
        this.skip(dataLength);
        return slice;
    }

    public static PngAtOnceSource from(InputStream is) throws IOException {
        return new PngAtOnceSource(IoHelper.toByteArray(is));
    }
}

