/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.client;

import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.LavenderCommands;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.BookContentLoader;
import io.wispforest.lavender.book.BookLoader;
import io.wispforest.lavender.book.Entry;
import io.wispforest.lavender.book.LavenderBookItem;
import io.wispforest.lavender.client.BlitCutoutProgram;
import io.wispforest.lavender.client.BookBakedModel;
import io.wispforest.lavender.client.LavenderBookScreen;
import io.wispforest.lavender.client.OffhandBookRenderer;
import io.wispforest.lavender.client.StructureOverlayRenderer;
import io.wispforest.lavender.md.ItemListComponent;
import io.wispforest.lavender.structure.LavenderStructures;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.hud.Hud;
import io.wispforest.owo.ui.parsing.UIParsing;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class LavenderClient
implements ClientModInitializer {
    public static final BlitCutoutProgram BLIT_CUTOUT_PROGRAM = new BlitCutoutProgram();
    private static final Int2ObjectMap<Size> TEXTURE_SIZES = new Int2ObjectOpenHashMap();
    private static final class_2960 ENTRY_HUD_ID = Lavender.id("entry_hud");
    private static UUID currentWorldId = null;

    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register(LavenderCommands.Client::register);
        ModelLoadingPlugin.register(pluginContext -> pluginContext.resolveModel().register(context -> {
            if (!context.id().equals((Object)Lavender.id("item/dynamic_book"))) {
                return null;
            }
            return new BookBakedModel.Unbaked();
        }));
        StructureOverlayRenderer.initialize();
        OffhandBookRenderer.initialize();
        LavenderStructures.initialize();
        BookLoader.initialize();
        BookContentLoader.initialize();
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            BookLoader.reload(class_310.method_1551().method_1478());
            BookContentLoader.reloadContents(class_310.method_1551().method_1478());
        });
        Hud.add((class_2960)ENTRY_HUD_ID, () -> Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(5).positioning(Positioning.across((int)50, (int)52)));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            Component patt0$temp;
            if (client.field_1687 == null || !((patt0$temp = Hud.getComponent((class_2960)ENTRY_HUD_ID)) instanceof FlowLayout)) {
                return;
            }
            FlowLayout hudComponent = (FlowLayout)patt0$temp;
            hudComponent.configure(container -> {
                container.clearChildren();
                Book book = LavenderBookItem.bookOf(client.field_1724.method_6047());
                if (book == null) {
                    book = LavenderBookItem.bookOf(client.field_1724.method_6079());
                }
                if (book == null) {
                    return;
                }
                class_239 patt0$temp = client.field_1765;
                if (!(patt0$temp instanceof class_3965)) {
                    return;
                }
                class_3965 hitResult = (class_3965)patt0$temp;
                class_1792 item = client.field_1687.method_8320(hitResult.method_17777()).method_26204().method_8389();
                if (item == class_1802.field_8162) {
                    return;
                }
                Entry associatedEntry = book.entryByAssociatedItem(item.method_7854());
                if (associatedEntry == null || !associatedEntry.canPlayerView(client.field_1724)) {
                    return;
                }
                container.child((Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child(associatedEntry.iconFactory().apply(Sizing.fixed((int)16)).margins(Insets.of((int)0, (int)1, (int)0, (int)1))).child(Components.item((class_1799)LavenderBookItem.itemOf(book)).sizing(Sizing.fixed((int)8)).positioning(Positioning.absolute((int)9, (int)9)).zIndex(50)));
                container.child((Component)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).child((Component)Components.label((class_2561)class_2561.method_43470((String)associatedEntry.title())).shadow(true)).child((Component)Components.label((class_2561)class_2561.method_43471((String)(client.field_1724.method_5715() ? "text.lavender.entry_hud.click_to_view" : "text.lavender.entry_hud.sneak_to_view")))));
            });
        });
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            class_1799 stack = player.method_5998(hand);
            if (!player.method_5715()) {
                return class_1269.field_5811;
            }
            Book book = LavenderBookItem.bookOf(stack);
            if (book == null) {
                return class_1269.field_5811;
            }
            class_1792 item = world.method_8320(hitResult.method_17777()).method_26204().method_8389();
            if (item == class_1802.field_8162) {
                return class_1269.field_5811;
            }
            Entry associatedEntry = book.entryByAssociatedItem(item.method_7854());
            if (associatedEntry == null || !associatedEntry.canPlayerView((class_746)player)) {
                return class_1269.field_5811;
            }
            LavenderBookScreen.pushEntry(book, associatedEntry);
            class_310.method_1551().method_1507((class_437)new LavenderBookScreen(book));
            player.method_6104(hand);
            return class_1269.field_5814;
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Lavender.WORLD_ID_CHANNEL, (client, handler, buf, responseSender) -> {
            currentWorldId = buf.method_10790();
        });
        UIParsing.registerFactory((class_2960)Lavender.id("ingredient"), element -> {
            Lavender.LOGGER.warn("Deprecated <ingredient> element used, migrate to <item-list> instead");
            return new ItemListComponent();
        });
        UIParsing.registerFactory((class_2960)Lavender.id("item-list"), element -> new ItemListComponent());
    }

    public static UUID currentWorldId() {
        return currentWorldId;
    }

    public static void registerTextureSize(int textureId, int width, int height) {
        TEXTURE_SIZES.put(textureId, (Object)Size.of((int)width, (int)height));
    }

    @Nullable
    public static Size getTextureSize(class_2960 texture) {
        return (Size)TEXTURE_SIZES.get(class_310.method_1551().method_1531().method_4619(texture).method_4624());
    }
}

