/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.client;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.client.LavenderBookScreen;
import io.wispforest.lavender.pond.LavenderFramebufferExtension;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import java.util.function.Supplier;
import net.minecraft.class_1041;
import net.minecraft.class_1044;
import net.minecraft.class_1306;
import net.minecraft.class_1921;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_6367;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class OffhandBookRenderer {
    public static boolean rendering = false;
    private static final Supplier<class_276> BACK_BUFFER = Suppliers.memoize(() -> {
        class_1041 window = class_310.method_1551().method_22683();
        class_6367 framebuffer = new class_6367(window.method_4489(), window.method_4506(), true, class_310.field_1703);
        ((LavenderFramebufferExtension)framebuffer).lavender$setUseCutoutBlit();
        framebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        return framebuffer;
    });
    private static final Supplier<class_276> DISPLAY_BUFFER = Suppliers.memoize(() -> {
        class_1041 window = class_310.method_1551().method_22683();
        class_6367 framebuffer = new class_6367(window.method_4489(), window.method_4506(), true, class_310.field_1703);
        framebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        return framebuffer;
    });
    private static LavenderBookScreen cachedScreen = null;
    private static boolean cacheExpired = true;

    public static void initialize() {
        WindowResizeCallback.EVENT.register((client, window) -> {
            DISPLAY_BUFFER.get().method_1234(window.method_4489(), window.method_4506(), class_310.field_1703);
            BACK_BUFFER.get().method_1234(window.method_4489(), window.method_4506(), class_310.field_1703);
            cachedScreen = null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginFrame(@Nullable Book book) {
        cacheExpired = true;
        if (book == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        rendering = true;
        class_276 backBuffer = BACK_BUFFER.get();
        try {
            LavenderBookScreen screen = cachedScreen;
            if (screen == null || screen.book != book) {
                cachedScreen = screen = new LavenderBookScreen(book, true);
                screen.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
                screen.adapter().dispose();
            }
            class_4587 modelView = RenderSystem.getModelViewStack();
            modelView.method_22903();
            modelView.method_34426();
            modelView.method_46416(0.0f, 0.0f, -2000.0f);
            RenderSystem.applyModelViewMatrix();
            backBuffer.method_1230(class_310.field_1703);
            backBuffer.method_1235(false);
            screen.method_25394(new class_332(client, client.method_22940().method_23000()), -69, -69, 0.0f);
            RenderSystem.disableDepthTest();
            modelView.method_22909();
            RenderSystem.applyModelViewMatrix();
            class_276 displayBuffer = DISPLAY_BUFFER.get();
            displayBuffer.method_1230(class_310.field_1703);
            displayBuffer.method_1235(false);
            backBuffer.method_22594(backBuffer.field_1482, backBuffer.field_1481, false);
            client.method_1522().method_1235(false);
        }
        finally {
            rendering = false;
        }
    }

    public static void render(class_4587 matrices, int light) {
        cacheExpired = false;
        class_310 client = class_310.method_1551();
        class_276 framebuffer = DISPLAY_BUFFER.get();
        FramebufferTexture texture = new FramebufferTexture(framebuffer.method_30277());
        client.method_1531().method_4616(Lavender.id("offhand_book_framebuffer"), (class_1044)texture);
        boolean rightHanded = client.field_1724.method_6068() == class_1306.field_6183;
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rightHanded ? 15.0f : -15.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-10.0f));
        matrices.method_22905(1.0f * ((float)framebuffer.field_1482 / (float)framebuffer.field_1481), 1.0f, 1.0f);
        matrices.method_46416(rightHanded ? -0.4f : -0.6f, -0.35f, -0.165f);
        class_4588 buffer = client.method_22940().method_23000().getBuffer(class_1921.method_23028((class_2960)Lavender.id("offhand_book_framebuffer")));
        Matrix4f matrix = matrices.method_23760().method_23761();
        buffer.method_22918(matrix, 0.0f, 1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 1.0f).method_22916(light).method_1344();
        buffer.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(0.0f, 0.0f).method_22916(light).method_1344();
        buffer.method_22918(matrix, 1.0f, 0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 0.0f).method_22916(light).method_1344();
        buffer.method_22918(matrix, 1.0f, 1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(1.0f, 1.0f).method_22916(light).method_1344();
        client.method_22940().method_23000().method_22993();
        matrices.method_22909();
    }

    public static void endFrame() {
        if (cacheExpired) {
            cachedScreen = null;
        }
    }

    private static class FramebufferTexture
    extends class_1044 {
        private FramebufferTexture(int textureId) {
            this.field_5204 = textureId;
        }

        public void method_4625(class_3300 manager) {
        }

        public void method_4528() {
        }
    }
}

