/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.bytecodecs.defaults;

import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.bytecodecs.utils.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.function.Function;

public record CollectionCodec<T, C extends Collection<T>>(ByteCodec<T> codec, Function<Integer, C> creator) implements ByteCodec<C>
{
    @Override
    public void encode(C value, ByteBuf buffer) {
        ByteBufUtils.writeVarInt(buffer, value.size());
        for (Object t : value) {
            this.codec.encode(t, buffer);
        }
    }

    @Override
    public C decode(ByteBuf buffer) {
        int size = ByteBufUtils.readVarInt(buffer);
        Collection list = (Collection)this.creator.apply(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.codec.decode(buffer));
        }
        return (C)list;
    }
}

