/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.bytecodecs.defaults;

import com.teamresourceful.bytecodecs.base.ByteCodec;
import io.netty.buffer.ByteBuf;
import java.util.function.Function;

public record KeyDispatchCodec<K, V>(ByteCodec<K> keyCodec, Function<K, ByteCodec<V>> getter, Function<V, K> keyGetter) implements ByteCodec<V>
{
    @Override
    public void encode(V value, ByteBuf buffer) {
        K key = this.keyGetter.apply(value);
        this.keyCodec.encode(key, buffer);
        ByteCodec<V> codec = this.getter.apply(key);
        codec.encode(value, buffer);
    }

    @Override
    public V decode(ByteBuf buffer) {
        K key = this.keyCodec.decode(buffer);
        ByteCodec<V> codec = this.getter.apply(key);
        return codec.decode(buffer);
    }
}

