/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.bytecodecs.utils;

import io.netty.buffer.ByteBuf;
import java.util.UUID;

public final class ByteBufUtils {
    public static void writeVarInt(ByteBuf buffer, int input) {
        while ((input & 0xFFFFFF80) != 0) {
            buffer.writeByte(input & 0x7F | 0x80);
            input >>>= 7;
        }
        buffer.writeByte(input);
    }

    public static int readVarInt(ByteBuf buffer) {
        byte b;
        int i = 0;
        int j = 0;
        do {
            b = buffer.readByte();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b & 0x80) == 128);
        return i;
    }

    public static void writeVarLong(ByteBuf buffer, long value) {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer.writeByte((int)(value & 0x7FL) | 0x80);
            value >>>= 7;
        }
        buffer.writeByte((int)value);
    }

    public static long readVarLong(ByteBuf buffer) {
        byte b;
        long l = 0L;
        int i = 0;
        do {
            b = buffer.readByte();
            l |= (long)(b & 0x7F) << i++ * 7;
            if (i <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((b & 0x80) == 128);
        return l;
    }

    public static void writeUUID(ByteBuf buffer, UUID uuid) {
        buffer.writeLong(uuid.getMostSignificantBits());
        buffer.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID readUUID(ByteBuf buffer) {
        return new UUID(buffer.readLong(), buffer.readLong());
    }
}

