/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.pride;

import io.github.queerbric.pride.PrideFlagShape;
import io.github.queerbric.pride.PrideFlagShapes;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class PrideFlag {
    private final String id;
    private final PrideFlagShape shape;
    private final IntList colors;
    private final class_2960 shapeId;

    protected PrideFlag(String id, Properties props) {
        this.id = id;
        this.shapeId = props.shape == null ? new class_2960("pride", "horizontal_stripes") : (props.shape.contains(":") ? class_2960.method_12829((String)props.shape) : new class_2960("pride", props.shape));
        this.shape = PrideFlagShapes.get(this.shapeId);
        if (this.shape == null) {
            throw new IllegalArgumentException("Unknown pride flag shape " + this.shapeId);
        }
        IntArrayList colorsTmp = new IntArrayList(props.colors.length);
        for (String color : props.colors) {
            colorsTmp.add(Integer.parseInt(color.substring(1), 16) | 0xFF000000);
        }
        this.colors = IntLists.unmodifiable((IntList)colorsTmp);
    }

    public String getId() {
        return this.id;
    }

    public PrideFlagShape getShape() {
        return this.shape;
    }

    public class_2960 getShapeId() {
        return this.shapeId;
    }

    public IntList getColors() {
        return this.colors;
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_4587 matrices, float x, float y, float width, float height) {
        this.shape.render(this.colors, matrices, x, y, width, height);
    }

    static class Properties {
        public String shape;
        public String[] colors;

        Properties() {
        }
    }
}

