/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base;

import com.ishland.c2me.base.common.config.ConfigSystem;
import io.netty.util.internal.PlatformDependent;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;

public class ModuleEntryPoint {
    private static final boolean enabled = true;
    private static final String DEFAULT_EXPRESSION = "\n    max(\n        1,\n        min(\n            if( is_windows,\n                (cpus / 1.6 - 2),\n                (cpus / 1.2 - 2)\n            ),\n            if( is_j9vm,\n                ( ( mem_gb - (if(is_client, 0.6, 0.2)) ) / 0.4 ),\n                ( ( mem_gb - (if(is_client, 1.2, 0.6)) ) / 0.6 )\n            )\n        ) - if(is_client, 2, 0)\n    )\n ";
    public static final String defaultGlobalExecutorParallelismExpression;
    public static final boolean disableLoggingShutdownHook;
    public static final int defaultParallelism;
    public static final long globalExecutorParallelism;

    private static int tryEvaluateExpression(String expression) {
        return (int)Math.max(1.0, new ExpressionBuilder(expression).variables(new String[]{"is_windows", "is_j9vm", "is_client", "cpus", "mem_gb"}).function(new Function("max", 2){

            public double apply(double ... args) {
                return Math.max(args[0], args[1]);
            }
        }).function(new Function("min", 2){

            public double apply(double ... args) {
                return Math.min(args[0], args[1]);
            }
        }).function(new Function("if", 3){

            public double apply(double ... args) {
                return args[0] != 0.0 ? args[1] : args[2];
            }
        }).build().setVariable("is_windows", PlatformDependent.isWindows() ? 1.0 : 0.0).setVariable("is_j9vm", PlatformDependent.isJ9Jvm() ? 1.0 : 0.0).setVariable("is_client", FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? 1.0 : 0.0).setVariable("cpus", (double)Runtime.getRuntime().availableProcessors()).setVariable("mem_gb", (double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0 / 1024.0).evaluate());
    }

    static {
        int value;
        defaultGlobalExecutorParallelismExpression = new ConfigSystem.ConfigAccessor().key("defaultGlobalExecutorParallelismExpression").comment("\nThe expression for the default value of global executor parallelism. \nThis is used when the parallelism isn't overridden.\nAvailable variables: is_windows, is_j9vm, is_client, cpus, mem_gb\n".indent(1)).getString(DEFAULT_EXPRESSION, DEFAULT_EXPRESSION);
        disableLoggingShutdownHook = new ConfigSystem.ConfigAccessor().key("fixes.disableLoggingShutdownHook").comment("\nWhether to disable the shutdown hook of log4j2 on dedicated servers.\nEnabling this also makes the JVM exit when the dedicated server is considered fully shut down.\nThis option have no effect on client-side.\nWe has historically been doing this, and this config option allows you to disable this behavior.\n".indent(1)).incompatibleMod("textile_backup", "*").getBoolean(true, false);
        int defaultEval = ModuleEntryPoint.tryEvaluateExpression(DEFAULT_EXPRESSION);
        try {
            value = ModuleEntryPoint.tryEvaluateExpression(defaultGlobalExecutorParallelismExpression);
        }
        catch (Throwable t) {
            ConfigSystem.LOGGER.error("Failed to evaluate defaultGlobalExecutorParallelismExpression, falling back to default value", t);
            value = defaultEval;
        }
        defaultParallelism = value;
        globalExecutorParallelism = new ConfigSystem.ConfigAccessor().key("globalExecutorParallelism").comment("Configures the parallelism of global executor").getLong(value, value, ConfigSystem.LongChecks.THREAD_COUNT);
        ConfigSystem.LOGGER.info("Global Executor Parallelism: {} configured, {} evaluated, {} default evaluated", new Object[]{globalExecutorParallelism, defaultParallelism, defaultEval});
    }
}

