/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.scheduler;

import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.base.common.scheduler.AbstractPosAwarePrioritizedTask;
import com.ishland.c2me.base.common.scheduler.WrappingTask;
import com.ishland.flowsched.structs.SimpleObjectPool;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1923;
import net.minecraft.class_8563;

public class SchedulingManager {
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    public static final int MAX_LEVEL = class_8563.field_44849 + 1;
    private final Long2ReferenceOpenHashMap<ObjectArraySet<AbstractPosAwarePrioritizedTask>> pos2Tasks = new Long2ReferenceOpenHashMap();
    private final SimpleObjectPool<ObjectArraySet<AbstractPosAwarePrioritizedTask>> pos2TasksPool = new SimpleObjectPool<ObjectArraySet>(unused -> new ObjectArraySet(), ObjectArraySet::clear, ObjectArraySet::clear, 2048);
    private final Long2IntOpenHashMap prioritiesFromLevel = new Long2IntOpenHashMap();
    private final Object schedulingMutex = new Object();
    private final int id = COUNTER.getAndIncrement();
    private class_1923 currentSyncLoad = null;
    private final Executor executor;

    public SchedulingManager(Executor executor) {
        this.prioritiesFromLevel.defaultReturnValue(MAX_LEVEL);
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(AbstractPosAwarePrioritizedTask task) {
        Object object = this.schedulingMutex;
        synchronized (object) {
            long pos = task.getPos();
            ObjectArraySet locks = (ObjectArraySet)this.pos2Tasks.computeIfAbsent(pos, unused -> this.pos2TasksPool.alloc());
            locks.add((Object)task);
            this.updatePriorityInternal(pos);
        }
        task.addPostExec(() -> {
            Object object = this.schedulingMutex;
            synchronized (object) {
                ObjectArraySet tasks = (ObjectArraySet)this.pos2Tasks.get(task.getPos());
                if (tasks != null) {
                    tasks.remove((Object)task);
                    if (tasks.isEmpty()) {
                        this.pos2Tasks.remove(task.getPos());
                        this.pos2TasksPool.release((ObjectArraySet<AbstractPosAwarePrioritizedTask>)tasks);
                    }
                }
            }
        });
        GlobalExecutors.prioritizedScheduler.schedule(task);
    }

    public void enqueue(long pos, Runnable command) {
        this.enqueue(new WrappingTask(pos, command));
    }

    public Executor positionedExecutor(long pos) {
        return command -> this.enqueue(pos, command);
    }

    public void updatePriorityFromLevel(long pos, int level) {
        this.executor.execute(() -> {
            Object object = this.schedulingMutex;
            synchronized (object) {
                if (this.prioritiesFromLevel.get(pos) == level) {
                    return;
                }
                if (level < MAX_LEVEL) {
                    this.prioritiesFromLevel.put(pos, level);
                } else {
                    this.prioritiesFromLevel.remove(pos);
                }
                this.updatePriorityInternal(pos);
            }
        });
    }

    private void updatePriorityInternal(long pos) {
        int chebyshevDistance;
        int fromLevel = this.prioritiesFromLevel.get(pos);
        int fromSyncLoad = this.currentSyncLoad != null ? ((chebyshevDistance = SchedulingManager.chebyshev(new class_1923(pos), this.currentSyncLoad)) <= 8 ? chebyshevDistance : MAX_LEVEL) : MAX_LEVEL;
        int priority = Math.min(fromLevel, fromSyncLoad);
        ObjectArraySet locks = (ObjectArraySet)this.pos2Tasks.get(pos);
        if (locks != null) {
            for (AbstractPosAwarePrioritizedTask lock : locks) {
                lock.setPriority(priority);
                GlobalExecutors.prioritizedScheduler.notifyPriorityChange(lock);
            }
        }
    }

    public void setCurrentSyncLoad(class_1923 pos) {
        this.executor.execute(() -> {
            Object object = this.schedulingMutex;
            synchronized (object) {
                if (this.currentSyncLoad != null) {
                    class_1923 lastSyncLoad = this.currentSyncLoad;
                    this.currentSyncLoad = null;
                    this.updateSyncLoadInternal(lastSyncLoad);
                }
                if (pos != null) {
                    this.currentSyncLoad = pos;
                    this.updateSyncLoadInternal(pos);
                }
            }
        });
    }

    public int getId() {
        return this.id;
    }

    private void updateSyncLoadInternal(class_1923 pos) {
        long startTime = System.nanoTime();
        for (int xOff = -8; xOff <= 8; ++xOff) {
            for (int zOff = -8; zOff <= 8; ++zOff) {
                this.updatePriorityInternal(class_1923.method_8331((int)(pos.field_9181 + xOff), (int)(pos.field_9180 + zOff)));
            }
        }
        long endTime = System.nanoTime();
    }

    private static int chebyshev(class_1923 a, class_1923 b) {
        return Math.max(Math.abs(a.field_9181 - b.field_9181), Math.abs(a.field_9180 - b.field_9180));
    }

    private static int chebyshev(long a, long b) {
        return Math.max(Math.abs(class_1923.method_8325((long)a) - class_1923.method_8325((long)b)), Math.abs(class_1923.method_8332((long)a) - class_1923.method_8332((long)b)));
    }

    private static enum ScheduleStatus {
        SCHEDULED(true, false),
        SCHEDULED_ASYNC(true, true),
        NOT_SCHEDULED(false, false);

        public final boolean success;
        public final boolean async;

        private ScheduleStatus(boolean success, boolean async) {
            this.success = success;
            this.async = async;
        }
    }
}

