/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.flowsched.executor;

import com.ishland.flowsched.executor.LockToken;
import com.ishland.flowsched.executor.SimpleTask;
import com.ishland.flowsched.executor.Task;
import com.ishland.flowsched.executor.WorkerThread;
import com.ishland.flowsched.structs.DynamicPriorityQueue;
import com.ishland.flowsched.structs.SimpleObjectPool;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class ExecutorManager {
    private final DynamicPriorityQueue<Task> globalWorkQueue = new DynamicPriorityQueue(256);
    private final Object2ReferenceOpenHashMap<LockToken, Set<Task>> lockListeners = new Object2ReferenceOpenHashMap();
    private final SimpleObjectPool<Set<Task>> lockListenersPool = new SimpleObjectPool<Set>(pool -> new ReferenceArraySet(32), Set::clear, Set::clear, 4096);
    private final Object schedulingMutex = new Object();
    final Object workerMonitor = new Object();
    private final WorkerThread[] workerThreads;

    public ExecutorManager(int workerThreadCount) {
        this(workerThreadCount, thread -> {});
    }

    public ExecutorManager(int workerThreadCount, Consumer<Thread> threadInitializer) {
        this.workerThreads = new WorkerThread[workerThreadCount];
        for (int i = 0; i < workerThreadCount; ++i) {
            WorkerThread thread = new WorkerThread(this);
            threadInitializer.accept(thread);
            thread.start();
            this.workerThreads[i] = thread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryLock(Task task) {
        Object object = this.schedulingMutex;
        synchronized (object) {
            for (LockToken token : task.lockTokens()) {
                Set listeners = (Set)this.lockListeners.get((Object)token);
                if (listeners == null) continue;
                listeners.add(task);
                return false;
            }
            for (LockToken token : task.lockTokens()) {
                assert (!this.lockListeners.containsKey((Object)token));
                this.lockListeners.put((Object)token, this.lockListenersPool.alloc());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseLocks(Task task) {
        Object object = this.schedulingMutex;
        synchronized (object) {
            for (LockToken token : task.lockTokens()) {
                Set listeners = (Set)this.lockListeners.remove((Object)token);
                if (listeners != null) {
                    for (Task listener : listeners) {
                        this.schedule0(listener);
                    }
                } else {
                    throw new IllegalStateException("Lock token " + token + " is not locked");
                }
                this.lockListenersPool.release(listeners);
            }
        }
        this.wakeup();
    }

    Task pollExecutableTask() {
        Task task;
        while ((task = this.globalWorkQueue.dequeue()) != null) {
            if (!this.tryLock(task)) continue;
            return task;
        }
        return null;
    }

    public void shutdown() {
        for (WorkerThread workerThread : this.workerThreads) {
            workerThread.shutdown();
        }
    }

    public void schedule(Task task) {
        this.schedule0(task);
        this.wakeup();
    }

    private void schedule0(Task task) {
        this.globalWorkQueue.enqueue(task, task.priority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup() {
        Object object = this.workerMonitor;
        synchronized (object) {
            this.workerMonitor.notify();
        }
    }

    public void schedule(Runnable runnable, int priority) {
        this.schedule(new SimpleTask(runnable, priority));
    }

    public Executor executor(int priority) {
        return runnable -> this.schedule(runnable, priority);
    }

    public void notifyPriorityChange(Task task) {
        this.globalWorkQueue.changePriority(task, task.priority());
    }
}

