/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.flowsched.executor;

import com.ishland.flowsched.executor.ExecutorManager;
import com.ishland.flowsched.executor.Task;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FlowSched Executor Worker Thread");
    private final ExecutorManager executorManager;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);

    public WorkerThread(ExecutorManager executorManager) {
        this.executorManager = executorManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block5: while (!this.shutdown.get()) {
            if (this.pollTasks()) continue;
            if (!this.pollTasks()) {
                Thread.interrupted();
                for (int i = 0; i < 1000; ++i) {
                    if (this.pollTasks()) continue block5;
                    LockSupport.parkNanos("Spin-waiting for tasks", 10000L);
                }
            }
            Object object = this.executorManager.workerMonitor;
            synchronized (object) {
                try {
                    this.executorManager.workerMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return;
    }

    private boolean pollTasks() {
        Task task = this.executorManager.pollExecutableTask();
        try {
            if (task != null) {
                AtomicBoolean released = new AtomicBoolean(false);
                try {
                    task.run(() -> {
                        if (released.compareAndSet(false, true)) {
                            this.executorManager.releaseLocks(task);
                        }
                    });
                }
                catch (Throwable t) {
                    try {
                        if (released.compareAndSet(false, true)) {
                            this.executorManager.releaseLocks(task);
                        }
                    }
                    catch (Throwable t1) {
                        t.addSuppressed(t1);
                        LOGGER.error("Exception thrown while releasing locks", t);
                    }
                    try {
                        task.propagateException(t);
                    }
                    catch (Throwable t1) {
                        t.addSuppressed(t1);
                        LOGGER.error("Exception thrown while propagating exception", t);
                    }
                }
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            LOGGER.error("Exception thrown while executing task", t);
            return true;
        }
    }

    public void shutdown() {
        this.shutdown.set(true);
        LockSupport.unpark(this);
    }
}

