/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.DSL;
import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.impl.block.AbstractChestBlock;
import compasses.expandedstorage.impl.block.BarrelBlock;
import compasses.expandedstorage.impl.block.ChestBlock;
import compasses.expandedstorage.impl.block.CopperBarrelBlock;
import compasses.expandedstorage.impl.block.CopperMiniStorageBlock;
import compasses.expandedstorage.impl.block.MiniStorageBlock;
import compasses.expandedstorage.impl.block.MossChestBlock;
import compasses.expandedstorage.impl.block.OpenableBlock;
import compasses.expandedstorage.impl.block.entity.BarrelBlockEntity;
import compasses.expandedstorage.impl.block.entity.ChestBlockEntity;
import compasses.expandedstorage.impl.block.entity.MiniStorageBlockEntity;
import compasses.expandedstorage.impl.block.entity.OldChestBlockEntity;
import compasses.expandedstorage.impl.block.entity.extendable.OpenableBlockEntity;
import compasses.expandedstorage.impl.block.misc.DoubleItemAccess;
import compasses.expandedstorage.impl.block.strategies.ItemAccess;
import compasses.expandedstorage.impl.block.strategies.Lockable;
import compasses.expandedstorage.impl.entity.ChestMinecart;
import compasses.expandedstorage.impl.item.BlockMutatorBehaviour;
import compasses.expandedstorage.impl.item.ChestMinecartItem;
import compasses.expandedstorage.impl.item.EntityInteractableItem;
import compasses.expandedstorage.impl.item.MutationMode;
import compasses.expandedstorage.impl.item.StorageConversionKit;
import compasses.expandedstorage.impl.item.StorageMutator;
import compasses.expandedstorage.impl.item.ToolUsageResult;
import compasses.expandedstorage.impl.misc.CommonPlatformHelper;
import compasses.expandedstorage.impl.misc.Tier;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.BlockConversionRecipe;
import compasses.expandedstorage.impl.recipe.ConversionRecipeManager;
import compasses.expandedstorage.impl.registration.Content;
import compasses.expandedstorage.impl.registration.ContentConsumer;
import compasses.expandedstorage.impl.registration.ModItems;
import compasses.expandedstorage.impl.registration.NamedValue;
import compasses.expandedstorage.impl.registration.ObjectConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1047;
import net.minecraft.class_1208;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_3708;
import net.minecraft.class_4048;
import net.minecraft.class_4732;
import net.minecraft.class_4970;
import net.minecraft.class_5955;
import net.minecraft.class_6862;
import net.minecraft.class_7699;
import org.jetbrains.annotations.Nullable;

public final class CommonMain {
    public static final class_2960 BARREL_OBJECT_TYPE = Utils.id("barrel");
    public static final class_2960 CHEST_OBJECT_TYPE = Utils.id("chest");
    public static final class_2960 OLD_CHEST_OBJECT_TYPE = Utils.id("old_chest");
    public static final class_2960 MINI_STORAGE_OBJECT_TYPE = Utils.id("mini_chest");
    private static final Map<Map.Entry<Predicate<class_2248>, MutationMode>, BlockMutatorBehaviour> BLOCK_MUTATOR_BEHAVIOURS = new HashMap<Map.Entry<Predicate<class_2248>, MutationMode>, BlockMutatorBehaviour>();
    private static final Map<class_2960, class_2960[]> CHEST_TEXTURES = new HashMap<class_2960, class_2960[]>();
    private static NamedValue<class_2591<ChestBlockEntity>> chestBlockEntityType;
    private static NamedValue<class_2591<OldChestBlockEntity>> oldChestBlockEntityType;
    private static NamedValue<class_2591<BarrelBlockEntity>> barrelBlockEntityType;
    private static NamedValue<class_2591<MiniStorageBlockEntity>> miniStorageBlockEntityType;
    private static CommonPlatformHelper platformHelper;

    public static class_2591<ChestBlockEntity> getChestBlockEntityType() {
        return chestBlockEntityType.getValue();
    }

    public static class_2591<OldChestBlockEntity> getOldChestBlockEntityType() {
        return oldChestBlockEntityType.getValue();
    }

    public static class_2591<BarrelBlockEntity> getBarrelBlockEntityType() {
        return barrelBlockEntityType.getValue();
    }

    public static class_2591<MiniStorageBlockEntity> getMiniStorageBlockEntityType() {
        return miniStorageBlockEntityType.getValue();
    }

    private static void defineTierUpgradePath(List<NamedValue<class_1792>> items, boolean wrapTooltipManually, Tier ... tiers) {
        int numTiers = tiers.length;
        for (int fromIndex = 0; fromIndex < numTiers - 1; ++fromIndex) {
            Tier fromTier = tiers[fromIndex];
            for (int toIndex = fromIndex + 1; toIndex < numTiers; ++toIndex) {
                Tier toTier = tiers[toIndex];
                class_2960 itemId = Utils.id(fromTier.getId().method_12832() + "_to_" + toTier.getId().method_12832() + "_conversion_kit");
                class_1792.class_1793 settings = (class_1792.class_1793)fromTier.getItemSettings().andThen(toTier.getItemSettings()).apply(new class_1792.class_1793().method_7889(16));
                items.add(new NamedValue<class_1792>(itemId, () -> new StorageConversionKit(settings, fromTier.getId(), toTier.getId(), wrapTooltipManually)));
            }
        }
    }

    public static void declareChestTextures(class_2960 block, class_2960 singleTexture, class_2960 leftTexture, class_2960 rightTexture, class_2960 topTexture, class_2960 bottomTexture, class_2960 frontTexture, class_2960 backTexture) {
        if (CHEST_TEXTURES.containsKey(block)) {
            throw new IllegalArgumentException("Tried registering chest textures for \"" + block + "\" which already has textures.");
        }
        class_2960[] collection = new class_2960[]{topTexture, bottomTexture, frontTexture, backTexture, leftTexture, rightTexture, singleTexture};
        CHEST_TEXTURES.put(block, collection);
    }

    public static class_2960 getChestTexture(class_2960 block, EsChestType chestType) {
        if (CHEST_TEXTURES.containsKey(block)) {
            return CHEST_TEXTURES.get(block)[chestType.ordinal()];
        }
        return class_1047.method_4539();
    }

    private static void registerMutationBehaviour(Predicate<class_2248> predicate, MutationMode mode, BlockMutatorBehaviour behaviour) {
        BLOCK_MUTATOR_BEHAVIOURS.put(Map.entry(predicate, mode), behaviour);
    }

    public static BlockMutatorBehaviour getBlockMutatorBehaviour(class_2248 block, MutationMode mode) {
        for (Map.Entry<Map.Entry<Predicate<class_2248>, MutationMode>, BlockMutatorBehaviour> entry : BLOCK_MUTATOR_BEHAVIOURS.entrySet()) {
            Map.Entry<Predicate<class_2248>, MutationMode> pair = entry.getKey();
            if (pair.getValue() != mode || !pair.getKey().test(block)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void constructContent(CommonPlatformHelper helper, Function<OpenableBlockEntity, ItemAccess> itemAccess, Supplier<Lockable> lockable, boolean isClient, ContentConsumer contentRegistrationConsumer, boolean manuallyWrapTooltips, BiFunction<ChestBlock, class_1792.class_1793, class_1747> chestItemMaker, Function<OpenableBlockEntity, ItemAccess> chestAccessMaker, BiFunction<class_1792.class_1793, class_2960, ChestMinecartItem> chestMinecartItemMaker, class_6862<class_2248> barrelTag, BiFunction<MiniStorageBlock, class_1792.class_1793, class_1747> miniChestItemMaker) {
        platformHelper = helper;
        Tier woodTier = new Tier(Utils.WOOD_TIER_ID, 27, UnaryOperator.identity(), UnaryOperator.identity());
        Tier copperTier = new Tier(Utils.COPPER_TIER_ID, 45, class_4970.class_2251::method_29292, UnaryOperator.identity());
        Tier ironTier = new Tier(Utils.id("iron"), 54, class_4970.class_2251::method_29292, UnaryOperator.identity());
        Tier goldTier = new Tier(Utils.id("gold"), 81, class_4970.class_2251::method_29292, UnaryOperator.identity());
        Tier diamondTier = new Tier(Utils.id("diamond"), 108, class_4970.class_2251::method_29292, UnaryOperator.identity());
        Tier obsidianTier = new Tier(Utils.id("obsidian"), 108, class_4970.class_2251::method_29292, UnaryOperator.identity());
        Tier netheriteTier = new Tier(Utils.id("netherite"), 135, class_4970.class_2251::method_29292, class_1792.class_1793::method_24359);
        class_4970.class_2251 woodSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_51368(class_2766.field_12651).method_9632(2.5f).method_9626(class_2498.field_11547).method_50013();
        class_4970.class_2251 pumpkinSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15987).method_51368(class_2766.field_18286).method_9632(1.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 bambooSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9632(1.0f).method_9626(class_2498.field_11542).method_50013();
        class_4970.class_2251 mossSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15995).method_9632(0.1f).method_9626(class_2498.field_28697);
        class_4970.class_2251 ironSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_16005).method_51368(class_2766.field_18284).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11533);
        class_4970.class_2251 goldSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15994).method_51368(class_2766.field_12644).method_9629(3.0f, 6.0f).method_9626(class_2498.field_11533);
        class_4970.class_2251 diamondSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15983).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11533);
        class_4970.class_2251 obsidianSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_16009).method_51368(class_2766.field_12653).method_9629(50.0f, 1200.0f);
        class_4970.class_2251 netheriteSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_16009).method_9629(50.0f, 1200.0f).method_9626(class_2498.field_22150);
        ArrayList<class_2960> stats = new ArrayList<class_2960>();
        Function<String, class_2960> statMaker = id -> {
            class_2960 statId = Utils.id(id);
            stats.add(statId);
            return statId;
        };
        ArrayList<NamedValue<class_1792>> baseItems = new ArrayList<NamedValue<class_1792>>(22);
        baseItems.add(new NamedValue<class_1792>(Utils.id("storage_mutator"), () -> new StorageMutator(new class_1792.class_1793().method_7889(1))));
        CommonMain.defineTierUpgradePath(baseItems, manuallyWrapTooltips, woodTier, copperTier, ironTier, goldTier, diamondTier, obsidianTier, netheriteTier);
        ArrayList<NamedValue<ChestBlock>> chestBlocks = new ArrayList<NamedValue<ChestBlock>>(9);
        ArrayList<NamedValue<class_1747>> chestItems = new ArrayList<NamedValue<class_1747>>(9);
        ArrayList<NamedValue<class_1299<ChestMinecart>>> chestMinecartEntityTypes = new ArrayList<NamedValue<class_1299<ChestMinecart>>>(9);
        ArrayList<NamedValue<ChestMinecartItem>> chestMinecartItems = new ArrayList<NamedValue<ChestMinecartItem>>(9);
        class_2960 woodStat = statMaker.apply("open_wood_chest");
        class_2960 pumpkinStat = statMaker.apply("open_pumpkin_chest");
        class_2960 presentStat = statMaker.apply("open_present");
        class_2960 bambooStat = statMaker.apply("open_bamboo_chest");
        class_2960 mossStat = statMaker.apply("open_moss_chest");
        class_2960 ironStat = statMaker.apply("open_iron_chest");
        class_2960 goldStat = statMaker.apply("open_gold_chest");
        class_2960 diamondStat = statMaker.apply("open_diamond_chest");
        class_2960 obsidianStat = statMaker.apply("open_obsidian_chest");
        class_2960 netheriteStat = statMaker.apply("open_netherite_chest");
        class_4970.class_2251 presentSettings = class_4970.class_2251.method_9637().method_51520(state -> {
            EsChestType type = (EsChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)));
            if (type == EsChestType.SINGLE) {
                return class_3620.field_16020;
            }
            if (type == EsChestType.FRONT || type == EsChestType.BACK) {
                return class_3620.field_16004;
            }
            return class_3620.field_16022;
        }).method_9632(2.5f).method_9626(class_2498.field_11547);
        ObjectConsumer chestMaker = (id, stat, tier, settings) -> {
            NamedValue<ChestBlock> block = new NamedValue<ChestBlock>(id, () -> new ChestBlock((class_4970.class_2251)tier.getBlockSettings().apply(settings), stat, tier.getSlotCount()));
            NamedValue<class_1747> item = new NamedValue<class_1747>(id, () -> (class_1747)chestItemMaker.apply((ChestBlock)block.getValue(), (class_1792.class_1793)tier.getItemSettings().apply(new class_1792.class_1793())));
            class_2960 cartId = new class_2960(id.method_12836(), id.method_12832() + "_minecart");
            NamedValue<ChestMinecartItem> cartItem = new NamedValue<ChestMinecartItem>(cartId, () -> (ChestMinecartItem)((Object)((Object)((Object)chestMinecartItemMaker.apply(new class_1792.class_1793(), cartId)))));
            NamedValue<class_1299> cartEntityType = new NamedValue<class_1299>(cartId, () -> new class_1299((type, level) -> new ChestMinecart(type, level, (class_1792)cartItem.getValue(), (ChestBlock)block.getValue()), class_1311.field_17715, true, true, false, false, ImmutableSet.of(), class_4048.method_18384((float)0.98f, (float)0.7f), 8, 3, class_7699.method_45397()));
            chestBlocks.add(block);
            chestItems.add(item);
            chestMinecartEntityTypes.add(cartEntityType);
            chestMinecartItems.add(cartItem);
        };
        ObjectConsumer mossChestMaker = (id, stat, tier, settings) -> {
            NamedValue<ChestBlock> block = new NamedValue<ChestBlock>(id, () -> new MossChestBlock((class_4970.class_2251)tier.getBlockSettings().apply(settings), stat, tier.getSlotCount()));
            NamedValue<class_1747> item = new NamedValue<class_1747>(id, () -> (class_1747)chestItemMaker.apply((ChestBlock)block.getValue(), (class_1792.class_1793)tier.getItemSettings().apply(new class_1792.class_1793())));
            class_2960 cartId = new class_2960(id.method_12836(), id.method_12832() + "_minecart");
            NamedValue<ChestMinecartItem> cartItem = new NamedValue<ChestMinecartItem>(cartId, () -> (ChestMinecartItem)((Object)((Object)((Object)chestMinecartItemMaker.apply(new class_1792.class_1793(), cartId)))));
            NamedValue<class_1299> cartEntityType = new NamedValue<class_1299>(cartId, () -> new class_1299((type, level) -> new ChestMinecart(type, level, (class_1792)cartItem.getValue(), (ChestBlock)block.getValue()), class_1311.field_17715, true, true, false, false, ImmutableSet.of(), class_4048.method_18384((float)0.98f, (float)0.7f), 8, 3, class_7699.method_45397()));
            chestBlocks.add(block);
            chestItems.add(item);
            chestMinecartEntityTypes.add(cartEntityType);
            chestMinecartItems.add(cartItem);
        };
        chestMaker.apply(Utils.id("wood_chest"), woodStat, woodTier, woodSettings);
        chestMaker.apply(Utils.id("pumpkin_chest"), pumpkinStat, woodTier, pumpkinSettings);
        chestMaker.apply(Utils.id("present"), presentStat, woodTier, presentSettings);
        chestMaker.apply(Utils.id("bamboo_chest"), bambooStat, woodTier, bambooSettings);
        mossChestMaker.apply(Utils.id("moss_chest"), mossStat, woodTier, mossSettings);
        chestMaker.apply(Utils.id("iron_chest"), ironStat, ironTier, ironSettings);
        chestMaker.apply(Utils.id("gold_chest"), goldStat, goldTier, goldSettings);
        chestMaker.apply(Utils.id("diamond_chest"), diamondStat, diamondTier, diamondSettings);
        chestMaker.apply(Utils.id("obsidian_chest"), obsidianStat, obsidianTier, obsidianSettings);
        chestMaker.apply(Utils.id("netherite_chest"), netheriteStat, netheriteTier, netheriteSettings);
        if (isClient) {
            chestBlocks.forEach(block -> {
                String blockId = block.getName().method_12832();
                CommonMain.declareChestTextures(block.getName(), Utils.id("entity/chest/" + blockId + "_single"), Utils.id("entity/chest/" + blockId + "_left"), Utils.id("entity/chest/" + blockId + "_right"), Utils.id("entity/chest/" + blockId + "_top"), Utils.id("entity/chest/" + blockId + "_bottom"), Utils.id("entity/chest/" + blockId + "_front"), Utils.id("entity/chest/" + blockId + "_back"));
            });
        }
        chestBlockEntityType = new NamedValue<class_2591>(CHEST_OBJECT_TYPE, () -> class_2591.class_2592.method_20528((arg_0, arg_1) -> CommonMain.lambda$constructContent$17(chestAccessMaker, (Supplier)lockable, arg_0, arg_1), (class_2248[])((class_2248[])chestBlocks.stream().map(NamedValue::getValue).toArray(ChestBlock[]::new))).method_11034(class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)CHEST_OBJECT_TYPE.toString())));
        ArrayList<NamedValue<AbstractChestBlock>> oldChestBlocks = new ArrayList<NamedValue<AbstractChestBlock>>(6);
        ArrayList<NamedValue<class_1747>> oldChestItems = new ArrayList<NamedValue<class_1747>>(6);
        class_2960 woodStat2 = statMaker.apply("open_old_wood_chest");
        class_2960 ironStat2 = statMaker.apply("open_old_iron_chest");
        class_2960 goldStat2 = statMaker.apply("open_old_gold_chest");
        class_2960 diamondStat2 = statMaker.apply("open_old_diamond_chest");
        class_2960 obsidianStat2 = statMaker.apply("open_old_obsidian_chest");
        class_2960 netheriteStat2 = statMaker.apply("open_old_netherite_chest");
        ObjectConsumer chestMaker2 = (id, stat, tier, settings) -> {
            NamedValue<AbstractChestBlock> block = new NamedValue<AbstractChestBlock>(id, () -> new AbstractChestBlock((class_4970.class_2251)tier.getBlockSettings().apply(settings), stat, tier.getSlotCount()));
            NamedValue<class_1747> item = new NamedValue<class_1747>(id, () -> new class_1747((class_2248)block.getValue(), (class_1792.class_1793)tier.getItemSettings().apply(new class_1792.class_1793())));
            oldChestBlocks.add(block);
            oldChestItems.add(item);
        };
        chestMaker2.apply(Utils.id("old_wood_chest"), woodStat2, woodTier, woodSettings);
        chestMaker2.apply(Utils.id("old_iron_chest"), ironStat2, ironTier, ironSettings);
        chestMaker2.apply(Utils.id("old_gold_chest"), goldStat2, goldTier, goldSettings);
        chestMaker2.apply(Utils.id("old_diamond_chest"), diamondStat2, diamondTier, diamondSettings);
        chestMaker2.apply(Utils.id("old_obsidian_chest"), obsidianStat2, obsidianTier, obsidianSettings);
        chestMaker2.apply(Utils.id("old_netherite_chest"), netheriteStat2, netheriteTier, netheriteSettings);
        oldChestBlockEntityType = new NamedValue<class_2591>(OLD_CHEST_OBJECT_TYPE, () -> class_2591.class_2592.method_20528((arg_0, arg_1) -> CommonMain.lambda$constructContent$23(chestAccessMaker, (Supplier)lockable, arg_0, arg_1), (class_2248[])((class_2248[])oldChestBlocks.stream().map(NamedValue::getValue).toArray(AbstractChestBlock[]::new))).method_11034(class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)OLD_CHEST_OBJECT_TYPE.toString())));
        Predicate<class_2248> isChestBlock = b -> b instanceof AbstractChestBlock;
        CommonMain.registerMutationBehaviour(isChestBlock, MutationMode.MERGE, (context, level, state, pos, stack) -> {
            class_1657 player = context.method_8036();
            if (player == null) {
                return ToolUsageResult.fail();
            }
            if (state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE) == EsChestType.SINGLE) {
                class_2487 tag = stack.method_7948();
                if (tag.method_10545("pos")) {
                    class_2338 otherPos = class_2512.method_10691((class_2487)tag.method_10562("pos"));
                    class_2680 otherState = level.method_8320(otherPos);
                    class_2338 delta = otherPos.method_10059((class_2382)pos);
                    class_2350 direction = class_2350.method_50026((int)delta.method_10263(), (int)delta.method_10264(), (int)delta.method_10260());
                    if (direction != null) {
                        if (state.method_26204() == otherState.method_26204()) {
                            if (otherState.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE) == EsChestType.SINGLE) {
                                if (state.method_11654((class_2769)class_2741.field_12481) == otherState.method_11654((class_2769)class_2741.field_12481)) {
                                    OpenableBlockEntity blockEntity;
                                    boolean secondIsDinnerbone;
                                    OpenableBlockEntity blockEntity2;
                                    class_2586 class_25862 = level.method_8321(pos);
                                    boolean firstIsDinnerbone = class_25862 instanceof OpenableBlockEntity && (blockEntity2 = (OpenableBlockEntity)class_25862).isDinnerbone();
                                    class_2586 class_25863 = level.method_8321(otherPos);
                                    boolean bl = secondIsDinnerbone = class_25863 instanceof OpenableBlockEntity && (blockEntity = (OpenableBlockEntity)class_25863).isDinnerbone();
                                    if (firstIsDinnerbone == secondIsDinnerbone) {
                                        if (!level.method_8608()) {
                                            EsChestType chestType = AbstractChestBlock.getChestType((class_2350)state.method_11654((class_2769)class_2741.field_12481), direction);
                                            level.method_8501(pos, (class_2680)state.method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)chestType)));
                                            tag.method_10551("pos");
                                            player.method_7353((class_2561)class_2561.method_43471((String)"tooltip.expandedstorage.storage_mutator.merge_end"), true);
                                        }
                                        return ToolUsageResult.slowSuccess();
                                    }
                                    player.method_7353((class_2561)class_2561.method_43471((String)"tooltip.expandedstorage.storage_mutator.merge_wrong_block"), true);
                                } else {
                                    player.method_7353((class_2561)class_2561.method_43471((String)"tooltip.expandedstorage.storage_mutator.merge_wrong_facing"), true);
                                }
                            } else {
                                player.method_7353((class_2561)class_2561.method_43471((String)"tooltip.expandedstorage.storage_mutator.merge_already_double_chest"), true);
                            }
                        } else {
                            player.method_7353((class_2561)class_2561.method_43471((String)"tooltip.expandedstorage.storage_mutator.merge_wrong_block"), true);
                        }
                    } else {
                        player.method_7353((class_2561)class_2561.method_43471((String)"tooltip.expandedstorage.storage_mutator.merge_not_adjacent"), true);
                    }
                    tag.method_10551("pos");
                } else {
                    if (!level.method_8608()) {
                        tag.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)pos));
                        player.method_7353((class_2561)class_2561.method_43469((String)"tooltip.expandedstorage.storage_mutator.merge_start", (Object[])new Object[]{Utils.ALT_USE}), true);
                    }
                    return ToolUsageResult.fastSuccess();
                }
            }
            return ToolUsageResult.fail();
        });
        CommonMain.registerMutationBehaviour(isChestBlock, MutationMode.SPLIT, (context, level, state, pos, stack) -> {
            if (state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE) != EsChestType.SINGLE) {
                if (!level.method_8608()) {
                    class_2338 otherPos = pos.method_10093(AbstractChestBlock.getDirectionToAttached(state));
                    level.method_8501(pos, (class_2680)state.method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)EsChestType.SINGLE)));
                    level.method_8501(otherPos, (class_2680)state.method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)EsChestType.SINGLE)));
                }
                return ToolUsageResult.slowSuccess();
            }
            return ToolUsageResult.fail();
        });
        CommonMain.registerMutationBehaviour(isChestBlock, MutationMode.ROTATE, (context, level, state, pos, stack) -> {
            if (!level.method_8608()) {
                EsChestType chestType = (EsChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)));
                if (chestType == EsChestType.SINGLE) {
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10170()));
                } else {
                    class_2338 otherPos = pos.method_10093(AbstractChestBlock.getDirectionToAttached(state));
                    class_2680 otherState = level.method_8320(otherPos);
                    if (chestType == EsChestType.TOP || chestType == EsChestType.BOTTOM) {
                        level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10170()));
                        level.method_8501(otherPos, (class_2680)otherState.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10170()));
                    } else {
                        level.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153())).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)((EsChestType)((Object)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)))).getOpposite())));
                        level.method_8501(otherPos, (class_2680)((class_2680)otherState.method_11657((class_2769)class_2741.field_12481, (Comparable)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153())).method_11657(AbstractChestBlock.CURSED_CHEST_TYPE, (Comparable)((Object)((EsChestType)((Object)((Object)otherState.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE)))).getOpposite())));
                    }
                }
            }
            return ToolUsageResult.slowSuccess();
        });
        ArrayList<NamedValue<BarrelBlock>> barrelBlocks = new ArrayList<NamedValue<BarrelBlock>>(5);
        ArrayList<NamedValue<class_1747>> barrelItems = new ArrayList<NamedValue<class_1747>>(5);
        class_2960 copperStat = statMaker.apply("open_copper_barrel");
        ironStat = statMaker.apply("open_iron_barrel");
        goldStat = statMaker.apply("open_gold_barrel");
        diamondStat = statMaker.apply("open_diamond_barrel");
        obsidianStat = statMaker.apply("open_obsidian_barrel");
        netheriteStat = statMaker.apply("open_netherite_barrel");
        class_4970.class_2251 copperBarrelSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_51368(class_2766.field_12651).method_9629(3.0f, 6.0f).method_9626(class_2498.field_11547).method_50013();
        class_4970.class_2251 ironBarrelSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_51368(class_2766.field_12651).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11547).method_50013();
        class_4970.class_2251 goldBarrelSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_51368(class_2766.field_12651).method_9629(3.0f, 6.0f).method_9626(class_2498.field_11547).method_50013();
        class_4970.class_2251 diamondBarrelSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_51368(class_2766.field_12651).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11547).method_50013();
        class_4970.class_2251 obsidianBarrelSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_51368(class_2766.field_12651).method_9629(50.0f, 1200.0f).method_9626(class_2498.field_11547).method_50013();
        class_4970.class_2251 netheriteBarrelSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_51368(class_2766.field_12651).method_9629(50.0f, 1200.0f).method_9626(class_2498.field_11547);
        ObjectConsumer barrelMaker = (id, stat, tier, settings) -> {
            NamedValue<BarrelBlock> block = new NamedValue<BarrelBlock>(id, () -> new BarrelBlock((class_4970.class_2251)tier.getBlockSettings().apply(settings), stat, tier.getSlotCount()));
            NamedValue<class_1747> item = new NamedValue<class_1747>(id, () -> new class_1747((class_2248)block.getValue(), (class_1792.class_1793)tier.getItemSettings().apply(new class_1792.class_1793())));
            barrelBlocks.add(block);
            barrelItems.add(item);
        };
        BiConsumer<class_2960, class_5955.class_5811> copperBarrelMaker = (id, weatherState) -> {
            NamedValue<BarrelBlock> block = new NamedValue<BarrelBlock>((class_2960)id, () -> new CopperBarrelBlock((class_4970.class_2251)copperTier.getBlockSettings().apply(copperBarrelSettings), copperStat, copperTier.getSlotCount(), (class_5955.class_5811)weatherState));
            NamedValue<class_1747> item = new NamedValue<class_1747>((class_2960)id, () -> new class_1747((class_2248)block.getValue(), (class_1792.class_1793)copperTier.getItemSettings().apply(new class_1792.class_1793())));
            barrelBlocks.add(block);
            barrelItems.add(item);
        };
        copperBarrelMaker.accept(Utils.id("copper_barrel"), class_5955.class_5811.field_28704);
        copperBarrelMaker.accept(Utils.id("exposed_copper_barrel"), class_5955.class_5811.field_28705);
        copperBarrelMaker.accept(Utils.id("weathered_copper_barrel"), class_5955.class_5811.field_28706);
        copperBarrelMaker.accept(Utils.id("oxidized_copper_barrel"), class_5955.class_5811.field_28707);
        barrelMaker.apply(Utils.id("waxed_copper_barrel"), copperStat, copperTier, copperBarrelSettings);
        barrelMaker.apply(Utils.id("waxed_exposed_copper_barrel"), copperStat, copperTier, copperBarrelSettings);
        barrelMaker.apply(Utils.id("waxed_weathered_copper_barrel"), copperStat, copperTier, copperBarrelSettings);
        barrelMaker.apply(Utils.id("waxed_oxidized_copper_barrel"), copperStat, copperTier, copperBarrelSettings);
        barrelMaker.apply(Utils.id("iron_barrel"), ironStat, ironTier, ironBarrelSettings);
        barrelMaker.apply(Utils.id("gold_barrel"), goldStat, goldTier, goldBarrelSettings);
        barrelMaker.apply(Utils.id("diamond_barrel"), diamondStat, diamondTier, diamondBarrelSettings);
        barrelMaker.apply(Utils.id("obsidian_barrel"), obsidianStat, obsidianTier, obsidianBarrelSettings);
        barrelMaker.apply(Utils.id("netherite_barrel"), netheriteStat, netheriteTier, netheriteBarrelSettings);
        barrelBlockEntityType = new NamedValue<class_2591>(BARREL_OBJECT_TYPE, () -> class_2591.class_2592.method_20528((arg_0, arg_1) -> CommonMain.lambda$constructContent$36(itemAccess, (Supplier)lockable, arg_0, arg_1), (class_2248[])((class_2248[])barrelBlocks.stream().map(NamedValue::getValue).toArray(BarrelBlock[]::new))).method_11034(class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)BARREL_OBJECT_TYPE.toString())));
        Predicate<class_2248> isUpgradableBarrelBlock = block -> block instanceof BarrelBlock || block instanceof class_3708 || block.method_9564().method_26164(barrelTag);
        CommonMain.registerMutationBehaviour(isUpgradableBarrelBlock, MutationMode.ROTATE, (context, level, state, pos, stack) -> {
            if (state.method_28498((class_2769)class_2741.field_12525)) {
                if (!level.method_8608()) {
                    level.method_8501(pos, (class_2680)state.method_28493((class_2769)class_2741.field_12525));
                }
                return ToolUsageResult.slowSuccess();
            }
            return ToolUsageResult.fail();
        });
        ArrayList<NamedValue<MiniStorageBlock>> miniStorageBlocks = new ArrayList<NamedValue<MiniStorageBlock>>();
        ArrayList<NamedValue<class_1747>> miniStorageItems = new ArrayList<NamedValue<class_1747>>();
        class_2960 woodChestStat = statMaker.apply("open_wood_mini_chest");
        class_2960 pumpkinChestStat = statMaker.apply("open_pumpkin_mini_chest");
        class_2960 redPresentStat = statMaker.apply("open_red_mini_present");
        class_2960 whitePresentStat = statMaker.apply("open_white_mini_present");
        class_2960 candyCanePresentStat = statMaker.apply("open_candy_cane_mini_present");
        class_2960 greenPresentStat = statMaker.apply("open_green_mini_present");
        class_2960 lavenderPresentStat = statMaker.apply("open_lavender_mini_present");
        class_2960 pinkAmethystPresentStat = statMaker.apply("open_pink_amethyst_mini_present");
        class_2960 ironChestStat = statMaker.apply("open_iron_mini_chest");
        class_2960 goldChestStat = statMaker.apply("open_gold_mini_chest");
        class_2960 diamondChestStat = statMaker.apply("open_diamond_mini_chest");
        class_2960 obsidianChestStat = statMaker.apply("open_obsidian_mini_chest");
        class_2960 netheriteChestStat = statMaker.apply("open_netherite_mini_chest");
        class_2960 barrelStat = statMaker.apply("open_mini_barrel");
        class_2960 copperBarrelStat = statMaker.apply("open_copper_mini_barrel");
        class_2960 ironBarrelStat = statMaker.apply("open_iron_mini_barrel");
        class_2960 goldBarrelStat = statMaker.apply("open_gold_mini_barrel");
        class_2960 diamondBarrelStat = statMaker.apply("open_diamond_mini_barrel");
        class_2960 obsidianBarrelStat = statMaker.apply("open_obsidian_mini_barrel");
        class_2960 netheriteBarrelStat = statMaker.apply("open_netherite_mini_barrel");
        class_4970.class_2251 redPresentSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_16020).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 whitePresentSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_16022).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 candyCanePresentSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_16022).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 greenPresentSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 lavenderPresentSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_16014).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 pinkAmethystPresentSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_16014).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 woodBarrelSettings = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9632(2.5f).method_9626(class_2498.field_11547);
        class_4970.class_2251 copperBarrelSettings2 = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9629(3.0f, 6.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 ironBarrelSettings2 = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 goldBarrelSettings2 = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9629(3.0f, 6.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 diamondBarrelSettings2 = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9629(5.0f, 6.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 obsidianBarrelSettings2 = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9629(50.0f, 1200.0f).method_9626(class_2498.field_11547);
        class_4970.class_2251 netheriteBarrelSettings2 = class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9629(50.0f, 1200.0f).method_9626(class_2498.field_11547);
        Function<Boolean, ObjectConsumer> miniStorageMaker = hasRibbon -> (id, stat, tier, settings) -> {
            NamedValue<MiniStorageBlock> block = new NamedValue<MiniStorageBlock>(id, () -> new MiniStorageBlock((class_4970.class_2251)tier.getBlockSettings().apply(settings), stat, (boolean)hasRibbon));
            NamedValue<class_1747> item = new NamedValue<class_1747>(id, () -> (class_1747)miniChestItemMaker.apply((MiniStorageBlock)block.getValue(), (class_1792.class_1793)tier.getItemSettings().apply(new class_1792.class_1793())));
            miniStorageBlocks.add(block);
            miniStorageItems.add(item);
        };
        ObjectConsumer miniStorageMakerNoRibbon = miniStorageMaker.apply(false);
        ObjectConsumer miniStorageMakerRibbon = miniStorageMaker.apply(true);
        BiConsumer<class_2960, class_5955.class_5811> copperMiniBarrelMaker = (id, weatherState) -> {
            NamedValue<MiniStorageBlock> block = new NamedValue<MiniStorageBlock>((class_2960)id, () -> new CopperMiniStorageBlock((class_4970.class_2251)copperTier.getBlockSettings().apply(copperBarrelSettings2), copperBarrelStat, (class_5955.class_5811)weatherState));
            NamedValue<class_1747> item = new NamedValue<class_1747>((class_2960)id, () -> (class_1747)miniChestItemMaker.apply((MiniStorageBlock)block.getValue(), (class_1792.class_1793)copperTier.getItemSettings().apply(new class_1792.class_1793())));
            miniStorageBlocks.add(block);
            miniStorageItems.add(item);
        };
        miniStorageMakerNoRibbon.apply(Utils.id("vanilla_wood_mini_chest"), woodChestStat, woodTier, woodSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("wood_mini_chest"), woodChestStat, woodTier, woodSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("pumpkin_mini_chest"), pumpkinChestStat, woodTier, pumpkinSettings);
        miniStorageMakerRibbon.apply(Utils.id("red_mini_present"), redPresentStat, woodTier, redPresentSettings);
        miniStorageMakerRibbon.apply(Utils.id("white_mini_present"), whitePresentStat, woodTier, whitePresentSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("candy_cane_mini_present"), candyCanePresentStat, woodTier, candyCanePresentSettings);
        miniStorageMakerRibbon.apply(Utils.id("green_mini_present"), greenPresentStat, woodTier, greenPresentSettings);
        miniStorageMakerRibbon.apply(Utils.id("lavender_mini_present"), lavenderPresentStat, woodTier, lavenderPresentSettings);
        miniStorageMakerRibbon.apply(Utils.id("pink_amethyst_mini_present"), pinkAmethystPresentStat, woodTier, pinkAmethystPresentSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("iron_mini_chest"), ironChestStat, ironTier, ironSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("gold_mini_chest"), goldChestStat, goldTier, goldSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("diamond_mini_chest"), diamondChestStat, diamondTier, diamondSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("obsidian_mini_chest"), obsidianChestStat, obsidianTier, obsidianSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("netherite_mini_chest"), netheriteChestStat, netheriteTier, netheriteSettings);
        miniStorageMakerNoRibbon.apply(Utils.id("mini_barrel"), barrelStat, woodTier, woodBarrelSettings);
        copperMiniBarrelMaker.accept(Utils.id("copper_mini_barrel"), class_5955.class_5811.field_28704);
        copperMiniBarrelMaker.accept(Utils.id("exposed_copper_mini_barrel"), class_5955.class_5811.field_28705);
        copperMiniBarrelMaker.accept(Utils.id("weathered_copper_mini_barrel"), class_5955.class_5811.field_28706);
        copperMiniBarrelMaker.accept(Utils.id("oxidized_copper_mini_barrel"), class_5955.class_5811.field_28707);
        miniStorageMakerNoRibbon.apply(Utils.id("waxed_copper_mini_barrel"), copperBarrelStat, copperTier, copperBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("waxed_exposed_copper_mini_barrel"), copperBarrelStat, copperTier, copperBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("waxed_weathered_copper_mini_barrel"), copperBarrelStat, copperTier, copperBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("waxed_oxidized_copper_mini_barrel"), copperBarrelStat, copperTier, copperBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("iron_mini_barrel"), ironBarrelStat, ironTier, ironBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("gold_mini_barrel"), goldBarrelStat, goldTier, goldBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("diamond_mini_barrel"), diamondBarrelStat, diamondTier, diamondBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("obsidian_mini_barrel"), obsidianBarrelStat, obsidianTier, obsidianBarrelSettings2);
        miniStorageMakerNoRibbon.apply(Utils.id("netherite_mini_barrel"), netheriteBarrelStat, netheriteTier, netheriteBarrelSettings2);
        miniStorageBlockEntityType = new NamedValue<class_2591>(MINI_STORAGE_OBJECT_TYPE, () -> class_2591.class_2592.method_20528((arg_0, arg_1) -> CommonMain.lambda$constructContent$48(itemAccess, (Supplier)lockable, arg_0, arg_1), (class_2248[])((class_2248[])miniStorageBlocks.stream().map(NamedValue::getValue).toArray(MiniStorageBlock[]::new))).method_11034(class_156.method_29187((DSL.TypeReference)class_1208.field_5727, (String)MINI_STORAGE_OBJECT_TYPE.toString())));
        Predicate<class_2248> isMiniStorage = b -> b instanceof MiniStorageBlock;
        CommonMain.registerMutationBehaviour(isMiniStorage, MutationMode.ROTATE, (context, level, state, pos, stack) -> {
            if (!level.method_8608()) {
                level.method_8501(pos, state.method_26186(class_2470.field_11463));
            }
            return ToolUsageResult.slowSuccess();
        });
        CommonMain.registerMutationBehaviour(b -> true, MutationMode.SWAP_THEME, (context, level, state, pos, stack) -> {
            BlockConversionRecipe<?> recipe = ConversionRecipeManager.INSTANCE.getBlockRecipe(state, stack);
            if (recipe != null) {
                return recipe.process(level, context.method_8036(), stack, state, pos);
            }
            return ToolUsageResult.fail();
        });
        contentRegistrationConsumer.accept(new Content(stats, baseItems, chestBlocks, chestItems, chestMinecartEntityTypes, chestMinecartItems, chestBlockEntityType, oldChestBlocks, oldChestItems, oldChestBlockEntityType, barrelBlocks, barrelItems, barrelBlockEntityType, miniStorageBlocks, miniStorageItems, miniStorageBlockEntityType));
    }

    public static <T> void iterateNamedList(List<NamedValue<? extends T>> list, BiConsumer<class_2960, T> consumer) {
        list.forEach(it -> consumer.accept(it.getName(), it.getValue()));
    }

    public static <T> Optional<ItemAccess<T>> getItemAccess(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        if (blockEntity instanceof OldChestBlockEntity) {
            OldChestBlockEntity entity = (OldChestBlockEntity)blockEntity;
            DoubleItemAccess access = entity.getItemAccess();
            EsChestType type = (EsChestType)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE));
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
            if (access.hasCachedAccess() || type == EsChestType.SINGLE) {
                return Optional.of(access);
            }
            class_2586 class_25862 = level.method_8321(pos.method_10093(AbstractChestBlock.getDirectionToAttached(type, facing)));
            if (class_25862 instanceof OldChestBlockEntity) {
                DoubleItemAccess second;
                DoubleItemAccess first;
                OldChestBlockEntity otherEntity = (OldChestBlockEntity)class_25862;
                DoubleItemAccess otherAccess = otherEntity.getItemAccess();
                if (otherAccess.hasCachedAccess()) {
                    return Optional.of(otherAccess);
                }
                if (AbstractChestBlock.getBlockType(type) == class_4732.class_4733.field_21784) {
                    first = access;
                    second = otherAccess;
                } else {
                    first = otherAccess;
                    second = access;
                }
                first.setOther(second);
                return Optional.of(first);
            }
        } else if (blockEntity instanceof OpenableBlockEntity) {
            OpenableBlockEntity entity = (OpenableBlockEntity)blockEntity;
            return Optional.of(entity.getItemAccess());
        }
        return Optional.empty();
    }

    public static class_1269 interactWithEntity(class_1937 level, class_1657 player, class_1268 hand, class_1297 entity) {
        if (player.method_7325() || !player.method_5715()) {
            return class_1269.field_5811;
        }
        class_1799 handStack = player.method_5998(hand);
        class_1792 class_17922 = handStack.method_7909();
        if (class_17922 instanceof EntityInteractableItem) {
            EntityInteractableItem item = (EntityInteractableItem)class_17922;
            if (player.method_7357().method_7904(handStack.method_7909())) {
                return class_1269.field_21466;
            }
            class_1269 result = item.es_interactEntity(level, entity, player, hand, handStack);
            if (result == class_1269.field_5814) {
                result = class_1269.field_21466;
            }
            return result;
        }
        return class_1269.field_5811;
    }

    public static void generateDisplayItems(class_1761.class_8128 itemDisplayParameters, Consumer<class_1799> output) {
        Consumer<class_1792> wrap = item -> output.accept(item.method_7854());
        Consumer<class_1792> sparrowWrap = item -> {
            wrap.accept((class_1792)item);
            class_1799 stack = new class_1799((class_1935)item);
            class_2487 tag = new class_2487();
            class_2487 blockStateTag = new class_2487();
            blockStateTag.method_10582("sparrow", "true");
            tag.method_10566("BlockStateTag", (class_2520)blockStateTag);
            stack.method_7980(tag);
            output.accept(stack);
        };
        for (MutationMode mode : MutationMode.values()) {
            class_1799 stack = new class_1799((class_1935)ModItems.STORAGE_MUTATOR);
            class_2487 tag = new class_2487();
            tag.method_10567("mode", mode.toByte());
            stack.method_7980(tag);
            output.accept(stack);
        }
        class_1799 sparrowMutator = new class_1799((class_1935)ModItems.STORAGE_MUTATOR);
        class_2487 tag = new class_2487();
        tag.method_10567("mode", MutationMode.SWAP_THEME.toByte());
        sparrowMutator.method_7980(tag);
        sparrowMutator.method_7977((class_2561)class_2561.method_43470((String)"Sparrow").method_27692(class_124.field_1056));
        output.accept(sparrowMutator);
        wrap.accept(ModItems.WOOD_TO_COPPER_CONVERSION_KIT);
        wrap.accept(ModItems.WOOD_TO_IRON_CONVERSION_KIT);
        wrap.accept(ModItems.WOOD_TO_GOLD_CONVERSION_KIT);
        wrap.accept(ModItems.WOOD_TO_DIAMOND_CONVERSION_KIT);
        wrap.accept(ModItems.WOOD_TO_OBSIDIAN_CONVERSION_KIT);
        wrap.accept(ModItems.WOOD_TO_NETHERITE_CONVERSION_KIT);
        wrap.accept(ModItems.COPPER_TO_IRON_CONVERSION_KIT);
        wrap.accept(ModItems.COPPER_TO_GOLD_CONVERSION_KIT);
        wrap.accept(ModItems.COPPER_TO_DIAMOND_CONVERSION_KIT);
        wrap.accept(ModItems.COPPER_TO_OBSIDIAN_CONVERSION_KIT);
        wrap.accept(ModItems.COPPER_TO_NETHERITE_CONVERSION_KIT);
        wrap.accept(ModItems.IRON_TO_GOLD_CONVERSION_KIT);
        wrap.accept(ModItems.IRON_TO_DIAMOND_CONVERSION_KIT);
        wrap.accept(ModItems.IRON_TO_OBSIDIAN_CONVERSION_KIT);
        wrap.accept(ModItems.IRON_TO_NETHERITE_CONVERSION_KIT);
        wrap.accept(ModItems.GOLD_TO_DIAMOND_CONVERSION_KIT);
        wrap.accept(ModItems.GOLD_TO_OBSIDIAN_CONVERSION_KIT);
        wrap.accept(ModItems.GOLD_TO_NETHERITE_CONVERSION_KIT);
        wrap.accept(ModItems.DIAMOND_TO_OBSIDIAN_CONVERSION_KIT);
        wrap.accept(ModItems.DIAMOND_TO_NETHERITE_CONVERSION_KIT);
        wrap.accept(ModItems.OBSIDIAN_TO_NETHERITE_CONVERSION_KIT);
        wrap.accept((class_1792)ModItems.WOOD_CHEST);
        wrap.accept((class_1792)ModItems.PUMPKIN_CHEST);
        wrap.accept((class_1792)ModItems.PRESENT);
        wrap.accept((class_1792)ModItems.BAMBOO_CHEST);
        wrap.accept((class_1792)ModItems.MOSS_CHEST);
        wrap.accept((class_1792)ModItems.IRON_CHEST);
        wrap.accept((class_1792)ModItems.GOLD_CHEST);
        wrap.accept((class_1792)ModItems.DIAMOND_CHEST);
        wrap.accept((class_1792)ModItems.OBSIDIAN_CHEST);
        wrap.accept((class_1792)ModItems.NETHERITE_CHEST);
        wrap.accept(ModItems.WOOD_CHEST_MINECART);
        wrap.accept(ModItems.PUMPKIN_CHEST_MINECART);
        wrap.accept(ModItems.PRESENT_MINECART);
        wrap.accept(ModItems.BAMBOO_CHEST_MINECART);
        wrap.accept(ModItems.MOSS_CHEST_MINECART);
        wrap.accept(ModItems.IRON_CHEST_MINECART);
        wrap.accept(ModItems.GOLD_CHEST_MINECART);
        wrap.accept(ModItems.DIAMOND_CHEST_MINECART);
        wrap.accept(ModItems.OBSIDIAN_CHEST_MINECART);
        wrap.accept(ModItems.NETHERITE_CHEST_MINECART);
        wrap.accept((class_1792)ModItems.OLD_WOOD_CHEST);
        wrap.accept((class_1792)ModItems.OLD_IRON_CHEST);
        wrap.accept((class_1792)ModItems.OLD_GOLD_CHEST);
        wrap.accept((class_1792)ModItems.OLD_DIAMOND_CHEST);
        wrap.accept((class_1792)ModItems.OLD_OBSIDIAN_CHEST);
        wrap.accept((class_1792)ModItems.OLD_NETHERITE_CHEST);
        wrap.accept((class_1792)ModItems.COPPER_BARREL);
        wrap.accept((class_1792)ModItems.EXPOSED_COPPER_BARREL);
        wrap.accept((class_1792)ModItems.WEATHERED_COPPER_BARREL);
        wrap.accept((class_1792)ModItems.OXIDIZED_COPPER_BARREL);
        wrap.accept((class_1792)ModItems.WAXED_COPPER_BARREL);
        wrap.accept((class_1792)ModItems.WAXED_EXPOSED_COPPER_BARREL);
        wrap.accept((class_1792)ModItems.WAXED_WEATHERED_COPPER_BARREL);
        wrap.accept((class_1792)ModItems.WAXED_OXIDIZED_COPPER_BARREL);
        wrap.accept((class_1792)ModItems.IRON_BARREL);
        wrap.accept((class_1792)ModItems.GOLD_BARREL);
        wrap.accept((class_1792)ModItems.DIAMOND_BARREL);
        wrap.accept((class_1792)ModItems.OBSIDIAN_BARREL);
        wrap.accept((class_1792)ModItems.NETHERITE_BARREL);
        sparrowWrap.accept((class_1792)ModItems.VANILLA_WOOD_MINI_CHEST);
        sparrowWrap.accept((class_1792)ModItems.WOOD_MINI_CHEST);
        sparrowWrap.accept((class_1792)ModItems.PUMPKIN_MINI_CHEST);
        sparrowWrap.accept((class_1792)ModItems.RED_MINI_PRESENT);
        sparrowWrap.accept((class_1792)ModItems.WHITE_MINI_PRESENT);
        sparrowWrap.accept((class_1792)ModItems.CANDY_CANE_MINI_PRESENT);
        sparrowWrap.accept((class_1792)ModItems.GREEN_MINI_PRESENT);
        sparrowWrap.accept((class_1792)ModItems.LAVENDER_MINI_PRESENT);
        sparrowWrap.accept((class_1792)ModItems.PINK_AMETHYST_MINI_PRESENT);
        sparrowWrap.accept((class_1792)ModItems.IRON_MINI_CHEST);
        sparrowWrap.accept((class_1792)ModItems.GOLD_MINI_CHEST);
        sparrowWrap.accept((class_1792)ModItems.DIAMOND_MINI_CHEST);
        sparrowWrap.accept((class_1792)ModItems.OBSIDIAN_MINI_CHEST);
        sparrowWrap.accept((class_1792)ModItems.NETHERITE_MINI_CHEST);
        sparrowWrap.accept((class_1792)ModItems.MINI_BARREL);
        sparrowWrap.accept((class_1792)ModItems.COPPER_MINI_BARREL);
        sparrowWrap.accept((class_1792)ModItems.EXPOSED_COPPER_MINI_BARREL);
        sparrowWrap.accept((class_1792)ModItems.WEATHERED_COPPER_MINI_BARREL);
        sparrowWrap.accept((class_1792)ModItems.OXIDIZED_COPPER_MINI_BARREL);
        sparrowWrap.accept((class_1792)ModItems.WAXED_COPPER_MINI_BARREL);
        sparrowWrap.accept((class_1792)ModItems.WAXED_EXPOSED_COPPER_MINI_BARREL);
        sparrowWrap.accept((class_1792)ModItems.WAXED_WEATHERED_COPPER_MINI_BARREL);
        sparrowWrap.accept((class_1792)ModItems.WAXED_OXIDIZED_COPPER_MINI_BARREL);
        sparrowWrap.accept((class_1792)ModItems.IRON_MINI_BARREL);
        sparrowWrap.accept((class_1792)ModItems.GOLD_MINI_BARREL);
        sparrowWrap.accept((class_1792)ModItems.DIAMOND_MINI_BARREL);
        sparrowWrap.accept((class_1792)ModItems.OBSIDIAN_MINI_BARREL);
        sparrowWrap.accept((class_1792)ModItems.NETHERITE_MINI_BARREL);
    }

    public static CommonPlatformHelper platformHelper() {
        return platformHelper;
    }

    private static /* synthetic */ MiniStorageBlockEntity lambda$constructContent$48(Function itemAccess, Supplier lockable, class_2338 pos, class_2680 state) {
        return new MiniStorageBlockEntity(CommonMain.getMiniStorageBlockEntityType(), pos, state, ((OpenableBlock)state.method_26204()).getBlockId(), itemAccess, lockable);
    }

    private static /* synthetic */ BarrelBlockEntity lambda$constructContent$36(Function itemAccess, Supplier lockable, class_2338 pos, class_2680 state) {
        return new BarrelBlockEntity(CommonMain.getBarrelBlockEntityType(), pos, state, ((OpenableBlock)state.method_26204()).getBlockId(), itemAccess, lockable);
    }

    private static /* synthetic */ OldChestBlockEntity lambda$constructContent$23(Function chestAccessMaker, Supplier lockable, class_2338 pos, class_2680 state) {
        return new OldChestBlockEntity(CommonMain.getOldChestBlockEntityType(), pos, state, ((OpenableBlock)state.method_26204()).getBlockId(), chestAccessMaker, lockable);
    }

    private static /* synthetic */ ChestBlockEntity lambda$constructContent$17(Function chestAccessMaker, Supplier lockable, class_2338 pos, class_2680 state) {
        return new ChestBlockEntity(CommonMain.getChestBlockEntityType(), pos, state, ((OpenableBlock)state.method_26204()).getBlockId(), chestAccessMaker, lockable);
    }
}

