/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import compasses.expandedstorage.impl.CommonClient;
import compasses.expandedstorage.impl.client.function.ScreenSize;
import compasses.expandedstorage.impl.client.gui.AbstractScreen;
import compasses.expandedstorage.impl.client.gui.TexturedRect;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import compasses.expandedstorage.impl.inventory.handler.ToggleableSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_768;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScrollScreen
extends AbstractScreen {
    private static final int THUMB_WIDTH = 12;
    private static final int THUMB_HEIGHT = 15;
    private final int totalRows;
    private final boolean scrollingUnrestricted;
    private boolean isDragging;
    private boolean blankAreaVisible;
    private int topRow;
    private int scrollYOffset;
    private int thumbY;
    private int blankSlots;
    @Nullable
    private TexturedRect blankArea;

    public ScrollScreen(AbstractHandler handler, class_1661 playerInventory, class_2561 title, ScreenSize screenSize) {
        super(handler, playerInventory, title, screenSize);
        this.initializeSlots(playerInventory);
        this.totalRows = class_3532.method_15384((double)((double)this.totalSlots / (double)this.inventoryWidth));
        this.field_2792 = 7 + 18 * this.inventoryWidth + 7;
        this.field_2779 = 17 + 18 * this.inventoryHeight + 14 + 54 + 4 + 18 + 7;
        this.scrollingUnrestricted = CommonClient.platformHelper().configWrapper().isScrollingUnrestricted();
    }

    public static ScreenSize retrieveScreenSize(int slots, int scaledWidth, int scaledHeight) {
        if (CommonClient.platformHelper().configWrapper().fitVanillaConstraints()) {
            return new ScreenSize(9, 6);
        }
        ArrayList<ScreenSize> options = new ArrayList<ScreenSize>();
        options.add(new ScreenSize(9, 6));
        if (slots > 90) {
            options.add(new ScreenSize(15, 6));
        }
        if (scaledHeight >= 276) {
            if (slots > 54) {
                options.add(new ScreenSize(9, 9));
            }
            if (scaledWidth >= 248 && slots > 81) {
                options.add(new ScreenSize(12, 9));
            }
            if (scaledWidth >= 302 && slots > 108) {
                options.add(new ScreenSize(15, 9));
            }
            if (scaledWidth >= 356 && slots > 135) {
                options.add(new ScreenSize(18, 9));
            }
        }
        if (scaledHeight >= 330 && scaledWidth >= 356 && slots > 162) {
            options.add(new ScreenSize(18, 12));
        }
        if (scaledHeight >= 384 && scaledWidth >= 356 && slots > 216) {
            options.add(new ScreenSize(18, 15));
        }
        return (ScreenSize)options.get(options.size() - 1);
    }

    private void initializeSlots(class_1661 playerInventory) {
        for (int i = 0; i < this.totalSlots; ++i) {
            int slotXPos = i % this.inventoryWidth;
            int slotYPos = class_3532.method_15384((double)((double)(i - slotXPos) / (double)this.inventoryWidth));
            int realYPos = slotYPos >= this.inventoryHeight ? -2000 : slotYPos * 18 + 18;
            ((AbstractHandler)this.field_2797).addClientSlot(new ToggleableSlot(((AbstractHandler)this.field_2797).getInventory(), i, slotXPos * 18 + 8, realYPos, realYPos != -2000));
        }
        int left = (this.inventoryWidth * 18 + 14) / 2 - 80;
        int top = 32 + this.inventoryHeight * 18;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                ((AbstractHandler)this.field_2797).addClientSlot(new class_1735((class_1263)playerInventory, y * 9 + x + 9, left + 18 * x, top + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            ((AbstractHandler)this.field_2797).addClientSlot(new class_1735((class_1263)playerInventory, x, left + 18 * x, top + 58));
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.field_2776 = (this.field_22789 - (this.field_2792 + 22 - 4)) / 2;
        this.isDragging = false;
        int remainderSlots = this.totalSlots % this.inventoryWidth;
        if (remainderSlots > 0) {
            this.blankSlots = this.inventoryWidth - remainderSlots;
            int xRight = this.field_2776 + 7 + this.inventoryWidth * 18;
            int yTop = this.field_2800 + 17 + (this.inventoryHeight - 1) * 18;
            int width = this.blankSlots * 18;
            this.blankArea = new TexturedRect(this.textureLocation, xRight - width, yTop, width, 18, 7, this.field_2779, this.textureWidth, this.textureHeight);
            this.blankAreaVisible = this.topRow == this.totalRows - this.inventoryHeight;
        }
    }

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_25290(this.textureLocation, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, this.textureWidth, this.textureHeight);
        int containerSlotsHeight = this.inventoryHeight * 18;
        int scrollbarHeight = containerSlotsHeight + (this.inventoryWidth > 9 ? 34 : 24);
        graphics.method_25290(this.textureLocation, this.field_2776 + this.field_2792 - 4, this.field_2800, (float)this.field_2792, 0.0f, 22, scrollbarHeight, this.textureWidth, this.textureHeight);
        graphics.method_25290(this.textureLocation, this.field_2776 + this.field_2792 - 2, this.field_2800 + 17 + 1 + this.thumbY, (float)this.field_2792, (float)scrollbarHeight, 12, 15, this.textureWidth, this.textureHeight);
        if (this.blankArea != null && this.blankAreaVisible) {
            this.blankArea.render(graphics);
        }
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51439(this.field_22793, this.field_22785, 8, 6, 0x404040, false);
        graphics.method_51439(this.field_22793, this.field_29347, 8, this.field_2779 - 96 + 2, 0x404040, false);
    }

    private boolean isMouseOverTrack(double mouseX, double mouseY) {
        boolean xCheck = (double)(this.field_2776 + this.field_2792 - 2) <= mouseX && mouseX <= (double)(this.field_2776 + this.field_2792 - 2 + 12);
        int scrollbarStart = this.field_2800 + 17 + 1;
        return xCheck && (double)scrollbarStart <= mouseY && mouseY <= (double)(scrollbarStart + this.inventoryHeight * 18 - 2);
    }

    private boolean isMouseOverThumb(double mouseX, double mouseY) {
        boolean xCheck = (double)(this.field_2776 + this.field_2792 - 2) <= mouseX && mouseX <= (double)(this.field_2776 + this.field_2792 - 2 + 12);
        double correctedThumbY = this.field_2800 + 17 + 1 + this.thumbY;
        return xCheck && correctedThumbY <= mouseY && mouseY <= correctedThumbY + 15.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMouseOverScrollbar(double mouseX, double mouseY, int left, int top) {
        if (!(mouseX > (double)(left + this.field_2792 - 4))) return false;
        if (!(mouseX <= (double)(left + this.field_2792 + 22))) return false;
        if (!(mouseY >= (double)top)) return false;
        int n = this.inventoryWidth > 9 ? 10 : 0;
        if (!(mouseY < (double)(top + 17 + this.inventoryHeight * 18 + n + 7))) return false;
        return true;
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top, int button) {
        int outsideRegion;
        if (this.inventoryWidth > 9 && mouseY >= (double)(top + 17 + this.inventoryHeight * 18 + 17) && (mouseX < (double)(left + (outsideRegion = (this.field_2792 - 176) / 2)) || mouseX > (double)(left + this.field_2792 - outsideRegion))) {
            return true;
        }
        return super.method_2381(mouseX, mouseY, left, top, button) && !this.isMouseOverScrollbar(mouseX, mouseY, this.field_2776, this.field_2800);
    }

    @Override
    protected boolean handleKeyPress(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 264 || keyCode == 267) {
            if (this.topRow != this.totalRows - this.inventoryHeight) {
                if (ScrollScreen.method_25442()) {
                    this.setTopRowAndMoveThumb(this.topRow, Math.min(this.topRow + this.inventoryHeight, this.totalRows - this.inventoryHeight));
                } else {
                    this.setTopRowAndMoveThumb(this.topRow, this.topRow + 1);
                }
            }
            return true;
        }
        if (keyCode == 265 || keyCode == 266) {
            if (this.topRow != 0) {
                if (ScrollScreen.method_25442()) {
                    this.setTopRowAndMoveThumb(this.topRow, Math.max(this.topRow - this.inventoryHeight, 0));
                } else {
                    this.setTopRowAndMoveThumb(this.topRow, this.topRow - 1);
                }
            }
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isMouseOverThumb(mouseX, mouseY) && button == 0) {
            this.scrollYOffset = (int)mouseY - this.thumbY;
            this.isDragging = true;
        } else if (this.isMouseOverTrack(mouseX, mouseY) && button == 0) {
            this.updateThumbPosition(mouseY - 17.0 - 1.0 - (double)this.field_2800);
            this.snapThumbToGradation();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging) {
            this.updateThumbPosition(mouseY - (double)this.scrollYOffset);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.isDragging) {
            this.isDragging = false;
            this.snapThumbToGradation();
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private void snapThumbToGradation() {
        this.thumbY = (int)((double)this.topRow / (double)(this.totalRows - this.inventoryHeight) * (double)(this.inventoryHeight * 18 - 2 - 15));
    }

    private void updateThumbPosition(double adjustedMouseY) {
        this.thumbY = (int)Math.min(Math.max(adjustedMouseY, 0.0), (double)(this.inventoryHeight * 18 - 2 - 15));
        int row = (int)Math.round((double)this.thumbY / (double)(this.inventoryHeight * 18 - 2 - 15) * (double)(this.totalRows - this.inventoryHeight));
        this.setTopRow(this.topRow, row);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (super.method_25401(mouseX, mouseY, deltaX, deltaY)) {
            return true;
        }
        if (this.scrollingUnrestricted || this.isMouseOverTrack(mouseX, mouseY)) {
            int newTop = deltaY < 0.0 ? Math.min(this.topRow + (ScrollScreen.method_25442() ? this.inventoryHeight : 1), this.totalRows - this.inventoryHeight) : Math.max(this.topRow - (ScrollScreen.method_25442() ? this.inventoryHeight : 1), 0);
            this.setTopRowAndMoveThumb(this.topRow, newTop);
            return true;
        }
        return false;
    }

    private void setTopRowAndMoveThumb(int oldTopRow, int newTopRow) {
        this.setTopRow(oldTopRow, newTopRow);
        this.snapThumbToGradation();
    }

    private void setTopRow(int oldTopRow, int newTopRow) {
        if (oldTopRow == newTopRow) {
            return;
        }
        this.topRow = newTopRow;
        this.blankAreaVisible = this.topRow == this.totalRows - this.inventoryHeight;
        int delta = newTopRow - oldTopRow;
        int rows = Math.abs(delta);
        if (rows < this.inventoryHeight) {
            int setAmount = rows * this.inventoryWidth;
            int movableAmount = (this.inventoryHeight - rows) * this.inventoryWidth;
            if (delta > 0) {
                int setOutBegin = oldTopRow * this.inventoryWidth;
                int movableBegin = newTopRow * this.inventoryWidth;
                int setInBegin = movableBegin + movableAmount;
                ((AbstractHandler)this.field_2797).setSlotRange(setOutBegin, setOutBegin + setAmount, index -> -2000);
                ((AbstractHandler)this.field_2797).moveSlotRange(movableBegin, setInBegin, -18 * rows);
                ((AbstractHandler)this.field_2797).setSlotRange(setInBegin, Math.min(setInBegin + setAmount, this.totalSlots), index -> 18 * Math.floorDiv(index - movableBegin + this.inventoryWidth, this.inventoryWidth));
            } else {
                int setInBegin = newTopRow * this.inventoryWidth;
                int movableBegin = oldTopRow * this.inventoryWidth;
                int setOutBegin = movableBegin + movableAmount;
                ((AbstractHandler)this.field_2797).setSlotRange(setInBegin, setInBegin + setAmount, index -> 18 * Math.floorDiv(index - setInBegin + this.inventoryWidth, this.inventoryWidth));
                ((AbstractHandler)this.field_2797).moveSlotRange(movableBegin, setOutBegin, 18 * rows);
                ((AbstractHandler)this.field_2797).setSlotRange(setOutBegin, Math.min(setOutBegin + setAmount, this.totalSlots), index -> -2000);
            }
        } else {
            int oldMin = oldTopRow * this.inventoryWidth;
            ((AbstractHandler)this.field_2797).setSlotRange(oldMin, Math.min(oldMin + this.inventoryWidth * this.inventoryHeight, this.totalSlots), index -> -2000);
            int newMin = newTopRow * this.inventoryWidth;
            ((AbstractHandler)this.field_2797).setSlotRange(newMin, newMin + this.inventoryWidth * this.inventoryHeight - (this.blankAreaVisible ? this.blankSlots : 0), index -> 18 + 18 * Math.floorDiv(index - newMin, this.inventoryWidth));
        }
    }

    @Override
    @NotNull
    public List<class_768> getExclusionZones() {
        int height = 17 + this.inventoryHeight * 18 + (this.inventoryWidth > 9 ? 10 : 0) + 7;
        return Collections.singletonList(new class_768(this.field_2776 + this.field_2792, this.field_2800, 18, height));
    }
}

