/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.item;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_1890.class})
abstract class EnchantmentHelperMixin {
    EnchantmentHelperMixin() {
    }

    @Redirect(method={"getPossibleEntries"}, at=@At(value="INVOKE", target="Lnet/minecraft/enchantment/EnchantmentTarget;isAcceptableItem(Lnet/minecraft/item/Item;)Z"))
    private static boolean useCustomEnchantingChecks(class_1886 target, class_1792 item, int power, class_1799 stack, boolean treasureAllowed, @Local class_1887 enchantment) {
        return stack.canBeEnchantedWith(enchantment, EnchantingContext.RANDOM_ENCHANTMENT);
    }

    @ModifyReturnValue(method={"getLevel"}, at={@At(value="RETURN")})
    private static int getIntrinsicLevelIfPresent(int original, class_1887 ench, class_1799 stack) {
        int intrinsicLevel = stack.method_7909().getIntrinsicEnchantments(stack).getOrDefault((Object)ench, 0);
        return Math.max(original, intrinsicLevel);
    }

    @Redirect(method={"forEachEnchantment(Lnet/minecraft/enchantment/EnchantmentHelper$Consumer;Lnet/minecraft/item/ItemStack;)V"}, at=@At(value="INVOKE", target="Ljava/util/Optional;ifPresent(Ljava/util/function/Consumer;)V", remap=false))
    private static void setCurrentStack(Optional<class_1887> instance, Consumer<? super class_1887> action, class_1890.class_1891 consumer, class_1799 stack, @Local class_2487 compound) {
        instance.ifPresent(ench -> {
            int intrinsicLevel = stack.method_7909().getIntrinsicEnchantments(stack).getOrDefault(ench, 0);
            consumer.accept(ench, Math.max(intrinsicLevel, class_1890.method_37424((class_2487)compound)));
        });
    }
}

