/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.item;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.item.v1.CustomDamageHandler;
import net.fabricmc.fabric.api.item.v1.FabricItemStack;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.impl.item.ItemExtensions;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin
implements FabricItemStack {
    @Unique
    private class_1309 fabric_damagingEntity;
    @Unique
    private Consumer<class_1309> fabric_breakCallback;

    @Shadow
    public abstract class_1792 method_7909();

    @Inject(method={"damage(ILnet/minecraft/entity/LivingEntity;Ljava/util/function/Consumer;)V"}, at={@At(value="HEAD")})
    private void saveDamager(int amount, class_1309 entity, Consumer<class_1309> breakCallback, CallbackInfo ci) {
        this.fabric_damagingEntity = entity;
        this.fabric_breakCallback = breakCallback;
    }

    @ModifyArg(method={"damage(ILnet/minecraft/entity/LivingEntity;Ljava/util/function/Consumer;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;damage(ILnet/minecraft/util/math/random/Random;Lnet/minecraft/server/network/ServerPlayerEntity;)Z"), index=0)
    private int hookDamage(int amount) {
        CustomDamageHandler handler = ((ItemExtensions)this.method_7909()).fabric_getCustomDamageHandler();
        if (handler != null) {
            return handler.damage((class_1799)this, amount, this.fabric_damagingEntity, this.fabric_breakCallback);
        }
        return amount;
    }

    @Inject(method={"damage(ILnet/minecraft/entity/LivingEntity;Ljava/util/function/Consumer;)V"}, at={@At(value="RETURN")})
    private <T extends class_1309> void clearDamage(int amount, T entity, Consumer<T> breakCallback, CallbackInfo ci) {
        this.fabric_damagingEntity = null;
        this.fabric_breakCallback = null;
    }

    @Redirect(method={"getAttributeModifiers"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/Item;getAttributeModifiers(Lnet/minecraft/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;"))
    public Multimap<class_1320, class_1322> hookGetAttributeModifiers(class_1792 item, class_1304 slot) {
        class_1799 stack = (class_1799)this;
        LinkedHashMultimap attributeModifiers = LinkedHashMultimap.create((Multimap)item.getAttributeModifiers(stack, slot));
        ((ModifyItemAttributeModifiersCallback)ModifyItemAttributeModifiersCallback.EVENT.invoker()).modifyAttributeModifiers(stack, slot, (Multimap<class_1320, class_1322>)attributeModifiers);
        return attributeModifiers;
    }

    @Redirect(method={"isSuitableFor"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/Item;isSuitableFor(Lnet/minecraft/block/BlockState;)Z"))
    public boolean hookIsSuitableFor(class_1792 item, class_2680 state) {
        return item.isSuitableFor((class_1799)this, state);
    }

    @Inject(method={"isFood"}, at={@At(value="HEAD")}, cancellable=true)
    public void isStackAwareFood(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)(this.getFoodComponent() != null ? 1 : 0));
    }
}

