/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.keksuccino.fancymenu.networking.PacketHandler;
import de.keksuccino.fancymenu.networking.packets.commands.variable.command.VariableCommandPacket;
import de.keksuccino.konkrete.command.CommandUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class VariableCommand {
    public static final Map<String, List<String>> CACHED_VARIABLE_SUGGESTIONS = Collections.synchronizedMap(new HashMap());

    public static void register(CommandDispatcher<class_2168> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fmvariable").then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"variable_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CommandUtils.getStringSuggestions((SuggestionsBuilder)builder, (String[])VariableCommand.getVariableNameSuggestions(((class_2168)context.getSource()).method_9207()))).executes(stack -> VariableCommand.getVariable((class_2168)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"variable_name")))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"variable_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> CommandUtils.getStringSuggestions((SuggestionsBuilder)builder, (String[])VariableCommand.getVariableNameSuggestions(((class_2168)context.getSource()).method_9207()))).then(class_2170.method_9244((String)"send_chat_feedback", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"set_to_value", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> CommandUtils.getStringSuggestions((SuggestionsBuilder)builder, (String[])new String[]{"<set_to_value>"})).executes(stack -> VariableCommand.setVariable((class_2168)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"variable_name"), StringArgumentType.getString((CommandContext)stack, (String)"set_to_value"), BoolArgumentType.getBool((CommandContext)stack, (String)"send_chat_feedback"))))))));
    }

    private static String[] getVariableNameSuggestions(class_3222 sender) {
        ArrayList<String> l = new ArrayList<String>(Objects.requireNonNullElse(CACHED_VARIABLE_SUGGESTIONS.get(sender.method_5667().toString()), new ArrayList()));
        if (l.isEmpty()) {
            l.add("<no_variables_found>");
        }
        return l.toArray(new String[0]);
    }

    private static int getVariable(class_2168 stack, String variableName) {
        try {
            if (variableName != null) {
                class_3222 sender = stack.method_9207();
                VariableCommandPacket packet = new VariableCommandPacket();
                packet.set = false;
                packet.variable_name = variableName;
                PacketHandler.sendToClient(sender, packet);
            }
        }
        catch (Exception ex) {
            stack.method_9213((class_2561)class_2561.method_43470((String)"Error while executing command!"));
            ex.printStackTrace();
        }
        return 1;
    }

    private static int setVariable(class_2168 stack, String variableName, String setToValue, boolean sendFeedback) {
        try {
            if (variableName != null && setToValue != null) {
                class_3222 sender = stack.method_9207();
                VariableCommandPacket packet = new VariableCommandPacket();
                packet.set = true;
                packet.variable_name = variableName;
                packet.set_to_value = setToValue;
                packet.feedback = sendFeedback;
                PacketHandler.sendToClient(sender, packet);
            }
        }
        catch (Exception ex) {
            stack.method_9213((class_2561)class_2561.method_43470((String)"Error while executing command!"));
            ex.printStackTrace();
        }
        return 1;
    }
}

