/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.background.ChooseMenuBackgroundScreen;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.customization.deep.AbstractDeepEditorElement;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.element.ElementRegistry;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetElement;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.layout.ManageLayoutsScreen;
import de.keksuccino.fancymenu.customization.layout.editor.AnchorPointOverlay;
import de.keksuccino.fancymenu.customization.layout.editor.AutoScalingScreen;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.layout.editor.loadingrequirements.ManageRequirementsScreen;
import de.keksuccino.fancymenu.customization.layout.editor.widget.AbstractLayoutEditorWidget;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlay;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlayUI;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedEnumValueCycle;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.input.TextValidators;
import de.keksuccino.fancymenu.util.rendering.ui.NonStackableOverlayUI;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.menubar.v2.MenuBar;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringListChooserScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.TextInputScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.resource.resources.texture.PngTexture;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class LayoutEditorUI {
    private static final PngTexture CLOSE_EDITOR_TEXTURE = PngTexture.location(new class_2960("fancymenu", "textures/menubar/icons/close.png"));
    private static MenuBar grandfatheredMenuBar = null;

    @NotNull
    public static MenuBar buildMenuBar(LayoutEditorScreen editor, boolean expanded) {
        if (grandfatheredMenuBar != null) {
            MenuBar mb = grandfatheredMenuBar;
            grandfatheredMenuBar = null;
            return mb;
        }
        MenuBar menuBar = new MenuBar();
        menuBar.setExpanded(expanded);
        CustomizationOverlayUI.buildFMIconTabAndAddTo(menuBar);
        ContextMenu layoutMenu = new ContextMenu();
        menuBar.addContextMenuEntry("layout_tab", (class_2561)class_2561.method_43471((String)"fancymenu.editor.layout"), layoutMenu);
        layoutMenu.addClickableEntry("new_layout", (class_2561)class_2561.method_43471((String)"fancymenu.editor.layout.new"), (menu, entry) -> LayoutEditorUI.displayUnsavedWarning(call -> {
            if (call.booleanValue()) {
                editor.saveWidgetSettings();
                if (editor.layout.isUniversalLayout()) {
                    LayoutHandler.openLayoutEditor(Layout.buildUniversal(), null);
                } else {
                    LayoutHandler.openLayoutEditor(Layout.buildForScreen(Objects.requireNonNull(editor.layoutTargetScreen)), editor.layoutTargetScreen);
                }
            } else {
                class_310.method_1551().method_1507((class_437)editor);
            }
        })).setIcon(ContextMenu.IconFactory.getIcon("add"));
        layoutMenu.addSubMenuEntry("open_layout", (class_2561)class_2561.method_43471((String)"fancymenu.editor.layout.open"), LayoutEditorUI.buildOpenLayoutContextMenu(editor)).setIcon(ContextMenu.IconFactory.getIcon("open"));
        layoutMenu.addSeparatorEntry("separator_after_open_layout");
        ((ContextMenu.ClickableContextMenuEntry)layoutMenu.addClickableEntry("save_layout", (class_2561)class_2561.method_43471((String)"fancymenu.editor.layout.save"), (menu, entry) -> {
            menu.closeMenu();
            editor.saveLayout();
        }).setShortcutTextSupplier((menu, entry) -> class_2561.method_43471((String)"fancymenu.editor.shortcuts.save"))).setIcon(ContextMenu.IconFactory.getIcon("save"));
        layoutMenu.addClickableEntry("save_layout_as", (class_2561)class_2561.method_43471((String)"fancymenu.editor.layout.saveas"), (menu, entry) -> {
            menu.closeMenu();
            editor.saveLayoutAs();
        }).setIcon(ContextMenu.IconFactory.getIcon("save_as"));
        layoutMenu.addSeparatorEntry("separator_after_save_as");
        ((ContextMenu.SubMenuContextMenuEntry)layoutMenu.addSubMenuEntry("layout_settings", (class_2561)class_2561.method_43471((String)"fancymenu.editor.layout.properties"), LayoutEditorUI.buildRightClickContextMenu(editor)).setIcon(ContextMenu.IconFactory.getIcon("settings"))).setHoverAction((menu, entry, isPost) -> {
            if (!isPost) {
                int menuBarHeight = (int)((float)menuBar.getHeight() * UIBase.calculateFixedScale(menuBar.getScale()));
                editor.rightClickMenuOpenPosX = 20;
                editor.rightClickMenuOpenPosY = menuBarHeight + 20;
            }
        });
        layoutMenu.addSeparatorEntry("separator_after_layout_settings");
        layoutMenu.addClickableEntry("close_editor", (class_2561)class_2561.method_43471((String)"fancymenu.editor.close"), (menu, entry) -> LayoutEditorUI.displayUnsavedWarning(call -> {
            if (call.booleanValue()) {
                editor.closeEditor();
            } else {
                class_310.method_1551().method_1507((class_437)editor);
            }
        })).setIcon(ContextMenu.IconFactory.getIcon("close"));
        ContextMenu editMenu = new ContextMenu();
        menuBar.addContextMenuEntry("edit_tab", (class_2561)class_2561.method_43471((String)"fancymenu.editor.edit"), editMenu);
        ((ContextMenu.ClickableContextMenuEntry)editMenu.addClickableEntry("undo_action", (class_2561)class_2561.method_43471((String)"fancymenu.editor.edit.undo"), (menu, entry) -> editor.history.stepBack()).setShortcutTextSupplier((menu, entry) -> class_2561.method_43471((String)"fancymenu.editor.shortcuts.undo"))).setIcon(ContextMenu.IconFactory.getIcon("undo"));
        ((ContextMenu.ClickableContextMenuEntry)editMenu.addClickableEntry("redo_action", (class_2561)class_2561.method_43471((String)"fancymenu.editor.edit.redo"), (menu, entry) -> editor.history.stepForward()).setShortcutTextSupplier((menu, entry) -> class_2561.method_43471((String)"fancymenu.editor.shortcuts.redo"))).setIcon(ContextMenu.IconFactory.getIcon("redo"));
        editMenu.addSeparatorEntry("separator_after_redo");
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)editMenu.addClickableEntry("copy_selected_elements", (class_2561)class_2561.method_43471((String)"fancymenu.editor.edit.copy"), (menu, entry) -> editor.copyElementsToClipboard(editor.getSelectedElements().toArray(new AbstractEditorElement[0]))).setIsActiveSupplier((menu, entry) -> !editor.getSelectedElements().isEmpty())).setShortcutTextSupplier((menu, entry) -> class_2561.method_43471((String)"fancymenu.editor.shortcuts.copy"))).setIcon(ContextMenu.IconFactory.getIcon("copy"));
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)editMenu.addClickableEntry("paste_copied_elements", (class_2561)class_2561.method_43471((String)"fancymenu.editor.edit.paste"), (menu, entry) -> {
            editor.history.saveSnapshot();
            editor.pasteElementsFromClipboard();
        }).setIsActiveSupplier((menu, entry) -> !LayoutEditorScreen.COPIED_ELEMENTS_CLIPBOARD.isEmpty())).setShortcutTextSupplier((menu, entry) -> class_2561.method_43471((String)"fancymenu.editor.shortcuts.paste"))).setIcon(ContextMenu.IconFactory.getIcon("paste"));
        editMenu.addSeparatorEntry("separator_after_paste_copied");
        ((ContextMenu.ClickableContextMenuEntry)editMenu.addClickableEntry("select_all_elements", (class_2561)class_2561.method_43471((String)"fancymenu.editor.menu_bar.edit.select_all"), (menu, entry) -> editor.selectAllElements()).setShortcutTextSupplier((menu, entry) -> class_2561.method_43471((String)"fancymenu.editor.shortcuts.select_all"))).setIcon(ContextMenu.IconFactory.getIcon("select"));
        ContextMenu elementMenu = new ContextMenu();
        menuBar.addContextMenuEntry("element_tab", (class_2561)class_2561.method_43471((String)"fancymenu.editor.element"), elementMenu);
        elementMenu.addSubMenuEntry("new_element", (class_2561)class_2561.method_43471((String)"fancymenu.editor.element.new"), LayoutEditorUI.buildElementContextMenu(editor)).setIcon(ContextMenu.IconFactory.getIcon("add"));
        elementMenu.addSubMenuEntry("manage_hidden_vanilla_elements", (class_2561)class_2561.method_43471((String)"fancymenu.fancymenu.editor.element.deleted_vanilla_elements"), LayoutEditorUI.buildHiddenVanillaElementsContextMenu(editor)).setIcon(ContextMenu.IconFactory.getIcon("delete"));
        ContextMenu windowMenu = new ContextMenu();
        menuBar.addContextMenuEntry("window_tab", (class_2561)class_2561.method_43471((String)"fancymenu.editor.menu_bar.window"), windowMenu);
        windowMenu.addSubMenuEntry("editor_widgets", (class_2561)class_2561.method_43471((String)"fancymenu.editor.widgets"), LayoutEditorUI.buildEditorWidgetsContextMenu(editor)).setIcon(ContextMenu.IconFactory.getIcon("widget"));
        windowMenu.addSeparatorEntry("separator_after_editor_widgets");
        LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> gridToggleCycle = CommonCycles.cycleEnabledDisabled("fancymenu.editor.menu_bar.window.grid", FancyMenu.getOptions().showLayoutEditorGrid.getValue());
        gridToggleCycle.addCycleListener(cycle -> FancyMenu.getOptions().showLayoutEditorGrid.setValue(cycle.getAsBoolean()));
        ((ContextMenu.ValueCycleContextMenuEntry)((ContextMenu.ValueCycleContextMenuEntry)windowMenu.addValueCycleEntry("enable_grid", gridToggleCycle).setTickAction((menu, entry, isPost) -> {
            if (FancyMenu.getOptions().showLayoutEditorGrid.getValue().booleanValue() != ((CommonCycles.CycleEnabledDisabled)gridToggleCycle.current()).getAsBoolean()) {
                gridToggleCycle.setCurrentValue(CommonCycles.CycleEnabledDisabled.getByBoolean(FancyMenu.getOptions().showLayoutEditorGrid.getValue()), false);
            }
        })).setShortcutTextSupplier((menu, entry) -> class_2561.method_43471((String)"fancymenu.editor.shortcuts.grid"))).setIcon(ContextMenu.IconFactory.getIcon("grid"));
        int preSelectedGridSize = FancyMenu.getOptions().layoutEditorGridSize.getValue();
        if (preSelectedGridSize != 10 && preSelectedGridSize != 20 && preSelectedGridSize != 30 && preSelectedGridSize != 40) {
            preSelectedGridSize = 10;
        }
        windowMenu.addValueCycleEntry("grid_size", CommonCycles.cycle("fancymenu.editor.menu_bar.window.grid_size", ListUtils.of(10, 20, 30, 40), preSelectedGridSize).addCycleListener(integer -> FancyMenu.getOptions().layoutEditorGridSize.setValue((Integer)integer))).setIcon(ContextMenu.IconFactory.getIcon("measure"));
        windowMenu.addSeparatorEntry("separator_after_grid_size");
        windowMenu.addValueCycleEntry("anchor_overlay_visibility_mode", AnchorPointOverlay.AnchorOverlayVisibilityMode.ALWAYS.cycle(editor.anchorPointOverlay.getVisibilityMode()).addCycleListener(anchorOverlayVisibilityMode -> FancyMenu.getOptions().anchorOverlayVisibilityMode.setValue(anchorOverlayVisibilityMode.getName())));
        windowMenu.addValueCycleEntry("show_all_anchor_connections", CommonCycles.cycleEnabledDisabled("fancymenu.editor.anchor_overlay.show_all_anchor_connections", FancyMenu.getOptions().showAllAnchorOverlayConnections.getValue()).addCycleListener(cycle -> FancyMenu.getOptions().showAllAnchorOverlayConnections.setValue(cycle.getAsBoolean())));
        windowMenu.addSeparatorEntry("separator_after_show_all_anchor_connections");
        windowMenu.addValueCycleEntry("anchor_area_hovering", CommonCycles.cycleEnabledDisabled("fancymenu.editor.anchor_overlay.change_anchor_on_area_hover", FancyMenu.getOptions().anchorOverlayChangeAnchorOnAreaHover.getValue()).addCycleListener(cycle -> FancyMenu.getOptions().anchorOverlayChangeAnchorOnAreaHover.setValue(cycle.getAsBoolean()))).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.anchor_overlay.change_anchor_on_area_hover.desc", new String[0])));
        windowMenu.addValueCycleEntry("anchor_element_hovering", CommonCycles.cycleEnabledDisabled("fancymenu.editor.anchor_overlay.change_anchor_on_element_hover", FancyMenu.getOptions().anchorOverlayChangeAnchorOnElementHover.getValue()).addCycleListener(cycle -> FancyMenu.getOptions().anchorOverlayChangeAnchorOnElementHover.setValue(cycle.getAsBoolean()))).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.anchor_overlay.change_anchor_on_element_hover.desc", new String[0])));
        NonStackableOverlayUI.addRangeSliderInputContextMenuEntryTo(windowMenu, "anchor_overlay_hover_charging_time", (class_2561)class_2561.method_43471((String)"fancymenu.editor.anchor_overlay.charging_time"), () -> FancyMenu.getOptions().anchorOverlayHoverChargingTimeSeconds.getValue(), aDouble -> FancyMenu.getOptions().anchorOverlayHoverChargingTimeSeconds.setValue((Double)aDouble), true, FancyMenu.getOptions().anchorOverlayHoverChargingTimeSeconds.getDefaultValue(), 1.0, 20.0, consumes -> class_2561.method_43469((String)"fancymenu.editor.anchor_overlay.charging_time.slider_label", (Object[])new Object[]{consumes})).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.anchor_overlay.charging_time.desc", new String[0])));
        windowMenu.addSeparatorEntry("separator_after_anchor_overlay_hover_charging_time");
        windowMenu.addValueCycleEntry("invert_anchor_overlay_colors", CommonCycles.cycleEnabledDisabled("fancymenu.editor.anchor_overlay.invert_colors", FancyMenu.getOptions().invertAnchorOverlayColor.getValue()).addCycleListener(cycle -> FancyMenu.getOptions().invertAnchorOverlayColor.setValue(cycle.getAsBoolean()))).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.anchor_overlay.invert_colors.desc", new String[0])));
        NonStackableOverlayUI.addInputContextMenuEntryTo(windowMenu, "custom_anchor_overlay_base_color", (class_2561)class_2561.method_43471((String)"fancymenu.editor.anchor_overlay.overlay_color_base"), () -> FancyMenu.getOptions().anchorOverlayColorBaseOverride.getValue(), s -> FancyMenu.getOptions().anchorOverlayColorBaseOverride.setValue((String)s), true, FancyMenu.getOptions().anchorOverlayColorBaseOverride.getDefaultValue(), null, false, false, TextValidators.HEX_COLOR_TEXT_VALIDATOR, null, null).setIsActiveSupplier((menu, entry) -> FancyMenu.getOptions().invertAnchorOverlayColor.getValue() == false);
        NonStackableOverlayUI.addInputContextMenuEntryTo(windowMenu, "custom_anchor_overlay_border_color", (class_2561)class_2561.method_43471((String)"fancymenu.editor.anchor_overlay.overlay_color_border"), () -> FancyMenu.getOptions().anchorOverlayColorBorderOverride.getValue(), s -> FancyMenu.getOptions().anchorOverlayColorBorderOverride.setValue((String)s), true, FancyMenu.getOptions().anchorOverlayColorBorderOverride.getDefaultValue(), null, false, false, TextValidators.HEX_COLOR_TEXT_VALIDATOR, null, null).setIsActiveSupplier((menu, entry) -> FancyMenu.getOptions().invertAnchorOverlayColor.getValue() == false);
        windowMenu.addSeparatorEntry("separator_after_custom_anchor_overlay_border_color");
        NonStackableOverlayUI.addRangeSliderInputContextMenuEntryTo(windowMenu, "anchor_overlay_opacity_normal", (class_2561)class_2561.method_43471((String)"fancymenu.editor.anchor_overlay.opacity_normal"), () -> FancyMenu.getOptions().anchorOverlayOpacityPercentageNormal.getValue().floatValue(), aDouble -> FancyMenu.getOptions().anchorOverlayOpacityPercentageNormal.setValue(Float.valueOf(aDouble.floatValue())), true, FancyMenu.getOptions().anchorOverlayOpacityPercentageNormal.getDefaultValue().floatValue(), 0.0, 1.0, consumes -> class_2561.method_43469((String)"fancymenu.editor.anchor_overlay.opacity_normal.slider_label", (Object[])new Object[]{(int)(consumes * 100.0) + "%"})).setIsActiveSupplier((menu, entry) -> FancyMenu.getOptions().invertAnchorOverlayColor.getValue() == false);
        NonStackableOverlayUI.addRangeSliderInputContextMenuEntryTo(windowMenu, "anchor_overlay_opacity_busy", (class_2561)class_2561.method_43471((String)"fancymenu.editor.anchor_overlay.opacity_busy"), () -> FancyMenu.getOptions().anchorOverlayOpacityPercentageBusy.getValue().floatValue(), aDouble -> FancyMenu.getOptions().anchorOverlayOpacityPercentageBusy.setValue(Float.valueOf(aDouble.floatValue())), true, FancyMenu.getOptions().anchorOverlayOpacityPercentageBusy.getDefaultValue().floatValue(), 0.0, 1.0, consumes -> class_2561.method_43469((String)"fancymenu.editor.anchor_overlay.opacity_busy.slider_label", (Object[])new Object[]{(int)(consumes * 100.0) + "%"})).setIsActiveSupplier((menu, entry) -> FancyMenu.getOptions().invertAnchorOverlayColor.getValue() == false);
        CustomizationOverlayUI.buildUITabAndAddTo(menuBar);
        CustomizationOverlayUI.buildHelpTabAndAddTo(menuBar);
        menuBar.addClickableEntry(MenuBar.Side.RIGHT, "close_editor", (class_2561)class_2561.method_43473(), (bar, entry) -> LayoutEditorUI.displayUnsavedWarning(call -> {
            if (call.booleanValue()) {
                editor.closeEditor();
            } else {
                class_310.method_1551().method_1507((class_437)editor);
            }
        })).setIconTexture(CLOSE_EDITOR_TEXTURE).setIconTextureColor(() -> UIBase.getUIColorTheme().layout_editor_close_icon_color);
        return menuBar;
    }

    protected static void displayUnsavedWarning(@NotNull Consumer<Boolean> callback) {
        class_310.method_1551().method_1507((class_437)ConfirmationScreen.warning(callback, LocalizationUtils.splitLocalizedLines("fancymenu.editor.warning.unsaved", new String[0])));
    }

    @NotNull
    public static ContextMenu buildEditorWidgetsContextMenu(@NotNull LayoutEditorScreen editor) {
        ContextMenu menu = new ContextMenu();
        int i = 0;
        for (AbstractLayoutEditorWidget w : editor.layoutEditorWidgets) {
            menu.addClickableEntry("widget_" + i, w.getDisplayLabel(), (menu1, entry) -> w.setVisible(true));
            ++i;
        }
        return menu;
    }

    @NotNull
    public static ContextMenu buildRightClickContextMenu(@NotNull LayoutEditorScreen editor) {
        ContextMenu menu = new ContextMenu();
        if (editor.layout.isUniversalLayout()) {
            ContextMenu universalLayoutMenu = new ContextMenu();
            menu.addSubMenuEntry("universal_layout_settings", (class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.layoutoptions.universal_layout.options"), universalLayoutMenu);
            universalLayoutMenu.addClickableEntry("add_blacklist", (class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.layoutoptions.universal_layout.options.add_blacklist"), (menu1, entry) -> {
                TextInputScreen s = new TextInputScreen((class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.layoutoptions.universal_layout.options.input_menu_identifier"), null, call -> {
                    if (call != null) {
                        editor.history.saveSnapshot();
                        if (!editor.layout.universalLayoutMenuBlacklist.contains(call)) {
                            editor.layout.universalLayoutMenuBlacklist.add((String)call);
                        }
                    }
                    class_310.method_1551().method_1507((class_437)editor);
                });
                class_310.method_1551().method_1507((class_437)s);
            }).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.helper.editor.layoutoptions.universal_layout.options.add_blacklist.desc", new String[0])));
            universalLayoutMenu.addClickableEntry("remove_blacklist", (class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.layoutoptions.universal_layout.options.remove_blacklist"), (menu1, entry) -> class_310.method_1551().method_1507((class_437)new StringListChooserScreen((class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.layoutoptions.universal_layout.options.choose_menu_identifier"), editor.layout.universalLayoutMenuBlacklist, s1 -> {
                if (s1 != null) {
                    class_310.method_1551().method_1507((class_437)ConfirmationScreen.ofStrings(call2 -> {
                        if (call2.booleanValue()) {
                            editor.history.saveSnapshot();
                            editor.layout.universalLayoutMenuBlacklist.remove(s1);
                        }
                        class_310.method_1551().method_1507((class_437)editor);
                    }, LocalizationUtils.splitLocalizedStringLines("fancymenu.helper.editor.layoutoptions.universal_layout.options.remove_blacklist.confirm", new String[0])));
                } else {
                    class_310.method_1551().method_1507((class_437)editor);
                }
            })));
            universalLayoutMenu.addClickableEntry("clear_blacklist", (class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.layoutoptions.universal_layout.options.clear_blacklist"), (menu1, entry) -> class_310.method_1551().method_1507((class_437)ConfirmationScreen.ofStrings(call2 -> {
                if (call2.booleanValue()) {
                    editor.history.saveSnapshot();
                    editor.layout.universalLayoutMenuBlacklist.clear();
                }
                class_310.method_1551().method_1507((class_437)editor);
            }, LocalizationUtils.splitLocalizedStringLines("fancymenu.helper.editor.layoutoptions.universal_layout.options.clear_blacklist.confirm", new String[0]))));
            universalLayoutMenu.addSeparatorEntry("separator_after_clear_blacklist");
            universalLayoutMenu.addClickableEntry("add_whitelist", (class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.layoutoptions.universal_layout.options.add_whitelist"), (menu1, entry) -> {
                TextInputScreen s = new TextInputScreen((class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.layoutoptions.universal_layout.options.input_menu_identifier"), null, call -> {
                    if (call != null) {
                        editor.history.saveSnapshot();
                        if (!editor.layout.universalLayoutMenuWhitelist.contains(call)) {
                            editor.layout.universalLayoutMenuWhitelist.add((String)call);
                        }
                    }
                    class_310.method_1551().method_1507((class_437)editor);
                });
                class_310.method_1551().method_1507((class_437)s);
            }).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.helper.editor.layoutoptions.universal_layout.options.add_whitelist.desc", new String[0])));
            universalLayoutMenu.addClickableEntry("remove_whitelist", (class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.layoutoptions.universal_layout.options.remove_whitelist"), (menu1, entry) -> class_310.method_1551().method_1507((class_437)new StringListChooserScreen((class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.layoutoptions.universal_layout.options.choose_menu_identifier"), editor.layout.universalLayoutMenuWhitelist, s1 -> {
                if (s1 != null) {
                    class_310.method_1551().method_1507((class_437)ConfirmationScreen.ofStrings(call2 -> {
                        if (call2.booleanValue()) {
                            editor.history.saveSnapshot();
                            editor.layout.universalLayoutMenuWhitelist.remove(s1);
                        }
                        class_310.method_1551().method_1507((class_437)editor);
                    }, LocalizationUtils.splitLocalizedStringLines("fancymenu.helper.editor.layoutoptions.universal_layout.options.remove_whitelist.confirm", new String[0])));
                } else {
                    class_310.method_1551().method_1507((class_437)editor);
                }
            })));
            universalLayoutMenu.addClickableEntry("clear_whitelist", (class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.layoutoptions.universal_layout.options.clear_whitelist"), (menu1, entry) -> class_310.method_1551().method_1507((class_437)ConfirmationScreen.ofStrings(call2 -> {
                if (call2.booleanValue()) {
                    editor.history.saveSnapshot();
                    editor.layout.universalLayoutMenuWhitelist.clear();
                }
                class_310.method_1551().method_1507((class_437)editor);
            }, LocalizationUtils.splitLocalizedStringLines("fancymenu.helper.editor.layoutoptions.universal_layout.options.clear_whitelist.confirm", new String[0]))));
        }
        menu.addSeparatorEntry("separator_after_universal_layout_menu");
        ((ContextMenu.ClickableContextMenuEntry)menu.addClickableEntry("menu_background_settings", (class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.layoutoptions.backgroundoptions.setbackground"), (menu1, entry) -> {
            ChooseMenuBackgroundScreen s = new ChooseMenuBackgroundScreen(editor.layout.menuBackground, true, call -> {
                if (call != null) {
                    editor.history.saveSnapshot();
                    editor.layout.menuBackground = call != ChooseMenuBackgroundScreen.NO_BACKGROUND ? call : null;
                }
                class_310.method_1551().method_1507((class_437)editor);
            });
            class_310.method_1551().method_1507((class_437)s);
        }).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.helper.editor.layoutoptions.backgroundoptions.setbackground.btn.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("image"));
        menu.addValueCycleEntry("keep_background_aspect_ratio", CommonCycles.cycleEnabledDisabled("fancymenu.helper.editor.layoutoptions.backgroundoptions.keepaspect", editor.layout.preserveBackgroundAspectRatio).addCycleListener(cycle -> {
            editor.history.saveSnapshot();
            editor.layout.preserveBackgroundAspectRatio = cycle.getAsBoolean();
        })).setIcon(ContextMenu.IconFactory.getIcon("aspect_ratio"));
        menu.addSeparatorEntry("separator_after_keep_background_aspect");
        if (editor.layoutTargetScreen != null && !editor.layout.isUniversalLayout()) {
            ((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)NonStackableOverlayUI.addInputContextMenuEntryTo(menu, "edit_menu_title", (class_2561)class_2561.method_43471((String)"fancymenu.helper.editor.edit_menu_title"), () -> editor.layout.customMenuTitle, s -> {
                editor.history.saveSnapshot();
                editor.layout.customMenuTitle = s;
            }, true, null, null, false, true, consumes -> !consumes.isEmpty(), consumes -> consumes.isEmpty() ? Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.helper.editor.edit_menu_title.reset.invalid_title", new String[0])) : null).setTooltipSupplier((menu1, entry) -> !(editor.layoutTargetScreen instanceof CustomGuiBaseScreen) ? Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.helper.editor.edit_menu_title.desc", new String[0])) : Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.helper.editor.edit_menu_title.custom_gui.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("text"))).setIsActiveSupplier((menu1, entry) -> !(editor.layoutTargetScreen instanceof CustomGuiBaseScreen));
            menu.addSeparatorEntry("separator_after_edit_menu_title");
        }
        ((ContextMenu.SubMenuContextMenuEntry)((ContextMenu.SubMenuContextMenuEntry)menu.addSubMenuEntry("scroll_list_customizations", (class_2561)class_2561.method_43471((String)"fancymenu.customization.scroll_lists"), LayoutEditorUI.buildScrollListCustomizationsContextMenu(editor)).setIcon(ContextMenu.IconFactory.getIcon("scroll_edit"))).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.customization.scroll_lists.desc", new String[0])))).setIsActiveSupplier((menu1, entry) -> !(editor.layoutTargetScreen instanceof CustomGuiBaseScreen));
        menu.addSeparatorEntry("separator_after_scroll_list_customizations");
        ((ContextMenu.ClickableContextMenuEntry)menu.addClickableEntry("layout_index", (class_2561)class_2561.method_43471((String)"fancymenu.editor.layout.index"), (menu1, entry) -> {
            TextInputScreen s = new TextInputScreen((class_2561)class_2561.method_43471((String)"fancymenu.editor.layout.index"), CharacterFilter.buildIntegerFiler(), s1 -> {
                if (s1 != null && MathUtils.isInteger((String)s1)) {
                    editor.history.saveSnapshot();
                    editor.layout.layoutIndex = Integer.parseInt(s1);
                }
                class_310.method_1551().method_1507((class_437)editor);
            });
            s.setTextValidator(consumes -> TextValidators.INTEGER_TEXT_VALIDATOR.get(consumes.getText()));
            s.setText("" + editor.layout.layoutIndex);
            class_310.method_1551().method_1507((class_437)s);
        }).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.layout.index.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("stack"));
        menu.addSeparatorEntry("separator_after_layout_index");
        ((ContextMenu.ValueCycleContextMenuEntry)menu.addValueCycleEntry("random_mode", CommonCycles.cycleEnabledDisabled("fancymenu.fancymenu.editor.layoutoptions.randommode", editor.layout.randomMode).addCycleListener(cycle -> {
            editor.history.saveSnapshot();
            editor.layout.randomMode = cycle.getAsBoolean();
        })).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.fancymenu.editor.layoutoptions.randommode.btn.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("random"));
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)menu.addClickableEntry("random_mode_group", (class_2561)class_2561.method_43471((String)"fancymenu.fancymenu.editor.layoutoptions.randommode.setgroup"), (menu1, entry) -> class_310.method_1551().method_1507((class_437)TextInputScreen.build((class_2561)class_2561.method_43471((String)"fancymenu.fancymenu.editor.layoutoptions.randommode.setgroup"), CharacterFilter.buildIntegerFiler(), call -> {
            if (call != null) {
                if (!MathUtils.isInteger((String)call)) {
                    call = "1";
                }
                editor.history.saveSnapshot();
                editor.layout.randomGroup = call;
            }
            class_310.method_1551().method_1507((class_437)editor);
        }).setText(editor.layout.randomGroup))).setIsActiveSupplier((menu1, entry) -> editor.layout.randomMode)).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.fancymenu.editor.layoutoptions.randommode.setgroup.btn.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("group"));
        ((ContextMenu.ValueCycleContextMenuEntry)((ContextMenu.ValueCycleContextMenuEntry)menu.addValueCycleEntry("random_mode_first_time", CommonCycles.cycleEnabledDisabled("fancymenu.fancymenu.editor.layoutoptions.randommode.onlyfirsttime", editor.layout.randomOnlyFirstTime).addCycleListener(cycle -> {
            editor.history.saveSnapshot();
            editor.layout.randomOnlyFirstTime = cycle.getAsBoolean();
        })).setIsActiveSupplier((menu1, entry) -> editor.layout.randomMode)).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.fancymenu.editor.layoutoptions.randommode.onlyfirsttime.btn.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("random_once"));
        menu.addSeparatorEntry("separator_after_random_mode_first_time");
        menu.addValueCycleEntry("render_custom_elements_behind_vanilla", CommonCycles.cycleEnabledDisabled("fancymenu.editor.render_custom_behind_vanilla", editor.layout.renderElementsBehindVanilla).addCycleListener(cycle -> {
            editor.history.saveSnapshot();
            editor.layout.renderElementsBehindVanilla = cycle.getAsBoolean();
        })).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.render_custom_behind_vanilla.desc", new String[0])));
        menu.addSeparatorEntry("separator_after_render_custom_behind_vanilla");
        LocalizedEnumValueCycle<CommonCycles.CycleEnabledDisabled> cycleAutoScaling = CommonCycles.cycleEnabledDisabled("fancymenu.helper.editor.properties.autoscale", editor.layout.autoScalingWidth != 0 && editor.layout.autoScalingHeight != 0);
        cycleAutoScaling.addCycleListener(cycle -> {
            if (cycle.getAsBoolean()) {
                menu.closeMenu();
                class_310.method_1551().method_1507((class_437)new AutoScalingScreen(editor, call -> {
                    if (!call.booleanValue()) {
                        cycleAutoScaling.setCurrentValue(CommonCycles.CycleEnabledDisabled.DISABLED, false);
                    }
                    class_310.method_1551().method_1507((class_437)editor);
                }));
            } else {
                editor.history.saveSnapshot();
                editor.layout.autoScalingWidth = 0;
                editor.layout.autoScalingHeight = 0;
                menu.closeMenu();
                editor.method_25426();
            }
        });
        ((ContextMenu.ValueCycleContextMenuEntry)((ContextMenu.ValueCycleContextMenuEntry)menu.addValueCycleEntry("auto_scaling", cycleAutoScaling).setIsActiveSupplier((menu1, entry) -> editor.layout.forcedScale != 0.0f)).setTooltipSupplier((menu1, entry) -> {
            if (entry.isActive()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.helper.editor.properties.autoscale.btn.desc", new String[0]));
            }
            return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.helper.editor.properties.autoscale.forced_scale_needed", new String[0]));
        })).setIcon(ContextMenu.IconFactory.getIcon("measure"));
        ((ContextMenu.ClickableContextMenuEntry)((ContextMenu.ContextMenuEntry)((ContextMenu.ClickableContextMenuEntry)NonStackableOverlayUI.addIntegerInputContextMenuEntryTo(menu, "forced_gui_scale", (class_2561)class_2561.method_43471((String)"fancymenu.editor.rightclick.scale"), () -> (int)editor.layout.forcedScale, integer -> {
            editor.history.saveSnapshot();
            editor.layout.forcedScale = integer.intValue();
            if (integer == 0) {
                editor.layout.autoScalingWidth = 0;
                editor.layout.autoScalingHeight = 0;
            }
            menu.closeMenu();
            editor.method_25426();
        }, true, 0, consumes -> {
            if (MathUtils.isInteger((String)consumes)) {
                return Integer.parseInt(consumes) >= 0;
            }
            return false;
        }, consumes -> {
            if (MathUtils.isInteger((String)consumes) && Integer.parseInt(consumes) < 0) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.rightclick.scale.invalid", new String[0]));
            }
            return null;
        }).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.helper.editor.properties.scale.btn.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("measure"))).setIsActiveSupplier((menu1, entry) -> editor.layout.autoScalingWidth == 0)).setTooltipSupplier((menu1, entry) -> entry.isActive() ? null : Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.auto_scaling.disable_forced_scale_first", new String[0])));
        menu.addSeparatorEntry("separator_after_forced_scale");
        ((ContextMenu.ClickableContextMenuEntry)NonStackableOverlayUI.addAudioResourceChooserContextMenuEntryTo(menu, "open_audio", null, () -> editor.layout.openAudio, iAudioResourceSupplier -> {
            editor.history.saveSnapshot();
            editor.layout.openAudio = iAudioResourceSupplier;
        }, (class_2561)class_2561.method_43471((String)"fancymenu.editor.open_audio"), true, null, true, true, true).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.open_audio.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("sound"));
        ((ContextMenu.ClickableContextMenuEntry)NonStackableOverlayUI.addAudioResourceChooserContextMenuEntryTo(menu, "close_audio", null, () -> editor.layout.closeAudio, iAudioResourceSupplier -> {
            editor.history.saveSnapshot();
            editor.layout.closeAudio = iAudioResourceSupplier;
        }, (class_2561)class_2561.method_43471((String)"fancymenu.editor.close_audio"), true, null, true, true, true).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.close_audio.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("sound"));
        menu.addSeparatorEntry("separator_after_close_audio");
        ((ContextMenu.ClickableContextMenuEntry)menu.addClickableEntry("layout_wide_requirements", (class_2561)class_2561.method_43471((String)"fancymenu.editor.loading_requirement.layouts.loading_requirements"), (menu1, entry) -> class_310.method_1551().method_1507((class_437)new ManageRequirementsScreen(editor.layout.layoutWideLoadingRequirementContainer.copy(false), call -> {
            if (call != null) {
                editor.layout.layoutWideLoadingRequirementContainer = call;
            }
            class_310.method_1551().method_1507((class_437)editor);
        }))).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.loading_requirement.layouts.loading_requirements.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("check_list"));
        menu.addSeparatorEntry("separator_after_layout_wide_requirements");
        ((ContextMenu.ClickableContextMenuEntry)menu.addClickableEntry("paste_elements", (class_2561)class_2561.method_43471((String)"fancymenu.editor.edit.paste"), (menu1, entry) -> {
            editor.history.saveSnapshot();
            editor.pasteElementsFromClipboard();
        }).setIsActiveSupplier((menu1, entry) -> !LayoutEditorScreen.COPIED_ELEMENTS_CLIPBOARD.isEmpty())).setIcon(ContextMenu.IconFactory.getIcon("paste"));
        menu.addSeparatorEntry("separator_after_paste_elements");
        menu.addSubMenuEntry("add_element", (class_2561)class_2561.method_43471((String)"fancymenu.editor.layoutproperties.newelement"), LayoutEditorUI.buildElementContextMenu(editor)).setIcon(ContextMenu.IconFactory.getIcon("add"));
        return menu;
    }

    @NotNull
    public static ContextMenu buildScrollListCustomizationsContextMenu(@NotNull LayoutEditorScreen editor) {
        ContextMenu menu = new ContextMenu();
        NonStackableOverlayUI.addImageResourceChooserContextMenuEntryTo(menu, "header_texture", null, () -> editor.layout.scrollListHeaderTexture, iTextureResourceSupplier -> {
            editor.history.saveSnapshot();
            editor.layout.scrollListHeaderTexture = iTextureResourceSupplier;
        }, (class_2561)class_2561.method_43471((String)"fancymenu.customization.scroll_lists.header_texture"), true, null, true, true, true).setIcon(ContextMenu.IconFactory.getIcon("image"));
        NonStackableOverlayUI.addImageResourceChooserContextMenuEntryTo(menu, "footer_texture", null, () -> editor.layout.scrollListFooterTexture, iTextureResourceSupplier -> {
            editor.history.saveSnapshot();
            editor.layout.scrollListFooterTexture = iTextureResourceSupplier;
        }, (class_2561)class_2561.method_43471((String)"fancymenu.customization.scroll_lists.footer_texture"), true, null, true, true, true).setIcon(ContextMenu.IconFactory.getIcon("image"));
        menu.addSeparatorEntry("separator_after_footer_texture");
        menu.addValueCycleEntry("repeat_header_texture", CommonCycles.cycleEnabledDisabled("fancymenu.customization.scroll_lists.repeat_header", editor.layout.repeatScrollListHeaderTexture).addCycleListener(cycleEnabledDisabled -> {
            editor.history.saveSnapshot();
            editor.layout.repeatScrollListHeaderTexture = cycleEnabledDisabled.getAsBoolean();
        })).setIsActiveSupplier((menu1, entry) -> !editor.layout.preserveScrollListHeaderFooterAspectRatio);
        menu.addValueCycleEntry("repeat_footer_texture", CommonCycles.cycleEnabledDisabled("fancymenu.customization.scroll_lists.repeat_footer", editor.layout.repeatScrollListFooterTexture).addCycleListener(cycleEnabledDisabled -> {
            editor.history.saveSnapshot();
            editor.layout.repeatScrollListFooterTexture = cycleEnabledDisabled.getAsBoolean();
        })).setIsActiveSupplier((menu1, entry) -> !editor.layout.preserveScrollListHeaderFooterAspectRatio);
        menu.addSeparatorEntry("separator_after_header_footer_repeat_texture");
        ((ContextMenu.ValueCycleContextMenuEntry)menu.addValueCycleEntry("preserve_header_footer_aspect_ratio", CommonCycles.cycleEnabledDisabled("fancymenu.customization.scroll_lists.preserve_header_footer_aspect_ratio", editor.layout.preserveScrollListHeaderFooterAspectRatio).addCycleListener(cycle -> {
            editor.history.saveSnapshot();
            editor.layout.preserveScrollListHeaderFooterAspectRatio = cycle.getAsBoolean();
        })).setIcon(ContextMenu.IconFactory.getIcon("aspect_ratio"))).setIsActiveSupplier((menu1, entry) -> !editor.layout.repeatScrollListHeaderTexture && !editor.layout.repeatScrollListFooterTexture);
        menu.addSeparatorEntry("separator_after_preserve_aspect_ratio");
        menu.addValueCycleEntry("header_shadow", CommonCycles.cycleEnabledDisabled("fancymenu.customization.scroll_lists.render_header_shadow", editor.layout.renderScrollListHeaderShadow).addCycleListener(cycle -> {
            editor.history.saveSnapshot();
            editor.layout.renderScrollListHeaderShadow = cycle.getAsBoolean();
        })).setIcon(ContextMenu.IconFactory.getIcon("shadow"));
        menu.addValueCycleEntry("footer_shadow", CommonCycles.cycleEnabledDisabled("fancymenu.customization.scroll_lists.render_footer_shadow", editor.layout.renderScrollListFooterShadow).addCycleListener(cycle -> {
            editor.history.saveSnapshot();
            editor.layout.renderScrollListFooterShadow = cycle.getAsBoolean();
        })).setIcon(ContextMenu.IconFactory.getIcon("shadow"));
        menu.addSeparatorEntry("separator_after_footer_shadow");
        menu.addValueCycleEntry("show_header_footer_preview", CommonCycles.cycleEnabledDisabled("fancymenu.customization.scroll_lists.show_preview", editor.layout.showScrollListHeaderFooterPreviewInEditor).addCycleListener(cycle -> {
            editor.history.saveSnapshot();
            editor.layout.showScrollListHeaderFooterPreviewInEditor = cycle.getAsBoolean();
        })).setIcon(ContextMenu.IconFactory.getIcon("eye"));
        return menu;
    }

    @NotNull
    public static ContextMenu buildElementContextMenu(@NotNull LayoutEditorScreen editor) {
        ContextMenu menu = new ContextMenu();
        int i = 0;
        for (ElementBuilder<?, ?> builder : ElementRegistry.getBuilders()) {
            if (LayoutEditorScreen.getCurrentInstance() != null && !builder.shouldShowUpInEditorElementMenu(LayoutEditorScreen.getCurrentInstance()) || builder.isDeprecated()) continue;
            ContextMenu.ClickableContextMenuEntry<?> entry = menu.addClickableEntry("element_" + i, builder.getDisplayName(null), (menu1, entry1) -> {
                Object editorElement = builder.wrapIntoEditorElementInternal((AbstractElement)builder.buildDefaultInstance(), editor);
                if (editorElement != null) {
                    editor.history.saveSnapshot();
                    editor.normalEditorElements.add((AbstractEditorElement)editorElement);
                    if (editor.rightClickMenuOpenPosX != -1000 && editor.rightClickMenuOpenPosY != -1000) {
                        ((AbstractEditorElement)editorElement).setAnchorPoint(((AbstractEditorElement)editorElement).element.anchorPoint, true, editor.rightClickMenuOpenPosX, editor.rightClickMenuOpenPosY, true);
                        editor.deselectAllElements();
                        ((AbstractEditorElement)editorElement).setSelected(true);
                        editor.rightClickMenuOpenPosX = -1000;
                        editor.rightClickMenuOpenPosY = -1000;
                    }
                    for (AbstractLayoutEditorWidget w : editor.layoutEditorWidgets) {
                        w.editorElementAdded((AbstractEditorElement)editorElement);
                    }
                    menu.closeMenu();
                }
            });
            class_2561[] desc = builder.getDescription(null);
            if (desc != null && desc.length > 0) {
                entry.setTooltipSupplier((menu1, entry1) -> Tooltip.of(desc));
            }
            ++i;
        }
        return menu;
    }

    @NotNull
    public static ContextMenu buildHiddenVanillaElementsContextMenu(final LayoutEditorScreen editor) {
        return new ContextMenu(){

            /*
             * WARNING - void declaration
             */
            @Override
            public ContextMenu openMenuAt(float x, float y) {
                this.entries.clear();
                ArrayList<VanillaWidgetEditorElement> hiddenVanillaButtons = new ArrayList<VanillaWidgetEditorElement>();
                for (VanillaWidgetEditorElement vanillaWidgetEditorElement : editor.vanillaWidgetEditorElements) {
                    if (!vanillaWidgetEditorElement.isHidden()) continue;
                    hiddenVanillaButtons.add(vanillaWidgetEditorElement);
                }
                ArrayList<AbstractDeepEditorElement> hiddenDeepElements = new ArrayList<AbstractDeepEditorElement>();
                for (AbstractDeepEditorElement e : editor.deepEditorElements) {
                    if (!e.isHidden()) continue;
                    hiddenDeepElements.add(e);
                }
                boolean bl = false;
                for (VanillaWidgetEditorElement vanillaWidgetEditorElement : hiddenVanillaButtons) {
                    void var5_8;
                    class_339 w = ((VanillaWidgetElement)vanillaWidgetEditorElement.element).getWidget();
                    this.addClickableEntry("element_" + (int)var5_8, (class_2561)(w != null ? w.method_25369() : class_2561.method_43473()), (menu1, entry) -> {
                        editor2.history.saveSnapshot();
                        vanillaWidgetEditorElement.setHidden(false);
                        MainThreadTaskExecutor.executeInMainThread(() -> menu1.removeEntry(entry.getIdentifier()), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                    }).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.hidden_vanilla_elements.element.desc", new String[0])));
                    ++var5_8;
                }
                for (AbstractDeepEditorElement abstractDeepEditorElement : hiddenDeepElements) {
                    void var5_9;
                    this.addClickableEntry("element_" + (int)var5_9, abstractDeepEditorElement.element.builder.getDisplayName(abstractDeepEditorElement.element), (menu1, entry) -> {
                        editor2.history.saveSnapshot();
                        abstractDeepEditorElement.setHidden(false);
                        MainThreadTaskExecutor.executeInMainThread(() -> menu1.removeEntry(entry.getIdentifier()), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                    }).setTooltipSupplier((menu1, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.editor.hidden_vanilla_elements.element.desc", new String[0])));
                    ++var5_9;
                }
                return super.openMenuAt(x, y);
            }
        };
    }

    public static ContextMenu buildOpenLayoutContextMenu(LayoutEditorScreen editor) {
        ContextMenu menu = new ContextMenu();
        if (editor.layout.isUniversalLayout()) {
            List<Layout> allLayouts = LayoutHandler.getAllLayoutsForScreenIdentifier("%fancymenu:universal_layout%", true);
            int allLayoutsCount = allLayouts.size();
            int i = 0;
            for (Layout l : LayoutHandler.sortLayoutListByLastEdited(allLayouts, true, 8)) {
                if (l.getLayoutName().equals(editor.layout.getLayoutName())) continue;
                menu.addSubMenuEntry("layout_" + i, (class_2561)class_2561.method_43473(), LayoutEditorUI.buildManageLayoutSubMenu(editor, l)).setLabelSupplier((menu1, entry) -> {
                    class_2583 style = l.getStatus().getValueComponentStyle();
                    class_5250 c = class_2561.method_43470((String)l.getLayoutName());
                    c.method_10852((class_2561)class_2561.method_43470((String)" (").method_10862(style));
                    c.method_10852((class_2561)l.getStatus().getValueComponent());
                    c.method_10852((class_2561)class_2561.method_43470((String)")").method_10862(style));
                    return c;
                });
                ++i;
            }
            if (allLayoutsCount > 8) {
                String moreLayoutCount = "" + (allLayoutsCount - 8);
                menu.addClickableEntry("x_more_layouts", (class_2561)class_2561.method_43469((String)"fancymenu.overlay.menu_bar.customization.layout.manage.more_layouts", (Object[])new Object[]{moreLayoutCount}), (menu1, entry) -> LayoutEditorUI.displayUnsavedWarning(call -> {
                    if (call.booleanValue()) {
                        editor.saveWidgetSettings();
                        class_310.method_1551().method_1507((class_437)new ManageLayoutsScreen(LayoutHandler.getAllLayoutsForScreenIdentifier("%fancymenu:universal_layout%", true), editor.layoutTargetScreen, layouts -> class_310.method_1551().method_1507((class_437)editor)));
                    } else {
                        class_310.method_1551().method_1507((class_437)editor);
                    }
                }));
            }
            menu.addSeparatorEntry("separator_after_recent_layouts");
            menu.addClickableEntry("all_layouts", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.layout.manage.all"), (menu1, entry) -> LayoutEditorUI.displayUnsavedWarning(call -> {
                if (call.booleanValue()) {
                    editor.saveWidgetSettings();
                    class_310.method_1551().method_1507((class_437)new ManageLayoutsScreen(LayoutHandler.getAllLayoutsForScreenIdentifier("%fancymenu:universal_layout%", true), editor.layoutTargetScreen, layouts -> class_310.method_1551().method_1507((class_437)editor)));
                } else {
                    class_310.method_1551().method_1507((class_437)editor);
                }
            }));
        } else if (editor.layout.screenIdentifier != null) {
            List<Layout> allLayouts = LayoutHandler.getAllLayoutsForScreenIdentifier(editor.layout.screenIdentifier, false);
            int allLayoutsCount = allLayouts.size();
            int i = 0;
            for (Layout l : LayoutHandler.sortLayoutListByLastEdited(allLayouts, true, 8)) {
                if (l.getLayoutName().equals(editor.layout.getLayoutName())) continue;
                menu.addSubMenuEntry("layout_" + i, (class_2561)class_2561.method_43473(), LayoutEditorUI.buildManageLayoutSubMenu(editor, l)).setLabelSupplier((menu1, entry) -> {
                    class_2583 style = l.getStatus().getValueComponentStyle();
                    class_5250 c = class_2561.method_43470((String)l.getLayoutName());
                    c.method_10852((class_2561)class_2561.method_43470((String)" (").method_10862(style));
                    c.method_10852((class_2561)l.getStatus().getValueComponent());
                    c.method_10852((class_2561)class_2561.method_43470((String)")").method_10862(style));
                    return c;
                });
                ++i;
            }
            if (allLayoutsCount > 8) {
                String moreLayoutCount = "" + (allLayoutsCount - 8);
                menu.addClickableEntry("x_more_layouts", (class_2561)class_2561.method_43469((String)"fancymenu.overlay.menu_bar.customization.layout.manage.more_layouts", (Object[])new Object[]{moreLayoutCount}), (menu1, entry) -> LayoutEditorUI.displayUnsavedWarning(call -> {
                    if (call.booleanValue()) {
                        editor.saveWidgetSettings();
                        class_310.method_1551().method_1507((class_437)new ManageLayoutsScreen(LayoutHandler.getAllLayoutsForScreenIdentifier(editor.layout.screenIdentifier, false), editor.layoutTargetScreen, layouts -> class_310.method_1551().method_1507((class_437)editor)));
                    } else {
                        class_310.method_1551().method_1507((class_437)editor);
                    }
                }));
            }
            menu.addSeparatorEntry("separator_after_recent_layouts");
            menu.addClickableEntry("all_layouts", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.layout.manage.all"), (menu1, entry) -> LayoutEditorUI.displayUnsavedWarning(call -> {
                if (call.booleanValue()) {
                    editor.saveWidgetSettings();
                    class_310.method_1551().method_1507((class_437)new ManageLayoutsScreen(LayoutHandler.getAllLayoutsForScreenIdentifier(editor.layout.screenIdentifier, false), editor.layoutTargetScreen, layouts -> class_310.method_1551().method_1507((class_437)editor)));
                } else {
                    class_310.method_1551().method_1507((class_437)editor);
                }
            }));
        }
        return menu;
    }

    @NotNull
    protected static ContextMenu buildManageLayoutSubMenu(LayoutEditorScreen editor, Layout layout) {
        ContextMenu menu = new ContextMenu();
        menu.addClickableEntry("toggle_layout_status", (class_2561)class_2561.method_43473(), (menu1, entry) -> MainThreadTaskExecutor.executeInMainThread(() -> {
            grandfatheredMenuBar = CustomizationOverlay.getCurrentMenuBarInstance();
            layout.setEnabled(!layout.isEnabled(), true);
        }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK)).setLabelSupplier((menu1, entry) -> layout.getStatus().getCycleComponent());
        menu.addClickableEntry("edit_layout", (class_2561)class_2561.method_43471((String)"fancymenu.layout.manage.edit"), (menu1, entry) -> LayoutEditorUI.displayUnsavedWarning(call -> {
            if (call.booleanValue()) {
                editor.saveWidgetSettings();
                MainThreadTaskExecutor.executeInMainThread(() -> LayoutHandler.openLayoutEditor(layout, layout.isUniversalLayout() ? null : editor.layoutTargetScreen), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
            } else {
                class_310.method_1551().method_1507((class_437)editor);
            }
        })).setIcon(ContextMenu.IconFactory.getIcon("edit"));
        menu.addClickableEntry("edit_in_system_text_editor", (class_2561)class_2561.method_43471((String)"fancymenu.layout.manage.open_in_text_editor"), (menu1, entry) -> {
            if (layout.layoutFile != null) {
                FileUtils.openFile(layout.layoutFile);
            }
        });
        return menu;
    }
}

