/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.layout.editor.actions;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.customization.action.Executable;
import de.keksuccino.fancymenu.customization.action.blocks.AbstractExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.GenericExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.ElseExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.ElseIfExecutableBlock;
import de.keksuccino.fancymenu.customization.action.blocks.statements.IfExecutableBlock;
import de.keksuccino.fancymenu.customization.layout.editor.actions.BuildActionScreen;
import de.keksuccino.fancymenu.customization.layout.editor.loadingrequirements.ManageRequirementsScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementGroup;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.konkrete.input.MouseInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageActionsScreen
extends class_437 {
    private static final Logger LOGGER = LogManager.getLogger();
    protected GenericExecutableBlock executableBlock;
    protected Consumer<GenericExecutableBlock> callback;
    protected ScrollArea actionsScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton addActionButton;
    protected ExtendedButton moveUpButton;
    protected ExtendedButton moveDownButton;
    protected ExtendedButton editButton;
    protected ExtendedButton removeButton;
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;
    protected ExtendedButton addIfButton;
    protected ExtendedButton appendElseIfButton;
    protected ExtendedButton appendElseButton;
    @Nullable
    protected ExecutableEntry renderTickDragHoveredEntry = null;
    @Nullable
    protected ExecutableEntry renderTickDraggedEntry = null;
    private final ExecutableEntry BEFORE_FIRST = new ExecutableEntry(this.actionsScrollArea, new GenericExecutableBlock(), 1, 0);
    private final ExecutableEntry AFTER_LAST = new ExecutableEntry(this.actionsScrollArea, new GenericExecutableBlock(), 1, 0);
    protected int lastWidth = 0;
    protected int lastHeight = 0;

    public ManageActionsScreen(@NotNull GenericExecutableBlock executableBlock, @NotNull Consumer<GenericExecutableBlock> callback) {
        super((class_2561)class_2561.method_43471((String)"fancymenu.editor.action.screens.manage_screen.manage"));
        this.executableBlock = executableBlock.copy(false);
        this.callback = callback;
        this.updateActionInstanceScrollArea(false);
    }

    protected void method_25426() {
        this.addIfButton = new ExtendedButton(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.editor.actions.blocks.add.if"), button -> {
            ManageRequirementsScreen s = new ManageRequirementsScreen(new LoadingRequirementContainer(), container -> {
                if (container != null) {
                    this.executableBlock.addExecutable(new IfExecutableBlock((LoadingRequirementContainer)container));
                    this.updateActionInstanceScrollArea(false);
                    this.actionsScrollArea.verticalScrollBar.setScroll(1.0f);
                }
                class_310.method_1551().method_1507((class_437)this);
            });
            class_310.method_1551().method_1507((class_437)s);
        });
        this.method_25429((class_364)this.addIfButton);
        UIBase.applyDefaultWidgetSkinTo(this.addIfButton);
        this.appendElseIfButton = new ExtendedButton(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.editor.actions.blocks.add.else_if"), button -> {
            ExecutableEntry selected = this.getSelectedEntry();
            if (selected != null && (selected.executable instanceof IfExecutableBlock || selected.executable instanceof ElseIfExecutableBlock)) {
                ManageRequirementsScreen s = new ManageRequirementsScreen(new LoadingRequirementContainer(), container -> {
                    if (container != null) {
                        ElseIfExecutableBlock b = new ElseIfExecutableBlock((LoadingRequirementContainer)container);
                        b.setAppendedBlock(((AbstractExecutableBlock)selected.executable).getAppendedBlock());
                        ((AbstractExecutableBlock)selected.executable).setAppendedBlock(b);
                        this.updateActionInstanceScrollArea(true);
                    }
                    class_310.method_1551().method_1507((class_437)this);
                });
                class_310.method_1551().method_1507((class_437)s);
            }
        }).setIsActiveSupplier(consumes -> {
            ExecutableEntry selected = this.getSelectedEntry();
            if (selected == null) {
                return false;
            }
            return selected.executable instanceof IfExecutableBlock || selected.executable instanceof ElseIfExecutableBlock;
        });
        this.method_25429((class_364)this.appendElseIfButton);
        UIBase.applyDefaultWidgetSkinTo(this.appendElseIfButton);
        this.appendElseButton = new ExtendedButton(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.editor.actions.blocks.add.else"), button -> {
            ExecutableEntry selected = this.getSelectedEntry();
            if (selected != null && (selected.executable instanceof IfExecutableBlock || selected.executable instanceof ElseIfExecutableBlock)) {
                ElseExecutableBlock b = new ElseExecutableBlock();
                b.setAppendedBlock(((AbstractExecutableBlock)selected.executable).getAppendedBlock());
                ((AbstractExecutableBlock)selected.executable).setAppendedBlock(b);
                this.updateActionInstanceScrollArea(true);
            }
        }).setIsActiveSupplier(consumes -> {
            ExecutableEntry selected = this.getSelectedEntry();
            if (selected == null) {
                return false;
            }
            return selected.executable instanceof IfExecutableBlock || selected.executable instanceof ElseIfExecutableBlock;
        });
        this.method_25429((class_364)this.appendElseButton);
        UIBase.applyDefaultWidgetSkinTo(this.appendElseButton);
        this.addActionButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662((String)"fancymenu.editor.action.screens.add_action", (Object[])new Object[0]), button -> {
            BuildActionScreen s = new BuildActionScreen(null, call -> {
                if (call != null) {
                    this.executableBlock.addExecutable((Executable)call);
                    this.updateActionInstanceScrollArea(false);
                }
                class_310.method_1551().method_1507((class_437)this);
            });
            class_310.method_1551().method_1507((class_437)s);
        });
        this.method_25429((class_364)this.addActionButton);
        this.addActionButton.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.action.screens.add_action.desc", new String[0])));
        UIBase.applyDefaultWidgetSkinTo(this.addActionButton);
        this.moveUpButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662((String)"fancymenu.editor.action.screens.move_action_up", (Object[])new Object[0]), button -> this.moveUp(this.getSelectedEntry())){

            @Override
            public void method_25394(@NotNull class_332 graphics, int p_93658_, int p_93659_, float p_93660_) {
                ManageActionsScreen s = ManageActionsScreen.this;
                if (!s.isAnyExecutableSelected()) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.action.screens.finish.no_action_selected", new String[0])));
                    this.field_22763 = false;
                } else {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.action.screens.move_action_up.desc", new String[0])));
                    this.field_22763 = true;
                }
                super.method_25394(graphics, p_93658_, p_93659_, p_93660_);
            }
        };
        this.method_25429((class_364)this.moveUpButton);
        UIBase.applyDefaultWidgetSkinTo(this.moveUpButton);
        this.moveDownButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662((String)"fancymenu.editor.action.screens.move_action_down", (Object[])new Object[0]), button -> this.moveDown(this.getSelectedEntry())){

            @Override
            public void method_25394(@NotNull class_332 graphics, int p_93658_, int p_93659_, float p_93660_) {
                ManageActionsScreen s = ManageActionsScreen.this;
                if (!s.isAnyExecutableSelected()) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.action.screens.finish.no_action_selected", new String[0])));
                    this.field_22763 = false;
                } else {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.action.screens.move_action_down.desc", new String[0])));
                    this.field_22763 = true;
                }
                super.method_25394(graphics, p_93658_, p_93659_, p_93660_);
            }
        };
        this.method_25429((class_364)this.moveDownButton);
        UIBase.applyDefaultWidgetSkinTo(this.moveDownButton);
        this.editButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662((String)"fancymenu.editor.action.screens.edit_action", (Object[])new Object[0]), button -> {
            ExecutableEntry selected = this.getSelectedEntry();
            if (selected != null) {
                AbstractExecutableBlock block = selected.getParentBlock();
                Executable patt11049$temp = selected.executable;
                if (patt11049$temp instanceof ActionInstance) {
                    ActionInstance i = (ActionInstance)patt11049$temp;
                    s = new BuildActionScreen(i.copy(false), call -> {
                        if (call != null) {
                            int index = block.getExecutables().indexOf(selected.executable);
                            block.getExecutables().remove(selected.executable);
                            if (index != -1) {
                                block.getExecutables().add(index, (Executable)call);
                            } else {
                                block.getExecutables().add((Executable)call);
                            }
                            this.updateActionInstanceScrollArea(false);
                        }
                        class_310.method_1551().method_1507((class_437)this);
                    });
                    class_310.method_1551().method_1507(s);
                } else {
                    Executable patt11948$temp = selected.executable;
                    if (patt11948$temp instanceof IfExecutableBlock) {
                        IfExecutableBlock b = (IfExecutableBlock)patt11948$temp;
                        s = new ManageRequirementsScreen(b.condition.copy(false), container -> {
                            if (container != null) {
                                b.condition = container;
                                this.updateActionInstanceScrollArea(true);
                            }
                            class_310.method_1551().method_1507((class_437)this);
                        });
                        class_310.method_1551().method_1507(s);
                    } else {
                        Executable patt12502$temp = selected.executable;
                        if (patt12502$temp instanceof ElseIfExecutableBlock) {
                            ElseIfExecutableBlock b = (ElseIfExecutableBlock)patt12502$temp;
                            s = new ManageRequirementsScreen(b.condition.copy(false), container -> {
                                if (container != null) {
                                    b.condition = container;
                                    this.updateActionInstanceScrollArea(true);
                                }
                                class_310.method_1551().method_1507((class_437)this);
                            });
                            class_310.method_1551().method_1507(s);
                        }
                    }
                }
            }
        }).setIsActiveSupplier(consumes -> {
            ExecutableEntry selected = this.getSelectedEntry();
            if (selected == null || selected.executable instanceof ElseExecutableBlock) {
                consumes.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.action.screens.finish.no_action_selected", new String[0])));
                return false;
            }
            consumes.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.action.screens.edit_action.desc", new String[0])));
            return true;
        });
        this.method_25429((class_364)this.editButton);
        UIBase.applyDefaultWidgetSkinTo(this.editButton);
        this.removeButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662((String)"fancymenu.editor.action.screens.remove_action", (Object[])new Object[0]), button -> {
            ExecutableEntry selected = this.getSelectedEntry();
            if (selected != null) {
                class_310.method_1551().method_1507((class_437)ConfirmationScreen.ofStrings(call -> {
                    if (call.booleanValue()) {
                        if (selected.appendParent != null) {
                            selected.appendParent.setAppendedBlock(null);
                        }
                        selected.getParentBlock().getExecutables().remove(selected.executable);
                        this.updateActionInstanceScrollArea(true);
                    }
                    class_310.method_1551().method_1507((class_437)this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.action.screens.remove_action.confirm", new String[0])));
            }
        }){

            @Override
            public void method_25394(@NotNull class_332 graphics, int p_93658_, int p_93659_, float p_93660_) {
                ManageActionsScreen s = ManageActionsScreen.this;
                if (!s.isAnyExecutableSelected()) {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.action.screens.finish.no_action_selected", new String[0])));
                    this.field_22763 = false;
                } else {
                    this.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.editor.action.screens.remove_action.desc", new String[0])));
                    this.field_22763 = true;
                }
                super.method_25394(graphics, p_93658_, p_93659_, p_93660_);
            }
        };
        this.method_25429((class_364)this.removeButton);
        UIBase.applyDefaultWidgetSkinTo(this.removeButton);
        this.doneButton = new ExtendedButton(0, 0, 150, 20, class_1074.method_4662((String)"fancymenu.guicomponents.done", (Object[])new Object[0]), button -> this.callback.accept(this.executableBlock));
        this.method_25429((class_364)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.cancelButton = new ExtendedButton(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.guicomponents.cancel"), button -> this.callback.accept(null));
        this.method_25429((class_364)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
        this.doneButton.method_46421(this.field_22789 - 20 - this.doneButton.method_25368());
        this.doneButton.method_46419(this.field_22790 - 20 - 20);
        this.cancelButton.method_46421(this.field_22789 - 20 - this.cancelButton.method_25368());
        this.cancelButton.method_46419(this.doneButton.method_46427() - 5 - 20);
        this.removeButton.method_46421(this.field_22789 - 20 - this.removeButton.method_25368());
        this.removeButton.method_46419(this.cancelButton.method_46427() - 15 - 20);
        this.editButton.method_46421(this.field_22789 - 20 - this.editButton.method_25368());
        this.editButton.method_46419(this.removeButton.method_46427() - 5 - 20);
        this.moveDownButton.method_46421(this.field_22789 - 20 - this.moveDownButton.method_25368());
        this.moveDownButton.method_46419(this.editButton.method_46427() - 5 - 20);
        this.moveUpButton.method_46421(this.field_22789 - 20 - this.moveUpButton.method_25368());
        this.moveUpButton.method_46419(this.moveDownButton.method_46427() - 5 - 20);
        this.appendElseButton.method_46421(this.field_22789 - 20 - this.appendElseButton.method_25368());
        this.appendElseButton.method_46419(this.moveUpButton.method_46427() - 15 - 20);
        this.appendElseIfButton.method_46421(this.field_22789 - 20 - this.appendElseIfButton.method_25368());
        this.appendElseIfButton.method_46419(this.appendElseButton.method_46427() - 5 - 20);
        this.addIfButton.method_46421(this.field_22789 - 20 - this.addIfButton.method_25368());
        this.addIfButton.method_46419(this.appendElseIfButton.method_46427() - 5 - 20);
        this.addActionButton.method_46421(this.field_22789 - 20 - this.addActionButton.method_25368());
        this.addActionButton.method_46419(this.addIfButton.method_46427() - 5 - 20);
        ExtendedButton topRightSideWidget = this.addActionButton;
        class_1041 window = class_310.method_1551().method_22683();
        boolean resized = window.method_4480() != this.lastWidth || window.method_4507() != this.lastHeight;
        this.lastWidth = window.method_4480();
        this.lastHeight = window.method_4507();
        if (topRightSideWidget.method_46427() < 20 && window.method_4495() > 1.0) {
            double newScale = window.method_4495();
            if ((newScale -= 1.0) < 1.0) {
                newScale = 1.0;
            }
            window.method_15997(newScale);
            this.method_25410(class_310.method_1551(), window.method_4486(), window.method_4502());
        } else if (topRightSideWidget.method_46427() >= 20 && resized) {
            RenderingUtils.resetGuiScale();
            this.method_25410(class_310.method_1551(), window.method_4486(), window.method_4502());
        }
    }

    public void method_25419() {
        this.callback.accept(null);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.renderTickDragHoveredEntry = this.getDragHoveredEntry();
        this.renderTickDraggedEntry = this.getDraggedEntry();
        if (this.renderTickDraggedEntry != null) {
            float scrollOffset = 0.1f * this.actionsScrollArea.verticalScrollBar.getWheelScrollSpeed();
            if (MouseInput.getMouseY() <= this.actionsScrollArea.getInnerY()) {
                this.actionsScrollArea.verticalScrollBar.setScroll(this.actionsScrollArea.verticalScrollBar.getScroll() - scrollOffset);
            }
            if (MouseInput.getMouseY() >= this.actionsScrollArea.getInnerY() + this.actionsScrollArea.getInnerHeight()) {
                this.actionsScrollArea.verticalScrollBar.setScroll(this.actionsScrollArea.verticalScrollBar.getScroll() + scrollOffset);
            }
        }
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        class_5250 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        graphics.method_51439(this.field_22793, (class_2561)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.method_51433(this.field_22793, class_1074.method_4662((String)"fancymenu.editor.action.screens.manage_screen.actions", (Object[])new Object[0]), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.actionsScrollArea.setWidth(this.field_22789 - 20 - 150 - 20 - 20, true);
        this.actionsScrollArea.setHeight(this.field_22790 - 85, true);
        this.actionsScrollArea.setX(20, true);
        this.actionsScrollArea.setY(65, true);
        this.actionsScrollArea.render(graphics, mouseX, mouseY, partial);
        if (this.renderTickDragHoveredEntry != null) {
            int dY = this.renderTickDragHoveredEntry.getY();
            int dH = this.renderTickDragHoveredEntry.getHeight();
            if (this.renderTickDragHoveredEntry == this.BEFORE_FIRST) {
                dY = this.actionsScrollArea.getInnerY();
                dH = 1;
            }
            if (this.renderTickDragHoveredEntry == this.AFTER_LAST) {
                dY = this.actionsScrollArea.getInnerY() + this.actionsScrollArea.getInnerHeight() - 1;
                dH = 1;
            }
            graphics.method_25294(this.actionsScrollArea.getInnerX(), dY + dH - 1, this.actionsScrollArea.getInnerX() + this.actionsScrollArea.getInnerWidth(), dY + dH, UIBase.getUIColorTheme().description_area_text_color.getColorInt());
        }
        this.doneButton.method_25394(graphics, mouseX, mouseY, partial);
        this.cancelButton.method_25394(graphics, mouseX, mouseY, partial);
        this.removeButton.method_25394(graphics, mouseX, mouseY, partial);
        this.editButton.method_25394(graphics, mouseX, mouseY, partial);
        this.moveDownButton.method_25394(graphics, mouseX, mouseY, partial);
        this.moveUpButton.method_25394(graphics, mouseX, mouseY, partial);
        this.appendElseButton.method_25394(graphics, mouseX, mouseY, partial);
        this.appendElseIfButton.method_25394(graphics, mouseX, mouseY, partial);
        this.addIfButton.method_25394(graphics, mouseX, mouseY, partial);
        this.addActionButton.method_25394(graphics, mouseX, mouseY, partial);
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    public void method_25420(@NotNull class_332 $$0, int $$1, int $$2, float $$3) {
    }

    protected boolean isContentOfStatementChain(@NotNull ExecutableEntry entry, @NotNull List<ExecutableEntry> statementChain) {
        List<ExecutableEntry> parentBlockHierarchy = this.getParentBlockHierarchyOf(entry);
        for (ExecutableEntry parentBlock : parentBlockHierarchy) {
            if (!statementChain.contains(parentBlock)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected List<ExecutableEntry> getParentBlockHierarchyOf(@NotNull ExecutableEntry entry) {
        ArrayList<ExecutableEntry> blocks = new ArrayList<ExecutableEntry>();
        ExecutableEntry e = entry;
        while (e != null) {
            e = e.parentBlock != null ? this.findEntryForExecutable(e.parentBlock) : null;
            if (e == null) continue;
            blocks.add(0, e);
        }
        return blocks;
    }

    @NotNull
    protected List<ExecutableEntry> getStatementChainOf(@NotNull ExecutableEntry entry) {
        ArrayList<ExecutableEntry> entries = new ArrayList<ExecutableEntry>();
        if (entry.executable instanceof AbstractExecutableBlock) {
            ArrayList<ExecutableEntry> beforeEntry = new ArrayList<ExecutableEntry>();
            ExecutableEntry e1 = entry;
            while (e1 != null) {
                e1 = e1.appendParent != null ? this.findEntryForExecutable(e1.appendParent) : null;
                if (e1 == null) continue;
                beforeEntry.add(0, e1);
            }
            ArrayList<ExecutableEntry> afterEntry = new ArrayList<ExecutableEntry>();
            ExecutableEntry e2 = entry;
            while (e2 != null) {
                AbstractExecutableBlock b;
                AbstractExecutableBlock appendChild;
                Executable executable = e2.executable;
                if (!(executable instanceof AbstractExecutableBlock) || (e2 = (appendChild = (b = (AbstractExecutableBlock)executable).getAppendedBlock()) != null ? this.findEntryForExecutable(appendChild) : null) == null) continue;
                afterEntry.add(e2);
            }
            entries.addAll(beforeEntry);
            entries.add(entry);
            entries.addAll(afterEntry);
        }
        return entries;
    }

    @Nullable
    protected ExecutableEntry getDragHoveredEntry() {
        ExecutableEntry draggedEntry = this.getDraggedEntry();
        if (draggedEntry != null) {
            if (MouseInput.getMouseY() <= this.actionsScrollArea.getInnerY() && this.actionsScrollArea.verticalScrollBar.getScroll() == 0.0f) {
                return this.BEFORE_FIRST;
            }
            if (MouseInput.getMouseY() >= this.actionsScrollArea.getInnerY() + this.actionsScrollArea.getInnerHeight() && this.actionsScrollArea.verticalScrollBar.getScroll() == 1.0f) {
                return this.AFTER_LAST;
            }
            for (ScrollAreaEntry e : this.actionsScrollArea.getEntries()) {
                ExecutableEntry pb;
                if (!(e instanceof ExecutableEntry)) continue;
                ExecutableEntry ee = (ExecutableEntry)e;
                if (e.getY() + e.getHeight() > this.actionsScrollArea.getInnerY() + this.actionsScrollArea.getInnerHeight() || ee == draggedEntry || !UIBase.isXYInArea(MouseInput.getMouseX(), MouseInput.getMouseY(), ee.getX(), ee.getY(), ee.getWidth(), ee.getHeight()) || !this.actionsScrollArea.isMouseInsideArea()) continue;
                List<Object> statementChain = new ArrayList();
                if (draggedEntry.executable instanceof AbstractExecutableBlock) {
                    statementChain = this.getStatementChainOf(draggedEntry);
                }
                if (draggedEntry.executable instanceof AbstractExecutableBlock && statementChain.contains(ee)) {
                    return null;
                }
                if (ee.parentBlock != null && ee.parentBlock != this.executableBlock && (pb = this.findEntryForExecutable(ee.parentBlock)) != null && statementChain.contains(pb)) {
                    return null;
                }
                if (draggedEntry.executable instanceof AbstractExecutableBlock && this.isContentOfStatementChain(ee, statementChain)) {
                    return null;
                }
                return ee;
            }
        }
        return null;
    }

    @Nullable
    protected ExecutableEntry getDraggedEntry() {
        for (ScrollAreaEntry e : this.actionsScrollArea.getEntries()) {
            if (!(e instanceof ExecutableEntry)) continue;
            ExecutableEntry ee = (ExecutableEntry)e;
            if (!ee.dragging) continue;
            return ee;
        }
        return null;
    }

    @Nullable
    protected ExecutableEntry findEntryForExecutable(Executable executable) {
        for (ScrollAreaEntry e : this.actionsScrollArea.getEntries()) {
            if (!(e instanceof ExecutableEntry)) continue;
            ExecutableEntry ee = (ExecutableEntry)e;
            if (ee.executable != executable) continue;
            return ee;
        }
        return null;
    }

    @Nullable
    protected ExecutableEntry getSelectedEntry() {
        ScrollAreaEntry e = this.actionsScrollArea.getFocusedEntry();
        if (e instanceof ExecutableEntry) {
            ExecutableEntry ee = (ExecutableEntry)e;
            return ee;
        }
        return null;
    }

    protected boolean isAnyExecutableSelected() {
        return this.getSelectedEntry() != null;
    }

    @Nullable
    protected ExecutableEntry getValidMoveToEntryBefore(@NotNull ExecutableEntry entry, boolean ignoreValidityChecks) {
        if (entry == this.BEFORE_FIRST) {
            return this.BEFORE_FIRST;
        }
        int index = this.actionsScrollArea.getEntries().size();
        boolean foundEntry = false;
        boolean foundValidMoveTo = false;
        for (ScrollAreaEntry e : Lists.reverse(this.actionsScrollArea.getEntries())) {
            if (!(e instanceof ExecutableEntry)) continue;
            ExecutableEntry ee = (ExecutableEntry)e;
            --index;
            if (e == entry) {
                foundEntry = true;
                continue;
            }
            if (!ignoreValidityChecks) {
                ExecutableEntry pb;
                List<Object> statementChain = new ArrayList();
                if (entry.executable instanceof AbstractExecutableBlock) {
                    statementChain = this.getStatementChainOf(entry);
                }
                if (entry.executable instanceof AbstractExecutableBlock && statementChain.contains(ee) || ee.parentBlock != null && ee.parentBlock != this.executableBlock && (pb = this.findEntryForExecutable(ee.parentBlock)) != null && statementChain.contains(pb) || entry.executable instanceof AbstractExecutableBlock && this.isContentOfStatementChain(ee, statementChain)) continue;
            }
            if (!foundEntry) continue;
            foundValidMoveTo = true;
            break;
        }
        if (!foundValidMoveTo) {
            return null;
        }
        ScrollAreaEntry e = this.actionsScrollArea.getEntry(index);
        if (e instanceof ExecutableEntry) {
            ExecutableEntry ee = (ExecutableEntry)e;
            return ee;
        }
        return null;
    }

    @Nullable
    protected ExecutableEntry getValidMoveToEntryAfter(@NotNull ExecutableEntry entry, boolean ignoreValidityChecks) {
        if (entry == this.AFTER_LAST) {
            return this.AFTER_LAST;
        }
        int index = -1;
        boolean foundEntry = false;
        boolean foundValidMoveTo = false;
        for (ScrollAreaEntry e : this.actionsScrollArea.getEntries()) {
            if (!(e instanceof ExecutableEntry)) continue;
            ExecutableEntry ee = (ExecutableEntry)e;
            ++index;
            if (e == entry) {
                foundEntry = true;
                continue;
            }
            if (!ignoreValidityChecks) {
                ExecutableEntry pb;
                List<Object> statementChain = new ArrayList();
                if (entry.executable instanceof AbstractExecutableBlock) {
                    statementChain = this.getStatementChainOf(entry);
                }
                if (entry.executable instanceof AbstractExecutableBlock && statementChain.contains(ee) || ee.parentBlock != null && ee.parentBlock != this.executableBlock && (pb = this.findEntryForExecutable(ee.parentBlock)) != null && statementChain.contains(pb) || entry.executable instanceof AbstractExecutableBlock && this.isContentOfStatementChain(ee, statementChain)) continue;
            }
            if (!foundEntry) continue;
            foundValidMoveTo = true;
            break;
        }
        if (!foundValidMoveTo) {
            return null;
        }
        ScrollAreaEntry e = this.actionsScrollArea.getEntry(index);
        if (e instanceof ExecutableEntry) {
            ExecutableEntry ee = (ExecutableEntry)e;
            return ee;
        }
        return null;
    }

    protected void moveAfter(@NotNull ExecutableEntry entry, @NotNull ExecutableEntry moveAfter) {
        entry.getParentBlock().getExecutables().remove(entry.executable);
        int moveAfterIndex = Math.max(0, moveAfter.getParentBlock().getExecutables().indexOf(moveAfter.executable));
        if (moveAfter == this.BEFORE_FIRST) {
            this.executableBlock.getExecutables().add(0, entry.executable);
        } else if (moveAfter == this.AFTER_LAST) {
            this.executableBlock.getExecutables().add(entry.executable);
        } else {
            Executable executable = moveAfter.executable;
            if (executable instanceof AbstractExecutableBlock) {
                AbstractExecutableBlock b = (AbstractExecutableBlock)executable;
                b.getExecutables().add(0, entry.executable);
            } else {
                moveAfter.getParentBlock().getExecutables().add(moveAfterIndex + 1, entry.executable);
            }
        }
        this.updateActionInstanceScrollArea(true);
        ExecutableEntry newEntry = this.findEntryForExecutable(entry.executable);
        if (newEntry != null) {
            newEntry.setSelected(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void moveUp(ExecutableEntry entry) {
        block13: {
            block14: {
                block16: {
                    block18: {
                        block17: {
                            block15: {
                                if (entry == null) break block13;
                                if (!(entry.executable instanceof ActionInstance) && !(entry.executable instanceof IfExecutableBlock)) break block14;
                                manualUpdate = false;
                                if (this.actionsScrollArea.getEntries().indexOf(entry) != 1) break block15;
                                this.moveAfter(entry, this.BEFORE_FIRST);
                                break block16;
                            }
                            if (entry.getParentBlock() == this.executableBlock || !(entry.getParentBlock() instanceof ElseIfExecutableBlock) && !(entry.getParentBlock() instanceof ElseExecutableBlock) || entry.getParentBlock().getExecutables().indexOf(entry.executable) != 0) break block17;
                            parentBlock = this.findEntryForExecutable(entry.getParentBlock());
                            if (parentBlock != null) {
                                entry.getParentBlock().getExecutables().remove(entry.executable);
                                if (parentBlock.appendParent != null) {
                                    parentBlock.appendParent.getExecutables().add(entry.executable);
                                    manualUpdate = true;
                                }
                            }
                            break block16;
                        }
                        if (entry.getParentBlock() == this.executableBlock || !(entry.getParentBlock() instanceof IfExecutableBlock) || entry.getParentBlock().getExecutables().indexOf(entry.executable) != 0) break block18;
                        parentBlock = this.findEntryForExecutable(entry.getParentBlock());
                        if (parentBlock != null) {
                            parentIndex = Math.max(0, parentBlock.getParentBlock().getExecutables().indexOf(parentBlock.executable));
                            entry.getParentBlock().getExecutables().remove(entry.executable);
                            parentBlock.getParentBlock().getExecutables().add(parentIndex, entry.executable);
                            manualUpdate = true;
                        }
                        break block16;
                    }
                    before = this.getValidMoveToEntryBefore(entry, false);
                    if (before == null) break block16;
                    v0 = isMovable = entry.executable instanceof IfExecutableBlock != false || entry.executable instanceof ActionInstance != false;
                    if (!isMovable || !((var6_9 = before.executable) instanceof AbstractExecutableBlock)) ** GOTO lbl-1000
                    b = (AbstractExecutableBlock)var6_9;
                    if (entry.getParentBlock() != b) {
                        this.moveAfter(entry, before);
                    } else if (isMovable && !(before.executable instanceof AbstractExecutableBlock) && before.getParentBlock().getExecutables().indexOf(before.executable) == before.getParentBlock().getExecutables().size() - 1) {
                        this.moveAfter(entry, before);
                    } else {
                        beforeBefore = this.getValidMoveToEntryBefore(before, true);
                        if (beforeBefore != null) {
                            this.moveAfter(entry, beforeBefore);
                        }
                    }
                }
                if (manualUpdate) {
                    this.updateActionInstanceScrollArea(true);
                    newEntry = this.findEntryForExecutable(entry.executable);
                    if (newEntry != null) {
                        newEntry.setSelected(true);
                    }
                }
                return;
            }
            newEntry = entry.executable;
            if (newEntry instanceof ElseIfExecutableBlock) {
                ei = (ElseIfExecutableBlock)newEntry;
                entryAppendParent = entry.appendParent;
                if (entryAppendParent != null && (appendParentEntry = this.findEntryForExecutable(entryAppendParent)) != null && (parentOfParent = appendParentEntry.appendParent) != null) {
                    entryAppendParent.setAppendedBlock(ei.getAppendedBlock());
                    ei.setAppendedBlock(entryAppendParent);
                    parentOfParent.setAppendedBlock(ei);
                }
            }
            this.updateActionInstanceScrollArea(true);
            newEntry = this.findEntryForExecutable(entry.executable);
            if (newEntry != null) {
                newEntry.setSelected(true);
            }
        }
    }

    protected void moveDown(ExecutableEntry entry) {
        if (entry != null) {
            if (entry.executable instanceof ActionInstance || entry.executable instanceof IfExecutableBlock) {
                boolean manualUpdate = false;
                if (entry.getParentBlock() != this.executableBlock && entry.getParentBlock().getAppendedBlock() == null && entry.getParentBlock().getExecutables().indexOf(entry.executable) == entry.getParentBlock().getExecutables().size() - 1) {
                    ExecutableEntry parentBlock = this.findEntryForExecutable(entry.getParentBlock());
                    if (parentBlock != null) {
                        int parentIndex = -1;
                        if (parentBlock.executable instanceof IfExecutableBlock) {
                            parentIndex = Math.max(0, parentBlock.getParentBlock().getExecutables().indexOf(parentBlock.executable));
                        } else {
                            List<ExecutableEntry> chain = this.getStatementChainOf(parentBlock);
                            if (!chain.isEmpty()) {
                                parentIndex = chain.get(0).getParentBlock().getExecutables().indexOf(chain.get((int)0).executable);
                            }
                        }
                        if (parentIndex != -1) {
                            entry.getParentBlock().getExecutables().remove(entry.executable);
                            parentBlock.getParentBlock().getExecutables().add(parentIndex + 1, entry.executable);
                            manualUpdate = true;
                        }
                    }
                } else {
                    ExecutableEntry after = this.getValidMoveToEntryAfter(entry, false);
                    if (after != null) {
                        this.moveAfter(entry, after);
                    }
                }
                if (manualUpdate) {
                    this.updateActionInstanceScrollArea(true);
                    ExecutableEntry newEntry = this.findEntryForExecutable(entry.executable);
                    if (newEntry != null) {
                        newEntry.setSelected(true);
                    }
                }
                return;
            }
            Executable newEntry = entry.executable;
            if (newEntry instanceof ElseIfExecutableBlock) {
                ElseIfExecutableBlock ei = (ElseIfExecutableBlock)newEntry;
                AbstractExecutableBlock entryAppendChild = ei.getAppendedBlock();
                AbstractExecutableBlock entryAppendParent = entry.appendParent;
                if (entryAppendChild instanceof ElseIfExecutableBlock && entryAppendParent != null) {
                    ei.setAppendedBlock(entryAppendChild.getAppendedBlock());
                    entryAppendChild.setAppendedBlock(ei);
                    entryAppendParent.setAppendedBlock(entryAppendChild);
                }
            }
            this.updateActionInstanceScrollArea(true);
            ExecutableEntry newEntry2 = this.findEntryForExecutable(entry.executable);
            if (newEntry2 != null) {
                newEntry2.setSelected(true);
            }
        }
    }

    protected void updateActionInstanceScrollArea(boolean keepScroll) {
        for (ScrollAreaEntry e : this.actionsScrollArea.getEntries()) {
            if (!(e instanceof ExecutableEntry)) continue;
            ExecutableEntry ee = (ExecutableEntry)e;
            ee.leftMouseDownDragging = false;
            ee.dragging = false;
        }
        float oldScrollVertical = this.actionsScrollArea.verticalScrollBar.getScroll();
        float oldScrollHorizontal = this.actionsScrollArea.horizontalScrollBar.getScroll();
        this.actionsScrollArea.clearEntries();
        this.addExecutableToEntries(-1, this.executableBlock, null, null);
        if (keepScroll) {
            this.actionsScrollArea.verticalScrollBar.setScroll(oldScrollVertical);
            this.actionsScrollArea.horizontalScrollBar.setScroll(oldScrollHorizontal);
        }
    }

    protected void addExecutableToEntries(int level, Executable executable, @Nullable AbstractExecutableBlock appendParent, @Nullable AbstractExecutableBlock parentBlock) {
        if (level >= 0) {
            ExecutableEntry entry = new ExecutableEntry(this.actionsScrollArea, executable, 14, level);
            entry.appendParent = appendParent;
            entry.parentBlock = parentBlock;
            this.actionsScrollArea.addEntry(entry);
        }
        if (executable instanceof AbstractExecutableBlock) {
            AbstractExecutableBlock b = (AbstractExecutableBlock)executable;
            for (Executable e : b.getExecutables()) {
                this.addExecutableToEntries(level + 1, e, null, b);
            }
            if (b.getAppendedBlock() != null) {
                this.addExecutableToEntries(level, b.getAppendedBlock(), b, parentBlock);
            }
        }
    }

    public class ExecutableEntry
    extends ScrollAreaEntry {
        public static final int HEADER_FOOTER_HEIGHT = 3;
        public static final int INDENT_X_OFFSET = 20;
        @NotNull
        public Executable executable;
        @Nullable
        public AbstractExecutableBlock parentBlock;
        @Nullable
        public AbstractExecutableBlock appendParent;
        public final int lineHeight;
        public class_327 font;
        public int indentLevel;
        public boolean leftMouseDownDragging;
        public double leftMouseDownDraggingPosX;
        public double leftMouseDownDraggingPosY;
        public boolean dragging;
        private final class_5250 displayNameComponent;
        private final class_5250 valueComponent;

        public ExecutableEntry(@NotNull ScrollArea parentScrollArea, Executable executable, int lineHeight, int indentLevel) {
            super(parentScrollArea, 100, 30);
            this.font = class_310.method_1551().field_1772;
            this.leftMouseDownDragging = false;
            this.leftMouseDownDraggingPosX = 0.0;
            this.leftMouseDownDraggingPosY = 0.0;
            this.dragging = false;
            this.executable = executable;
            this.lineHeight = lineHeight;
            this.indentLevel = indentLevel;
            Executable executable2 = this.executable;
            if (executable2 instanceof ActionInstance) {
                ActionInstance i = (ActionInstance)executable2;
                this.displayNameComponent = i.action.getActionDisplayName().method_27661().method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                cachedValue = i.value;
                Object valueString = cachedValue != null && i.action.hasValue() ? cachedValue : class_1074.method_4662((String)"fancymenu.editor.action.screens.manage_screen.info.value.none", (Object[])new Object[0]);
                this.valueComponent = class_2561.method_43470((String)(class_1074.method_4662((String)"fancymenu.editor.action.screens.manage_screen.info.value", (Object[])new Object[0]) + " ")).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt())).method_10852((class_2561)class_2561.method_43470((String)valueString).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt())));
            } else {
                cachedValue = this.executable;
                if (cachedValue instanceof IfExecutableBlock) {
                    IfExecutableBlock b = (IfExecutableBlock)cachedValue;
                    requirements = "";
                    for (LoadingRequirementGroup g : b.condition.getGroups()) {
                        if (!((String)requirements).isEmpty()) {
                            requirements = (String)requirements + ", ";
                        }
                        requirements = (String)requirements + g.identifier;
                    }
                    for (LoadingRequirementInstance i : b.condition.getInstances()) {
                        if (!((String)requirements).isEmpty()) {
                            requirements = (String)requirements + ", ";
                        }
                        requirements = (String)requirements + i.requirement.getDisplayName();
                    }
                    this.displayNameComponent = class_2561.method_43469((String)"fancymenu.editor.actions.blocks.if", (Object[])new Object[]{class_2561.method_43470((String)requirements)}).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                    this.valueComponent = class_2561.method_43473();
                } else {
                    requirements = this.executable;
                    if (requirements instanceof ElseIfExecutableBlock) {
                        ElseIfExecutableBlock b = (ElseIfExecutableBlock)requirements;
                        requirements = "";
                        for (LoadingRequirementGroup g : b.condition.getGroups()) {
                            if (!((String)requirements).isEmpty()) {
                                requirements = (String)requirements + ", ";
                            }
                            requirements = (String)requirements + g.identifier;
                        }
                        for (LoadingRequirementInstance i : b.condition.getInstances()) {
                            if (!((String)requirements).isEmpty()) {
                                requirements = (String)requirements + ", ";
                            }
                            requirements = (String)requirements + i.requirement.getDisplayName();
                        }
                        this.displayNameComponent = class_2561.method_43469((String)"fancymenu.editor.actions.blocks.else_if", (Object[])new Object[]{class_2561.method_43470((String)requirements)}).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                        this.valueComponent = class_2561.method_43473();
                    } else {
                        executable2 = this.executable;
                        if (executable2 instanceof ElseExecutableBlock) {
                            ElseExecutableBlock b = (ElseExecutableBlock)executable2;
                            this.displayNameComponent = class_2561.method_43471((String)"fancymenu.editor.actions.blocks.else").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
                            this.valueComponent = class_2561.method_43473();
                        } else {
                            this.displayNameComponent = class_2561.method_43470((String)"[UNKNOWN EXECUTABLE]").method_27692(class_124.field_1061);
                            this.valueComponent = class_2561.method_43473();
                        }
                    }
                }
            }
            this.setWidth(this.calculateWidth());
            if (this.executable instanceof AbstractExecutableBlock) {
                this.setHeight(lineHeight + 6);
            } else {
                this.setHeight(lineHeight * 2 + 6);
            }
        }

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partial) {
            this.handleDragging();
            super.method_25394(graphics, mouseX, mouseY, partial);
            int centerYLine1 = this.getY() + 3 + this.lineHeight / 2;
            int centerYLine2 = this.getY() + 3 + this.lineHeight / 2 * 3;
            RenderSystem.enableBlend();
            int renderX = this.getX() + 20 * this.indentLevel;
            if (this.executable instanceof ActionInstance) {
                ExecutableEntry.renderListingDot(graphics, renderX + 5, centerYLine1 - 2, UIBase.getUIColorTheme().listing_dot_color_2.getColor());
                Objects.requireNonNull(this.font);
                graphics.method_51439(this.font, (class_2561)this.displayNameComponent, renderX + 5 + 4 + 3, centerYLine1 - 9 / 2, -1, false);
                ExecutableEntry.renderListingDot(graphics, renderX + 5 + 4 + 3, centerYLine2 - 2, UIBase.getUIColorTheme().listing_dot_color_1.getColor());
                Objects.requireNonNull(this.font);
                graphics.method_51439(this.font, (class_2561)this.valueComponent, renderX + 5 + 4 + 3 + 4 + 3, centerYLine2 - 9 / 2, -1, false);
            } else {
                ExecutableEntry.renderListingDot(graphics, renderX + 5, centerYLine1 - 2, UIBase.getUIColorTheme().warning_text_color.getColor());
                Objects.requireNonNull(this.font);
                graphics.method_51439(this.font, (class_2561)this.displayNameComponent, renderX + 5 + 4 + 3, centerYLine1 - 9 / 2, -1, false);
            }
        }

        protected void handleDragging() {
            if (!MouseInput.isLeftMouseDown()) {
                ExecutableEntry hover;
                if (this.dragging && (hover = ManageActionsScreen.this.renderTickDragHoveredEntry) != null && ManageActionsScreen.this.renderTickDraggedEntry == this) {
                    ManageActionsScreen.this.moveAfter(this, hover);
                }
                this.leftMouseDownDragging = false;
                this.dragging = false;
            }
            if (!(!this.leftMouseDownDragging || this.leftMouseDownDraggingPosX == (double)MouseInput.getMouseX() && this.leftMouseDownDraggingPosY == (double)MouseInput.getMouseY() || this.executable instanceof AbstractExecutableBlock && !(this.executable instanceof IfExecutableBlock))) {
                this.dragging = true;
            }
        }

        @NotNull
        public AbstractExecutableBlock getParentBlock() {
            if (this.parentBlock == null) {
                return ManageActionsScreen.this.executableBlock;
            }
            return this.parentBlock;
        }

        private int calculateWidth() {
            int w = 12 + this.font.method_27525((class_5348)this.displayNameComponent) + 5;
            int w2 = 19 + this.font.method_27525((class_5348)this.valueComponent) + 5;
            if (w2 > w) {
                w = w2;
            }
            return w += 20 * this.indentLevel;
        }

        @Override
        public void onClick(ScrollAreaEntry entry) {
            if (this.parent.getEntries().contains(this)) {
                this.leftMouseDownDragging = true;
                this.leftMouseDownDraggingPosX = MouseInput.getMouseX();
                this.leftMouseDownDraggingPosY = MouseInput.getMouseY();
            }
        }
    }
}

