/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui;

import com.gitlab.cdagaming.unilib.ModUtils;
import com.gitlab.cdagaming.unilib.core.CoreUtils;
import com.gitlab.cdagaming.unilib.core.impl.screen.ScreenConstants;
import com.gitlab.cdagaming.unilib.impl.ImageFrame;
import com.gitlab.cdagaming.unilib.utils.ImageUtils;
import com.gitlab.cdagaming.unilib.utils.ResourceUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.DynamicWidget;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import io.github.cdagaming.unicore.utils.TimeUtils;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_8666;

public class RenderUtils {
    public static final class_8666 DEFAULT_BUTTON_SPRITES = new class_8666(ResourceUtils.getResource("widget/button"), ResourceUtils.getResource("widget/button_disabled"), ResourceUtils.getResource("widget/button_highlighted"));
    private static final List<class_1799> BLOCKED_RENDER_ITEMS = StringUtils.newArrayList();
    private static final Map<String, Tuple<Boolean, String, class_2960>> TEXTURE_CACHE = StringUtils.newHashMap();

    public static class_2960 getScreenTexture(@Nonnull class_310 mc, int protocol) {
        return RenderUtils.getTextureData(mc, ScreenConstants.getDefaultGUIBackground(protocol)).getThird();
    }

    public static class_2960 getScreenTexture(@Nonnull class_310 mc) {
        return RenderUtils.getScreenTexture(mc, ModUtils.MCProtocolID);
    }

    public static class_2960 getButtonTexture(boolean enabled, boolean hoverState) {
        return DEFAULT_BUTTON_SPRITES.method_52729(enabled, hoverState);
    }

    public static boolean isMouseWithin(double mouseX, double mouseY, double topIn, double bottomIn, double leftIn, double rightIn) {
        return MathUtils.isWithinValue(mouseY, topIn, bottomIn, true, true) && MathUtils.isWithinValue(mouseX, leftIn, rightIn, true, true);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, double elementX, double elementY, double elementWidth, double elementHeight) {
        return MathUtils.isWithinValue(mouseX, elementX, elementX + elementWidth, true, false) && MathUtils.isWithinValue(mouseY, elementY, elementY + elementHeight, true, false);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, DynamicWidget widget) {
        return RenderUtils.isMouseOver(mouseX, mouseY, widget.getControlPosX(), widget.getControlPosY(), widget.getControlWidth() - 1, widget.getControlHeight() - 1);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedButtonControl button) {
        return button.isControlVisible() && RenderUtils.isMouseOver(mouseX, mouseY, (DynamicWidget)button);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedTextControl textControl) {
        return textControl.isControlVisible() && RenderUtils.isMouseOver(mouseX, mouseY, (DynamicWidget)textControl);
    }

    public static boolean isMouseOver(double mouseX, double mouseY, ExtendedScreen screen) {
        return screen.isLoaded() && RenderUtils.isMouseOver(mouseX, mouseY, screen.getScreenX(), screen.getScreenY(), screen.getScreenWidth(), screen.getScreenHeight());
    }

    public static boolean isMouseOver(ExtendedScreen screen) {
        return RenderUtils.isMouseOver((double)screen.getMouseX(), (double)screen.getMouseY(), screen);
    }

    public static class_327 getDefaultFontRenderer() {
        return ModUtils.getMinecraft().field_1772;
    }

    public static void openScreen(@Nonnull class_310 client, class_437 targetScreen) {
        ModUtils.executeOnMainThread(client, () -> client.method_1507(targetScreen));
    }

    public static void openScreen(@Nonnull class_310 client, ExtendedScreen targetScreen, class_437 parentScreen, boolean setParent) {
        if (setParent) {
            targetScreen.setParent(parentScreen);
        }
        RenderUtils.openScreen(client, targetScreen);
    }

    public static void openScreen(@Nonnull class_310 client, ExtendedScreen targetScreen, class_437 parentScreen) {
        RenderUtils.openScreen(client, targetScreen, parentScreen, targetScreen.getParent() == null);
    }

    public static void drawItemStack(@Nonnull class_332 client, class_327 fontRenderer, int x, int y, class_1799 stack, float scale) {
        block3: {
            if (BLOCKED_RENDER_ITEMS.contains(stack)) {
                return;
            }
            try {
                class_4587 lv = client.method_51448();
                lv.method_22903();
                lv.method_22905(scale, scale, 1.0f);
                RenderSystem.enableDepthTest();
                int xPos = Math.round((float)x / scale);
                int yPos = Math.round((float)y / scale);
                client.method_51427(stack, xPos, yPos);
                client.method_51431(fontRenderer, stack, xPos, yPos);
                RenderSystem.disableDepthTest();
                lv.method_22909();
            }
            catch (Throwable ex) {
                CoreUtils.LOG.debugError(ex);
                if (BLOCKED_RENDER_ITEMS.contains(stack)) break block3;
                BLOCKED_RENDER_ITEMS.add(stack);
            }
        }
    }

    public static void drawGradientBox(double posX, double posY, double width, double height, double zLevel, Object borderColor, Object borderColorEnd, int border, int borderOffset, Object contentColor, Object contentColorEnd) {
        double canvasWidth = width - (double)(border * 2);
        double canvasHeight = height - (double)(border * 2);
        double canvasRight = posX + (double)border + canvasWidth;
        double canvasBottom = posY + (double)border + canvasHeight;
        if (borderColor != null) {
            RenderUtils.drawGradient(posX, posX + (double)border, posY + (double)border, canvasBottom, zLevel, borderColor, borderColorEnd);
            RenderUtils.drawGradient(canvasRight, canvasRight + (double)border, posY + (double)border, canvasBottom, zLevel, borderColor, borderColorEnd);
            RenderUtils.drawGradient(posX - (double)borderOffset, canvasRight + (double)border + (double)borderOffset, canvasBottom, canvasBottom + (double)border, zLevel, borderColorEnd, borderColorEnd);
            RenderUtils.drawGradient(posX - (double)borderOffset, canvasRight + (double)border + (double)borderOffset, posY, posY + (double)border, zLevel, borderColor, borderColor);
        }
        if (contentColor != null) {
            RenderUtils.drawGradient(posX + (double)border, canvasRight, posY + (double)border, canvasBottom, zLevel, contentColor, contentColorEnd);
        }
    }

    public static void drawGradientBox(double posX, double posY, double width, double height, double zLevel, Object borderColor, Object borderColorEnd, int border, Object contentColor, Object contentColorEnd) {
        RenderUtils.drawGradientBox(posX, posY, width, height, zLevel, borderColor, borderColorEnd, border, 0, contentColor, contentColorEnd);
    }

    public static void renderSprite(@Nonnull class_332 graphics, Consumer<class_332> callback) {
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.enableDepthTest();
        callback.accept(graphics);
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void drawTexture(@Nonnull class_310 mc, double left, double right, double top, double bottom, double zLevel, double minU, double maxU, double minV, double maxV, Object startColorObj, Object endColorObj, class_2960 texLocation) {
        try {
            if (texLocation != null) {
                Pair<Boolean, Integer> data = StringUtils.getValidInteger(texLocation);
                if (data.getFirst().booleanValue()) {
                    RenderSystem.bindTexture((int)data.getSecond());
                } else {
                    RenderSystem.setShader(class_757::method_34543);
                    RenderSystem.setShaderTexture((int)0, (class_2960)texLocation);
                }
            }
        }
        catch (Exception ignored) {
            return;
        }
        Pair<Color, Color> colorData = StringUtils.findColor(startColorObj, endColorObj);
        Color startColor = colorData.getFirst();
        Color endColor = colorData.getSecond();
        if (startColor == null || endColor == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        buffer.method_22912(left, bottom, zLevel).method_22913((float)minU, (float)maxV).method_1336(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).method_1344();
        buffer.method_22912(right, bottom, zLevel).method_22913((float)maxU, (float)maxV).method_1336(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).method_1344();
        buffer.method_22912(right, top, zLevel).method_22913((float)maxU, (float)minV).method_1336(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).method_1344();
        buffer.method_22912(left, top, zLevel).method_22913((float)minU, (float)minV).method_1336(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    public static void drawTexture(@Nonnull class_310 mc, double left, double right, double top, double bottom, double zLevel, boolean usingExternalTexture, double regionWidth, double regionHeight, double u, double v, double textureWidth, double textureHeight, Object startColorObj, Object endColorObj, class_2960 texLocation) {
        RenderUtils.drawTexture(mc, left, right, top, bottom, zLevel, RenderUtils.getUVCoord(u + 0.0, 0.0, usingExternalTexture, textureWidth), RenderUtils.getUVCoord(u + regionWidth, 1.0, usingExternalTexture, textureWidth), RenderUtils.getUVCoord(v + 0.0, 0.0, usingExternalTexture, textureHeight), RenderUtils.getUVCoord(v + regionHeight, 1.0, usingExternalTexture, textureHeight), startColorObj, endColorObj, texLocation);
    }

    public static void drawTexture(@Nonnull class_310 mc, double left, double right, double top, double bottom, double zLevel, boolean usingExternalTexture, Object startColorObj, Object endColorObj, class_2960 texLocation) {
        RenderUtils.drawTexture(mc, left, right, top, bottom, zLevel, usingExternalTexture, right - left, bottom - top, left, top, 32.0, 32.0, startColorObj, endColorObj, texLocation);
    }

    public static void drawGradient(double left, double right, double top, double bottom, double zLevel, Object startColorObj, Object endColorObj) {
        Pair<Color, Color> colorData = StringUtils.findColor(startColorObj, endColorObj);
        Color startColor = colorData.getFirst();
        Color endColor = colorData.getSecond();
        if (startColor == null || endColor == null) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.blendFunc((int)770, (int)771);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22912(left, bottom, zLevel).method_1336(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).method_1344();
        buffer.method_22912(right, bottom, zLevel).method_1336(endColor.getRed(), endColor.getGreen(), endColor.getBlue(), endColor.getAlpha()).method_1344();
        buffer.method_22912(right, top, zLevel).method_1336(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).method_1344();
        buffer.method_22912(left, top, zLevel).method_1336(startColor.getRed(), startColor.getGreen(), startColor.getBlue(), startColor.getAlpha()).method_1344();
        tessellator.method_1350();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    public static void blit(double xPos, double yPos, double zLevel, double u, double v, double regionWidth, double regionHeight) {
        RenderUtils.blit(xPos, yPos, zLevel, u, v, regionWidth, regionHeight, 256.0, 256.0);
    }

    public static void blit(double xPos, double yPos, double zLevel, double u, double v, double regionWidth, double regionHeight, double textureWidth, double textureHeight) {
        RenderUtils.blit(xPos, xPos + regionWidth, yPos, yPos + regionHeight, zLevel, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void blit(double left, double right, double top, double bottom, double zLevel, double regionWidth, double regionHeight, double u, double v, double textureWidth, double textureHeight) {
        RenderUtils.innerBlit(left, right, top, bottom, zLevel, RenderUtils.getUVCoord(u + 0.0, textureWidth), RenderUtils.getUVCoord(u + regionWidth, textureWidth), RenderUtils.getUVCoord(v + 0.0, textureHeight), RenderUtils.getUVCoord(v + regionHeight, textureHeight));
    }

    public static void innerBlit(double left, double right, double top, double bottom, double zLevel, double minU, double maxU, double minV, double maxV) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        buffer.method_22912(left, bottom, zLevel).method_22913((float)minU, (float)maxV).method_1344();
        buffer.method_22912(right, bottom, zLevel).method_22913((float)maxU, (float)maxV).method_1344();
        buffer.method_22912(right, top, zLevel).method_22913((float)maxU, (float)minV).method_1344();
        buffer.method_22912(left, top, zLevel).method_22913((float)minU, (float)minV).method_1344();
        tessellator.method_1350();
    }

    public static void enableScissor(@Nonnull class_332 mc, int left, int top, int right, int bottom) {
        mc.method_44379(left, top, right, bottom);
    }

    public static void disableScissor(@Nonnull class_332 mc) {
        mc.method_44380();
    }

    public static int computeGuiScale(@Nonnull class_310 mc) {
        int scaleFactor = 1;
        int k = (Integer)mc.field_1690.method_42474().method_41753();
        if (k == 0) {
            k = 1000;
        }
        while (scaleFactor < k && mc.method_22683().method_4489() / (scaleFactor + 1) >= 320 && mc.method_22683().method_4506() / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }

    public static Tuple<Boolean, String, class_2960> getTextureData(@Nonnull class_310 mc, String texture) {
        class_2960 texLocation = ResourceUtils.getEmptyResource();
        Tuple<Boolean, String, class_2960> result = new Tuple<Boolean, String, class_2960>(false, "", texLocation);
        if (!StringUtils.isNullOrEmpty(texture)) {
            if (TEXTURE_CACHE.containsKey(texture = texture.trim())) {
                return TEXTURE_CACHE.get(texture);
            }
        } else {
            return result;
        }
        boolean usingExternalTexture = false;
        if (!StringUtils.isValidColorCode(texture)) {
            usingExternalTexture = ImageFrame.isExternalImage(texture);
            if (!usingExternalTexture) {
                if (texture.startsWith(":")) {
                    texture = texture.substring(1);
                }
                if (texture.contains(":")) {
                    String[] splitInput = texture.split(":", 2);
                    texLocation = ResourceUtils.getResource(splitInput[0], splitInput[1]);
                } else {
                    texLocation = ResourceUtils.getResource(texture);
                }
            } else {
                String formattedConvertedName = texture.replaceFirst("file://", "");
                String[] urlBits = formattedConvertedName.trim().split("/");
                String textureName = urlBits[urlBits.length - 1].trim();
                texLocation = ImageUtils.getTextureFromUrl(mc, textureName, texture.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
            }
        }
        result.put(usingExternalTexture, texture, texLocation);
        if (!usingExternalTexture) {
            TEXTURE_CACHE.put(texture, result);
        }
        return result;
    }

    public static void drawMultiLineString(@Nonnull class_310 mc, @Nonnull class_332 matrixStack, List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, class_327 fontRenderer, boolean isCentered, boolean isTooltip, ScreenConstants.TooltipData colorInfo) {
        if (colorInfo.renderTooltips() && !textToInput.isEmpty() && fontRenderer != null) {
            boolean usingExternalTexture;
            Tuple<Boolean, String, class_2960> textureData;
            List<String> textLines = textToInput;
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = RenderUtils.getStringWidth(fontRenderer, textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean allowXAdjustments = maxWidth > 0;
            boolean allowYAdjustments = maxHeight > 0;
            boolean allowCenterAdjustments = isCentered && allowXAdjustments;
            int titleLinesCount = 1;
            int tooltipX = posX;
            if (!isTooltip && allowCenterAdjustments) {
                tooltipX = posX + 4;
                tooltipTextWidth = maxWidth - tooltipX - 4;
            } else if (isTooltip) {
                tooltipX = posX + (allowXAdjustments ? 12 : 0);
                if (allowXAdjustments && tooltipX + tooltipTextWidth + 4 > maxWidth && (tooltipX = posX - 16 - tooltipTextWidth) < 4) {
                    tooltipTextWidth = posX > maxWidth / 2 ? posX - 12 - 8 : maxWidth - 16 - posX;
                    needsWrap = true;
                }
                if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                    tooltipTextWidth = maxTextWidth;
                    needsWrap = true;
                }
            }
            if (needsWrap) {
                List wrappedTextLines = StringUtils.newArrayList();
                int wrappedTooltipWidth = 0;
                for (int i = 0; i < textLines.size(); ++i) {
                    List<String> wrappedLine = RenderUtils.listFormattedStringToWidth(fontRenderer, textLines.get(i), tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = RenderUtils.getStringWidth(fontRenderer, line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                if (allowXAdjustments) {
                    tooltipX = posX > maxWidth / 2 ? posX - 16 - tooltipTextWidth : posX + 12;
                }
            }
            int tooltipY = posY - (isTooltip && allowYAdjustments ? 12 : 0);
            int tooltipHeight = 8;
            int fontHeight = RenderUtils.getFontHeight(fontRenderer);
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * (fontHeight + 1);
                if (isTooltip && textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            if (allowYAdjustments) {
                if (tooltipY < 4) {
                    tooltipY = 4;
                } else if (tooltipY + tooltipHeight + 4 > maxHeight) {
                    tooltipY = maxHeight - tooltipHeight - 4;
                }
            }
            ScreenConstants.ColorData backgroundColorInfo = colorInfo.backgroundColor();
            ScreenConstants.ColorData borderColorInfo = colorInfo.borderColor();
            int zLevel = 400;
            if (backgroundColorInfo != null) {
                Color backgroundStart = backgroundColorInfo.startColor();
                Color backgroundEnd = backgroundColorInfo.endColor();
                if (StringUtils.isNullOrEmpty(backgroundColorInfo.texLocation())) {
                    RenderUtils.drawGradientBox(tooltipX - 4, tooltipY - 4, tooltipTextWidth + 8, tooltipHeight + 8, 400.0, backgroundStart, backgroundEnd, 1, -1, backgroundStart, backgroundEnd);
                } else {
                    textureData = RenderUtils.getTextureData(mc, backgroundColorInfo.texLocation());
                    usingExternalTexture = textureData.getFirst();
                    class_2960 backGroundTexture = textureData.getThird();
                    double width = tooltipTextWidth + 4;
                    double height = tooltipHeight + 4;
                    double left = tooltipX - 4;
                    double right = (double)tooltipX + width;
                    double top = tooltipY - 4;
                    double bottom = (double)tooltipY + height;
                    RenderUtils.drawTexture(mc, left, right, top, bottom, 0.0, usingExternalTexture, backgroundStart, backgroundEnd, backGroundTexture);
                }
            }
            if (borderColorInfo != null) {
                Color borderStart = borderColorInfo.startColor();
                Color borderEnd = borderColorInfo.endColor();
                if (StringUtils.isNullOrEmpty(borderColorInfo.texLocation())) {
                    RenderUtils.drawGradientBox(tooltipX - 3, tooltipY - 3, tooltipTextWidth + 6, tooltipHeight + 6, 400.0, borderStart, borderEnd, 1, null, null);
                } else {
                    textureData = RenderUtils.getTextureData(mc, borderColorInfo.texLocation());
                    usingExternalTexture = textureData.getFirst();
                    class_2960 borderTexture = textureData.getThird();
                    double border = 1.0;
                    double renderX = tooltipX - 3;
                    double renderY = tooltipY - 3;
                    double canvasRight = tooltipX + tooltipTextWidth + 2;
                    double canvasBottom = tooltipY + tooltipHeight + 2;
                    RenderUtils.drawTexture(mc, renderX, renderX + 1.0, renderY, canvasBottom + 1.0, 400.0, usingExternalTexture, borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, canvasRight, canvasRight + 1.0, renderY, canvasBottom + 1.0, 400.0, usingExternalTexture, borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, renderX, canvasRight + 1.0, canvasBottom, canvasBottom + 1.0, 400.0, usingExternalTexture, borderStart, borderEnd, borderTexture);
                    RenderUtils.drawTexture(mc, renderX, canvasRight + 1.0, renderY, renderY + 1.0, 400.0, usingExternalTexture, borderStart, borderEnd, borderTexture);
                }
            }
            matrixStack.method_51448().method_22903();
            matrixStack.method_51448().method_22904(0.0, 0.0, 400.0);
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = textLines.get(lineNumber);
                int lineWidth = RenderUtils.getStringWidth(fontRenderer, line);
                int renderX = isCentered ? tooltipX + (tooltipTextWidth - lineWidth) / 2 : tooltipX;
                RenderUtils.renderString(matrixStack, fontRenderer, line, renderX, tooltipY, -1);
                if (isTooltip && lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += fontHeight + 1;
            }
            matrixStack.method_51448().method_22909();
        }
    }

    public static void renderCenteredString(@Nonnull class_332 matrixStack, class_327 fontRenderer, String text, float xPos, float yPos, int color) {
        RenderUtils.renderString(matrixStack, fontRenderer, text, xPos - (float)RenderUtils.getStringWidth(fontRenderer, text) / 2.0f, yPos, color);
    }

    public static void renderCenteredString(@Nonnull class_332 matrixStack, class_327 fontRenderer, String text, int xPos, int yPos, int color) {
        RenderUtils.renderString(matrixStack, fontRenderer, text, xPos - RenderUtils.getStringWidth(fontRenderer, text) / 2, yPos, color);
    }

    public static void renderString(@Nonnull class_332 matrixStack, class_327 fontRenderer, String text, float xPos, float yPos, int color) {
        if (!StringUtils.isNullOrEmpty(text)) {
            fontRenderer.method_27522(text, xPos, yPos, color, true, matrixStack.method_51448().method_23760().method_23761(), (class_4597)matrixStack.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0, fontRenderer.method_1726());
            matrixStack.method_51744();
        }
    }

    public static void renderString(@Nonnull class_332 matrixStack, class_327 fontRenderer, String text, int xPos, int yPos, int color) {
        RenderUtils.renderString(matrixStack, fontRenderer, text, (float)xPos, (float)yPos, color);
    }

    public static int getStringWidth(class_327 fontRenderer, String string) {
        return fontRenderer.method_1727(string);
    }

    public static int getFontHeight(class_327 fontRenderer) {
        Objects.requireNonNull(fontRenderer);
        return 9;
    }

    public static void renderScrollingString(@Nonnull class_332 matrixStack, @Nonnull class_310 mc, class_327 fontRenderer, String message, float centerX, float minX, float minY, float maxX, float maxY, int color) {
        int lineWidth = RenderUtils.getStringWidth(fontRenderer, message);
        float renderY = (minY + maxY - (float)RenderUtils.getFontHeight(fontRenderer)) / 2.0f + 1.0f;
        float elementWidth = maxX - minX;
        if ((float)lineWidth > elementWidth) {
            float renderWidth = (float)lineWidth - elementWidth;
            double renderTime = (double)TimeUtils.getElapsedMillis() / 1000.0;
            double renderDistance = Math.max((double)renderWidth * 0.5, 3.0);
            double percentage = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * renderTime / renderDistance)) / 2.0 + 0.5;
            double offset = MathUtils.lerp(percentage, 0.0, (double)renderWidth);
            RenderUtils.enableScissor(matrixStack, (int)minX, (int)minY, (int)maxX, (int)maxY);
            RenderUtils.renderString(matrixStack, fontRenderer, message, minX - (float)offset, renderY, color);
            RenderUtils.disableScissor(matrixStack);
        } else {
            float renderX = MathUtils.clamp(centerX, minX + (float)lineWidth / 2.0f, maxX - (float)lineWidth / 2.0f);
            RenderUtils.renderCenteredString(matrixStack, fontRenderer, message, renderX, renderY, color);
        }
    }

    public static void renderScrollingString(@Nonnull class_332 matrixStack, @Nonnull class_310 mc, class_327 fontRenderer, String message, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        int lineWidth = RenderUtils.getStringWidth(fontRenderer, message);
        int renderY = (minY + maxY - RenderUtils.getFontHeight(fontRenderer)) / 2 + 1;
        int elementWidth = maxX - minX;
        if (lineWidth > elementWidth) {
            int renderWidth = lineWidth - elementWidth;
            double renderTime = (double)TimeUtils.getElapsedMillis() / 1000.0;
            double renderDistance = Math.max((double)renderWidth * 0.5, 3.0);
            double percentage = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * renderTime / renderDistance)) / 2.0 + 0.5;
            double offset = MathUtils.lerp(percentage, 0.0, (double)renderWidth);
            RenderUtils.enableScissor(matrixStack, minX, minY, maxX, maxY);
            RenderUtils.renderString(matrixStack, fontRenderer, message, minX - (int)offset, renderY, color);
            RenderUtils.disableScissor(matrixStack);
        } else {
            int renderX = MathUtils.clamp(centerX, minX + lineWidth / 2, maxX - lineWidth / 2);
            RenderUtils.renderCenteredString(matrixStack, fontRenderer, message, renderX, renderY, color);
        }
    }

    public static void renderScrollingString(@Nonnull class_332 matrixStack, @Nonnull class_310 mc, class_327 fontRenderer, String message, float minX, float minY, float maxX, float maxY, int color) {
        RenderUtils.renderScrollingString(matrixStack, mc, fontRenderer, message, maxX - (maxX - minX) / 2.0f, minX, minY, maxX, maxY, color);
    }

    public static void renderScrollingString(@Nonnull class_332 matrixStack, @Nonnull class_310 mc, class_327 fontRenderer, String message, int minX, int minY, int maxX, int maxY, int color) {
        RenderUtils.renderScrollingString(matrixStack, mc, fontRenderer, message, maxX - (maxX - minX) / 2, minX, minY, maxX, maxY, color);
    }

    public static double getUVCoord(double primary, double secondary, boolean usingExternalTexture, double textureSize) {
        return usingExternalTexture ? secondary : RenderUtils.getUVCoord(primary, textureSize);
    }

    public static double getUVCoord(double primary, double textureSize) {
        return primary / textureSize;
    }

    public static List<String> listFormattedStringToWidth(class_327 fontRenderer, String stringInput, int wrapWidth) {
        List<String> result = StringUtils.newArrayList();
        fontRenderer.method_27527().method_27498(stringInput, wrapWidth, class_2583.field_24360).forEach(line -> result.add(line.getString()));
        return result;
    }
}

