/*
 * Decompiled with CFR 0.152.
 */
package neoforge.net.creep3rcrafter.mysticpotions.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;

public class ItemDamage {
    public static List<Item> items = new ArrayList<Item>();

    public static List<Item> getItems() {
        items.add(Items.ACTIVATOR_RAIL);
        items.add(Items.ANVIL);
        items.add(Items.BLAST_FURNACE);
        items.add(Items.IRON_BLOCK);
        items.add(Items.BUCKET);
        items.add(Items.LAVA_BUCKET);
        items.add(Items.WATER_BUCKET);
        items.add(Items.MILK_BUCKET);
        items.add(Items.CAULDRON);
        items.add(Items.CHAIN);
        items.add(Items.DETECTOR_RAIL);
        items.add(Items.HEAVY_WEIGHTED_PRESSURE_PLATE);
        items.add(Items.HOPPER);
        items.add(Items.IRON_BARS);
        items.add(Items.IRON_DOOR);
        items.add(Items.IRON_TRAPDOOR);
        items.add(Items.IRON_NUGGET);
        items.add(Items.MINECART);
        items.add(Items.PISTON);
        items.add(Items.RAIL);
        items.add(Items.SMITHING_TABLE);
        items.add(Items.STONECUTTER);
        items.add(Items.TRIPWIRE_HOOK);
        return items;
    }

    public static ItemDamageType getItemDamageType(Item item) {
        if (item instanceof ArmorItem) {
            if (((ArmorItem)item).getMaterial() == ArmorMaterials.IRON || ((ArmorItem)item).getMaterial() == ArmorMaterials.CHAIN) {
                return ItemDamageType.IRON;
            }
            if (((ArmorItem)item).getMaterial() == ArmorMaterials.NETHERITE) {
                return ItemDamageType.NETHERITE;
            }
        } else if (item instanceof TieredItem) {
            if (((TieredItem)item).getTier() == Tiers.IRON) {
                return ItemDamageType.IRON;
            }
            if (((TieredItem)item).getTier() == Tiers.NETHERITE) {
                return ItemDamageType.NETHERITE;
            }
        } else if (item instanceof ShieldItem || item instanceof CrossbowItem || item instanceof FlintAndSteelItem || item instanceof ShearsItem) {
            return ItemDamageType.IRON;
        }
        return null;
    }

    public static enum ItemDamageType {
        IRON(10),
        NETHERITE(20);

        public final int damage;

        private ItemDamageType(int damage) {
            this.damage = damage;
        }
    }
}

