/*
 * Decompiled with CFR 0.152.
 */
package neoforge.net.creep3rcrafter.mysticpotions.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import neoforge.net.creep3rcrafter.mysticpotions.utils.ItemDamage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Utils {
    public static void lightning(LivingEntity livingEntity, ServerLevel serverLevel, int amplifier) {
        Utils.lightning(livingEntity, serverLevel);
        for (int i = 0; i < amplifier; ++i) {
            Random random = new Random();
            BlockPos entityPos = livingEntity.blockPosition();
            BlockPos blockPos = entityPos.offset(random.nextInt(amplifier) - amplifier / 2, random.nextInt(amplifier) - amplifier / 2, random.nextInt(amplifier) - amplifier / 2);
            LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)serverLevel);
            lightningbolt.moveTo(Vec3.atBottomCenterOf((Vec3i)blockPos));
            lightningbolt.setCause(livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null);
            serverLevel.addFreshEntity((Entity)lightningbolt);
        }
    }

    public static void lightning(LivingEntity livingEntity, ServerLevel serverLevel) {
        BlockPos entityPos = livingEntity.blockPosition();
        LightningBolt LightningBolt2 = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)serverLevel);
        LightningBolt2.moveTo(Vec3.atBottomCenterOf((Vec3i)entityPos));
        LightningBolt2.setCause(livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null);
        serverLevel.addFreshEntity((Entity)LightningBolt2);
    }

    public static void explode(Level level, BlockPos blockPos) {
        Utils.explode(level, blockPos, 4.0f);
    }

    public static void explode(Level level, BlockPos blockPos, float radius) {
        Utils.explode(level, blockPos, radius, false);
    }

    public static void explode(Level level, BlockPos blockPos, float radius, boolean fire) {
        level.explode(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), radius, fire, Level.ExplosionInteraction.MOB);
    }

    public static void explode(ServerLevel level, BlockPos blockPos) {
        Utils.explode(level, blockPos, 4.0f);
    }

    public static void explode(ServerLevel level, BlockPos blockPos, float radius) {
        Utils.explode(level, blockPos, radius, false);
    }

    public static void explode(ServerLevel level, BlockPos blockPos, float radius, boolean fire) {
        level.explode(null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), radius, fire, Level.ExplosionInteraction.MOB);
    }

    public static int cropAgeToIndex(int age) {
        if (age > 6) {
            return 3;
        }
        if (age > 3) {
            return 2;
        }
        if (age > 1) {
            return 1;
        }
        return 0;
    }

    public static void dropXP(ServerLevel level, BlockPos blockPos) {
        int j;
        for (int i = 3 + level.random.nextInt(5) + level.random.nextInt(5); i > 0; i -= j) {
            j = ExperienceOrb.getExperienceValue((int)i);
            level.addFreshEntity((Entity)new ExperienceOrb((Level)level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), j));
        }
    }

    public static void damageItem(LivingEntity livingEntity, EquipmentSlot equipmentSlot, int amplifier, Random random) {
        int chance;
        if (livingEntity.getItemBySlot(equipmentSlot).isDamageableItem() && (chance = random.nextInt(10)) >= 5) {
            Item item = livingEntity.getItemBySlot(equipmentSlot).getItem();
            if (ItemDamage.getItemDamageType(item) == ItemDamage.ItemDamageType.IRON) {
                livingEntity.getItemBySlot(equipmentSlot).hurtAndBreak(ItemDamage.ItemDamageType.IRON.damage / 2 * amplifier, livingEntity, source -> source.broadcastBreakEvent(equipmentSlot));
            }
            if (ItemDamage.getItemDamageType(item) == ItemDamage.ItemDamageType.NETHERITE) {
                livingEntity.getItemBySlot(equipmentSlot).hurtAndBreak(ItemDamage.ItemDamageType.NETHERITE.damage / 2 * amplifier, livingEntity, source -> source.broadcastBreakEvent(equipmentSlot));
            }
        }
    }

    public static void damageItem(LivingEntity livingEntity, EquipmentSlot equipmentSlot, int damage) {
        if (livingEntity.getItemBySlot(equipmentSlot).isDamageableItem()) {
            livingEntity.getItemBySlot(equipmentSlot).hurtAndBreak(damage, livingEntity, source -> source.broadcastBreakEvent(equipmentSlot));
        }
    }

    public static void damageItem(LivingEntity livingEntity, ItemStack itemStack, int damage) {
        if (itemStack.isDamageableItem()) {
            itemStack.hurtAndBreak(damage, livingEntity, source -> source.broadcastBreakEvent(EquipmentSlot.CHEST));
        }
    }

    public static <C extends Container, T extends Recipe<C>> List<Item> recipesContainsItems(MinecraftServer server, RecipeType<T> recipeType, List<Item> containsList) {
        ArrayList results = new ArrayList();
        server.getRecipeManager().getAllRecipesFor(recipeType).forEach(recipe -> recipe.value().getIngredients().forEach(ingredient -> {
            for (Item item : containsList) {
                if (!ingredient.test(new ItemStack((ItemLike)item))) continue;
                results.add(recipe.value().getResultItem((RegistryAccess)RegistryAccess.EMPTY).getItem());
            }
        }));
        return new ArrayList<Item>(new HashSet(results));
    }

    public int getDistanceToEntity(LivingEntity livingEntity, BlockPos pos) {
        double deltaX = livingEntity.getX() - (double)pos.getX();
        double deltaY = livingEntity.getY() - (double)pos.getY();
        double deltaZ = livingEntity.getZ() - (double)pos.getZ();
        return (int)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public List<BlockPos> getNearbyBlocks(LivingEntity livingEntity, int radius) {
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int x = livingEntity.blockPosition().getX() - radius; x <= livingEntity.blockPosition().getX() + radius; ++x) {
            for (int y = livingEntity.blockPosition().getY() - radius; y <= livingEntity.blockPosition().getY() + radius; ++y) {
                for (int z = livingEntity.blockPosition().getZ() - radius; z <= livingEntity.blockPosition().getZ() + radius; ++z) {
                    blockPositions.add(new BlockPos(x, y, z));
                }
            }
        }
        return blockPositions;
    }
}

