/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.bow.handler;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.attribute.BaseAttribute;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttributeBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.minecraft.common.feature.FeatureUtils;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.StopHandler;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.StateEncoder;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import com.sigmundgranaas.forgero.minecraft.common.utils.PropertyUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1744;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2520;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class LaunchProjectileHandler
implements StopHandler {
    private final StateService service;
    public static final String TYPE = "forgero:launch_projectile";
    public static final JsonBuilder<LaunchProjectileHandler> BUILDER = HandlerBuilder.fromObject(LaunchProjectileHandler.class, LaunchProjectileHandler::fromJson);
    public static final PropertyContainer DEFAULT_ARROW = PropertyContainer.of((Property)BaseAttribute.of((float)50.0f, (String)"forgero:accuracy"));
    public static final PropertyContainer DEFAULT_BOW = PropertyContainer.of(List.of(BaseAttribute.of((float)2.0f, (String)"forgero:draw_power"), BaseAttribute.of((float)1.0f, (String)"forgero:draw_speed")));
    private final Attribute power;
    private final Attribute accuracy;
    private final boolean canBeCritical = true;

    public LaunchProjectileHandler(Attribute power, Attribute accuracy) {
        this.power = power;
        this.accuracy = accuracy;
        this.service = StateService.INSTANCE;
    }

    public static LaunchProjectileHandler fromJson(JsonObject json) {
        Attribute power = FeatureUtils.of((JsonObject)json, (String)"draw_power", (String)"forgero:draw_power", (int)0);
        Attribute accuracy = FeatureUtils.of((JsonObject)json, (String)"accuracy", (String)"forgero:accuracy", (int)0);
        return new LaunchProjectileHandler(power, accuracy);
    }

    public void stoppedUsing(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!(user instanceof class_1657)) {
            return;
        }
        class_1657 playerEntity = (class_1657)user;
        class_1799 arrowStack = this.obtainArrowStack(playerEntity);
        if (arrowStack.method_7960()) {
            return;
        }
        int useTime = stack.method_7935() - remainingUseTicks;
        if (useTime > 1) {
            this.fireArrow(world, playerEntity, arrowStack, useTime, stack.method_46651(1));
            this.removeItemFromState(stack, playerEntity, playerEntity.method_6058());
            world.method_43128(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, 1.0f / (world.method_8409().method_43057() * 0.4f + 1.2f) + (float)useTime / 10.0f * 0.5f);
            if (!this.isCreativeMode(playerEntity)) {
                this.decrementArrowStack(playerEntity, arrowStack);
            }
        }
    }

    private void removeItemFromState(class_1799 bow, class_1657 player, class_1268 hand) {
        Object t;
        Optional arrow = StateService.INSTANCE.convert(this.obtainArrowStack(player));
        Optional bowState = StateService.INSTANCE.convert(bow);
        if (arrow.isPresent() && bowState.isPresent() && (t = bowState.get()) instanceof Composite) {
            Composite composite = (Composite)t;
            State converted = composite.removeUpgrade(((State)arrow.get()).identifier());
            class_1799 newBow = bow.method_7972();
            newBow.method_7948().method_10566(NbtConstants.FORGERO_IDENTIFIER, (class_2520)StateEncoder.ENCODER.encode(converted));
            player.method_6122(hand, newBow);
            if (!player.method_7337()) {
                newBow.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
            }
        }
    }

    private void fireArrow(class_1937 world, class_1657 shooter, class_1799 arrowStack, int useTime, class_1799 bow) {
        if (world.field_9236) {
            return;
        }
        class_1744 arrowItem = arrowStack.method_7909() instanceof class_1744 ? (class_1744)arrowStack.method_7909() : (class_1744)class_1802.field_8107;
        class_1665 projectile = this.createProjectile(arrowItem, arrowStack, shooter, world);
        float pullProgress = LaunchProjectileHandler.getPullProgress(useTime, this.getDrawTime(shooter));
        if (pullProgress == 1.0f) {
            projectile.method_7439(true);
        }
        LaunchParams params = this.createParams(pullProgress, bow);
        this.applyVelocity(projectile, shooter, params);
        world.method_8649((class_1297)projectile);
    }

    private boolean isCreativeMode(class_1657 player) {
        return player.method_31549().field_7477;
    }

    private void decrementArrowStack(class_1657 shooter, class_1799 arrowStack) {
        arrowStack.method_7934(1);
        if (arrowStack.method_7960()) {
            shooter.method_31548().method_7378(arrowStack);
        }
    }

    private float getDrawTime(class_1657 shooter) {
        float drawTime = ComputedAttributeBuilder.of((String)"forgero:draw_speed").addSource(PropertyUtils.container((class_1297)shooter)).build().asFloat().floatValue();
        return Math.max(drawTime, 0.1f);
    }

    private class_1665 createProjectile(class_1744 arrowItem, class_1799 arrowStack, class_1657 shooter, class_1937 world) {
        return arrowItem.method_7702(world, arrowStack, (class_1309)shooter);
    }

    private void applyVelocity(class_1665 projectile, class_1657 shooter, LaunchParams params) {
        projectile.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454(), params.roll(), params.power(), LaunchProjectileHandler.accuracyToDivergence(params.accuracy()));
    }

    public static float accuracyToDivergence(float accuracy) {
        double a = 20.0;
        double b = -0.045;
        double pow = 1.1;
        double divergence = a * Math.exp(b * Math.pow(accuracy, pow));
        return (float)Math.max(divergence, 0.0);
    }

    private LaunchParams createParams(float pullProgress, class_1799 bow) {
        float power = ComputedAttributeBuilder.of((String)"forgero:draw_power").addSource(this.power).addSource(this.service.convert(bow).map(PropertyContainer.class::cast).orElse(DEFAULT_BOW)).build().asFloat().floatValue();
        float accuracy = ComputedAttributeBuilder.of((String)"forgero:accuracy").addSource(this.accuracy).addSource(this.service.convert(bow).map(PropertyContainer.class::cast).orElse(DEFAULT_BOW)).build().asFloat().floatValue();
        float roll = 0.0f;
        return new LaunchParams(power * pullProgress, accuracy, roll);
    }

    private class_1799 obtainArrowStack(class_1657 playerEntity) {
        class_1799 arrowStack = playerEntity.method_18808(playerEntity.method_6047());
        if (arrowStack.method_7960() && !playerEntity.method_31549().field_7477) {
            arrowStack = new class_1799((class_1935)class_1802.field_8107);
        }
        return arrowStack;
    }

    public static float getPullProgress(int useTicks, float drawSpeed) {
        float f = (float)useTicks * (drawSpeed / 20.0f);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private record LaunchParams(float power, float accuracy, float roll) {
    }
}

