/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.bow.predicate;

import com.google.gson.JsonElement;
import com.sigmundgranaas.forgero.bow.handler.LaunchProjectileHandler;
import com.sigmundgranaas.forgero.core.model.match.builders.ElementParser;
import com.sigmundgranaas.forgero.core.model.match.builders.PredicateBuilder;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.match.MinecraftContextKeys;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

public record BowPullPredicate(float pullProgress) implements Matchable
{
    public static String ID = "forgero:bow_pull";

    public boolean test(Matchable match, MatchContext context) {
        Object t;
        Optional entityOpt = context.get(MinecraftContextKeys.ENTITY);
        Optional stackOpt = context.get(MinecraftContextKeys.STACK);
        if (entityOpt.isPresent() && stackOpt.isPresent() && (t = entityOpt.get()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)t;
            class_1799 stack = (class_1799)stackOpt.get();
            float drawTime = this.getDynamicDrawTime(stack);
            float pull = livingEntity.method_6030() != stack ? 0.0f : LaunchProjectileHandler.getPullProgress(livingEntity.method_6048(), drawTime);
            return pull >= this.pullProgress;
        }
        return false;
    }

    private float getDynamicDrawTime(class_1799 stack) {
        Optional state = StateService.INSTANCE.convert(stack);
        if (state.isPresent()) {
            return ComputedAttribute.of((PropertyContainer)((PropertyContainer)state.get()), (String)"forgero:draw_speed").asFloat().floatValue();
        }
        return 1.0f;
    }

    public boolean isDynamic() {
        return true;
    }

    public static class BowPullPredicateBuilder
    implements PredicateBuilder {
        public Optional<Matchable> create(JsonElement element) {
            return ElementParser.fromIdentifiedElement((JsonElement)element, (String)ID).map(jsonObject -> new BowPullPredicate(jsonObject.get("pull").getAsFloat()));
        }
    }
}

