/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.generator.api.operation;

import java.util.Optional;
import java.util.function.Function;

@FunctionalInterface
public interface VariableOperation {
    public static <T> String convert(Object variable, Class<T> type, Function<T, String> operation) {
        return VariableOperation.convert(variable, type).map(operation).orElseThrow(() -> new IllegalArgumentException("Variable provider does not supply a " + type.getName()));
    }

    public static <T> Optional<T> convert(Object variable, Class<T> type) {
        if (variable.getClass().isAssignableFrom(type)) {
            return Optional.of(type.cast(variable));
        }
        return Optional.empty();
    }

    public static <T> VariableOperation operation(Class<T> type, Function<T, String> operation) {
        return variableProvider -> VariableOperation.convert(variableProvider, type, operation);
    }

    public String apply(Object var1);
}

