/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.generator.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.generator.impl.IdentifiedJson;
import com.sigmundgranaas.forgero.generator.impl.ResourceManagerJsonLoader;
import com.sigmundgranaas.forgero.generator.impl.StringReplacer;
import com.sigmundgranaas.forgero.generator.impl.VariableToMapTransformer;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class DataDirectoryRecipeGenerator {
    private final StringReplacer replacer;
    private final VariableToMapTransformer transformer;
    private final String directory;
    private final ResourceManagerJsonLoader loader;

    public DataDirectoryRecipeGenerator(StringReplacer replacer, VariableToMapTransformer transformer, String directory, ResourceManagerJsonLoader loader) {
        this.replacer = replacer;
        this.transformer = transformer;
        this.directory = directory;
        this.loader = loader;
    }

    public Collection<IdentifiedJson> generate() {
        return this.loader.load(this.directory).stream().flatMap(this::convertToIdentifiedJson).filter(this::validateRecipe).collect(Collectors.toList());
    }

    private boolean validateRecipe(IdentifiedJson identifiedJson) {
        JsonObject result;
        if (identifiedJson.json().has("result") && (result = identifiedJson.json().getAsJsonObject("result")).has("item")) {
            class_2960 item = new class_2960(result.get("item").getAsString());
            return class_7923.field_41178.method_10250(item);
        }
        return false;
    }

    private Stream<IdentifiedJson> convertToIdentifiedJson(JsonObject object) {
        return this.transformer.transformStateMap(object.getAsJsonObject("variables")).stream().map(variables -> this.createRecipe(this.copy(object), (Map<String, Object>)variables));
    }

    private IdentifiedJson createRecipe(JsonObject template, Map<String, Object> variableMap) {
        class_2960 id = new class_2960(this.replacer.applyReplacements(template.get("identifier").getAsString(), variableMap));
        template.remove("identifier");
        template.remove("generator_type");
        template.remove("variables");
        template = (JsonObject)new Gson().fromJson(this.replacer.applyReplacements(template.toString(), variableMap), JsonObject.class);
        return new IdentifiedJson(id, template);
    }

    private JsonObject copy(JsonObject object) {
        return (JsonObject)new Gson().fromJson(object.toString(), JsonObject.class);
    }
}

