/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.generator.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.Forgero;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class ResourceManagerJsonLoader {
    private final class_3300 resourceManager;

    public ResourceManagerJsonLoader(class_3300 resourceManager) {
        this.resourceManager = resourceManager;
    }

    private Collection<class_3298> loadJsonData(String path) {
        return this.resourceManager.method_14488(path, p -> p.method_12832().endsWith(".json")).values();
    }

    private Stream<JsonElement> streamElements(String path) {
        return this.loadJsonData(path).stream().map(this::tryParse).flatMap(Optional::stream);
    }

    public Collection<JsonObject> load(String path) {
        return this.streamElements(path).filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).collect(Collectors.toList());
    }

    private Optional<JsonElement> tryParse(class_3298 resource) {
        try {
            JsonElement element = (JsonElement)new Gson().fromJson(new String(resource.method_14482().readAllBytes()), JsonElement.class);
            return Optional.of(element);
        }
        catch (Exception e) {
            Forgero.LOGGER.error((Object)e);
            return Optional.empty();
        }
    }
}

