/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.generator.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class VariableToMapTransformer {
    private final Function<JsonElement, Collection<?>> converter;

    public VariableToMapTransformer(Function<JsonElement, Collection<?>> converter) {
        this.converter = converter;
    }

    public Collection<Map<String, Object>> transformStateMap(JsonObject stateMapJson) {
        HashMap variables = new HashMap();
        for (String key : stateMapJson.keySet()) {
            Collection<?> entry = this.converter.apply(stateMapJson.get(key));
            variables.put(key, entry);
        }
        return this.generateCombinations(variables);
    }

    private List<Map<String, Object>> generateCombinations(Map<String, Collection<?>> stateOptions) {
        ArrayList<Map<String, Object>> combinations = new ArrayList<Map<String, Object>>();
        this.generateCombinationsRecursive(combinations, new HashMap<String, Object>(), new ArrayList<String>(stateOptions.keySet()), 0, stateOptions);
        return combinations;
    }

    private void generateCombinationsRecursive(List<Map<String, Object>> combinations, Map<String, Object> current, List<String> keys, int depth, Map<String, Collection<?>> stateOptions) {
        if (depth == keys.size()) {
            combinations.add(new HashMap<String, Object>(current));
            return;
        }
        String key = keys.get(depth);
        for (Object state : stateOptions.get(key)) {
            current.put(key, state);
            this.generateCombinationsRecursive(combinations, current, keys, depth + 1, stateOptions);
        }
    }
}

