/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.generator.impl.converter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.registry.RankableConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class TagToItemConverter
implements RankableConverter<JsonElement, Collection<?>> {
    public Collection<class_1792> convert(JsonElement entry) {
        List<Object> items;
        JsonObject jsonObject = entry.getAsJsonObject();
        JsonElement tagElement = jsonObject.get("tag");
        if (tagElement.isJsonArray()) {
            items = StreamSupport.stream(tagElement.getAsJsonArray().spliterator(), false).flatMap(tag -> this.fromTag(tag.getAsString()).stream()).distinct().collect(Collectors.toList());
        } else {
            String type = tagElement.getAsString();
            items = new ArrayList<class_1792>(this.fromTag(type));
        }
        if (jsonObject.has("filter")) {
            Set<String> exclusions = this.parseFilter(jsonObject.getAsJsonArray("filter"));
            items.removeIf(item -> exclusions.contains(class_7923.field_41178.method_10221(item).toString()));
        }
        return items;
    }

    private Collection<class_1792> fromTag(String tag) {
        class_6862 tagKey = class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)new class_2960(tag));
        return StreamSupport.stream(class_7923.field_41178.method_40286(tagKey).spliterator(), false).map(class_6880::comp_349).collect(Collectors.toList());
    }

    private Set<String> parseFilter(JsonArray filterArray) {
        return StreamSupport.stream(filterArray.spliterator(), false).map(JsonElement::getAsString).collect(Collectors.toSet());
    }

    public boolean matches(JsonElement entry) {
        if (entry.isJsonObject()) {
            JsonObject jsonObject = entry.getAsJsonObject();
            return jsonObject.has("tag");
        }
        return false;
    }
}

