/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.generator.impl.converter.forgero;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.registry.RankableConverter;
import com.sigmundgranaas.forgero.core.state.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ForgeroTypeVariableConverter
implements RankableConverter<JsonElement, Collection<?>> {
    private final Function<String, List<State>> stateProvider;

    public ForgeroTypeVariableConverter(Function<String, List<State>> stateProvider) {
        this.stateProvider = stateProvider;
    }

    public Collection<State> convert(JsonElement entry) {
        ArrayList<State> states;
        JsonObject jsonObject = entry.getAsJsonObject();
        JsonElement typeElement = jsonObject.get("type");
        if (typeElement.isJsonArray()) {
            states = StreamSupport.stream(typeElement.getAsJsonArray().spliterator(), false).flatMap(type -> this.stateProvider.apply(type.getAsString()).stream()).distinct().collect(Collectors.toList());
        } else {
            String type2 = typeElement.getAsString();
            states = new ArrayList(this.stateProvider.apply(type2));
        }
        if (jsonObject.has("filter")) {
            Set<String> exclusions = this.parseFilter(jsonObject.getAsJsonArray("filter"));
            states.removeIf(state -> exclusions.contains(state.identifier()));
        }
        return states;
    }

    private Set<String> parseFilter(JsonArray filterArray) {
        return StreamSupport.stream(filterArray.spliterator(), false).map(JsonElement::getAsString).collect(Collectors.toSet());
    }

    public boolean matches(JsonElement entry) {
        if (entry.isJsonObject()) {
            JsonObject jsonObject = entry.getAsJsonObject();
            return jsonObject.has("type");
        }
        return false;
    }
}

