/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.defaults.cit.conditions;

import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2512;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import shcm.shsupercm.fabric.citresewn.api.CITConditionContainer;
import shcm.shsupercm.fabric.citresewn.cit.CITCondition;
import shcm.shsupercm.fabric.citresewn.cit.CITContext;
import shcm.shsupercm.fabric.citresewn.cit.CITParsingException;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyGroup;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public class ConditionNBT
extends CITCondition {
    public static final CITConditionContainer<ConditionNBT> CONTAINER = new CITConditionContainer(ConditionNBT.class, ConditionNBT::new, new String[]{"nbt"});
    protected String[] path;
    protected StringMatcher matchString = null;
    protected class_2497 matchInteger = null;
    protected class_2481 matchByte = null;
    protected class_2494 matchFloat = null;
    protected class_2489 matchDouble = null;
    protected class_2503 matchLong = null;
    protected class_2516 matchShort = null;
    protected class_2487 matchCompound = null;

    public void load(PropertyValue value, PropertyGroup properties) throws CITParsingException {
        if (value.keyMetadata() == null || value.keyMetadata().isEmpty()) {
            throw new CITParsingException("Missing nbt path", properties, value.position());
        }
        for (String s : this.path = value.keyMetadata().split("\\.")) {
            if (!s.isEmpty()) continue;
            throw new CITParsingException("Path segment cannot be empty", properties, value.position());
        }
        try {
            this.matchString = value.value().startsWith("regex:") ? new StringMatcher.RegexMatcher(value.value().substring(6)) : (value.value().startsWith("iregex:") ? new StringMatcher.IRegexMatcher(value.value().substring(7)) : (value.value().startsWith("pattern:") ? new StringMatcher.PatternMatcher(value.value().substring(8)) : (value.value().startsWith("ipattern:") ? new StringMatcher.IPatternMatcher(value.value().substring(9)) : new StringMatcher.DirectMatcher(value.value()))));
        }
        catch (PatternSyntaxException e) {
            throw new CITParsingException("Malformatted regex expression", properties, value.position(), (Throwable)e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchInteger = value.value().startsWith("#") ? class_2497.method_23247((int)Integer.parseInt(value.value().substring(1).toLowerCase(Locale.ENGLISH), 16)) : (value.value().startsWith("0x") ? class_2497.method_23247((int)Integer.parseInt(value.value().substring(2).toLowerCase(Locale.ENGLISH), 16)) : class_2497.method_23247((int)Integer.parseInt(value.value())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchByte = class_2481.method_23233((byte)Byte.parseByte(value.value()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchFloat = class_2494.method_23244((float)Float.parseFloat(value.value()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchDouble = class_2489.method_23241((double)Double.parseDouble(value.value()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchLong = class_2503.method_23251((long)Long.parseLong(value.value()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchShort = class_2516.method_23254((short)Short.parseShort(value.value()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchCompound = class_2522.method_10718((String)value.value());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean test(CITContext context) {
        return this.testPath((class_2520)context.stack.method_7969(), 0);
    }

    protected boolean testPath(class_2520 element, int pathIndex) {
        if (element == null) {
            return false;
        }
        if (pathIndex >= this.path.length) {
            return this.testValue(element);
        }
        String path = this.path[pathIndex];
        if (path.equals("*")) {
            if (element instanceof class_2487) {
                class_2487 compound = (class_2487)element;
                for (class_2520 subElement : compound.field_11515.values()) {
                    if (!this.testPath(subElement, pathIndex + 1)) continue;
                    return true;
                }
            } else if (element instanceof class_2499) {
                class_2499 list = (class_2499)element;
                for (class_2520 subElement : list) {
                    if (!this.testPath(subElement, pathIndex + 1)) continue;
                    return true;
                }
            }
        } else {
            if (element instanceof class_2487) {
                class_2487 compound = (class_2487)element;
                return this.testPath(compound.method_10580(path), pathIndex + 1);
            }
            if (element instanceof class_2499) {
                class_2499 list = (class_2499)element;
                if (path.equals("count")) {
                    return this.testValue((class_2520)class_2497.method_23247((int)list.size()));
                }
                try {
                    return this.testPath(list.method_10534(Integer.parseInt(path)), pathIndex + 1);
                }
                catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private boolean testValue(class_2520 element) {
        try {
            if (element instanceof class_2519) {
                class_2519 nbtString = (class_2519)element;
                String elementString = nbtString.method_10714();
                if (this.matchString.matches(elementString)) {
                    return true;
                }
                for (int i = 0; i < elementString.length(); ++i) {
                    char ch = elementString.charAt(i);
                    if (Character.isWhitespace(ch)) continue;
                    return (ch == '[' || ch == '{' || ch == '\"') && this.matchString.matches(class_2561.class_2562.method_10877((String)elementString).getString());
                }
            } else {
                if (element instanceof class_2497) {
                    class_2497 nbtInt = (class_2497)element;
                    if (this.matchInteger != null) {
                        return nbtInt.equals((Object)this.matchInteger);
                    }
                }
                if (element instanceof class_2481) {
                    class_2481 nbtByte = (class_2481)element;
                    if (this.matchByte != null) {
                        return nbtByte.equals((Object)this.matchByte);
                    }
                }
                if (element instanceof class_2494) {
                    class_2494 nbtFloat = (class_2494)element;
                    if (this.matchFloat != null) {
                        return nbtFloat.equals((Object)this.matchFloat);
                    }
                }
                if (element instanceof class_2489) {
                    class_2489 nbtDouble = (class_2489)element;
                    if (this.matchDouble != null) {
                        return nbtDouble.equals((Object)this.matchDouble);
                    }
                }
                if (element instanceof class_2503) {
                    class_2503 nbtLong = (class_2503)element;
                    if (this.matchLong != null) {
                        return nbtLong.equals((Object)this.matchLong);
                    }
                }
                if (element instanceof class_2516) {
                    class_2516 nbtShort = (class_2516)element;
                    if (this.matchShort != null) {
                        return nbtShort.equals((Object)this.matchShort);
                    }
                }
                if (element instanceof class_2487) {
                    class_2487 nbtCompound = (class_2487)element;
                    if (this.matchCompound != null) {
                        return class_2512.method_10687((class_2520)this.matchCompound, (class_2520)nbtCompound, (boolean)true);
                    }
                }
            }
            if (element instanceof class_2514) {
                class_2514 nbtNumber = (class_2514)element;
                if (!(this.matchString instanceof StringMatcher.DirectMatcher)) {
                    return this.matchString.matches(String.valueOf(nbtNumber.method_10702()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected static abstract class StringMatcher {
        protected StringMatcher() {
        }

        public abstract boolean matches(String var1);

        public static class IPatternMatcher
        extends PatternMatcher {
            public IPatternMatcher(String pattern) {
                super(pattern.toLowerCase(Locale.ROOT));
            }

            @Override
            protected boolean charsEqual(char p, char v) {
                return p == v || p == Character.toLowerCase(v);
            }
        }

        public static class IRegexMatcher
        extends RegexMatcher {
            public IRegexMatcher(String pattern) {
                super(Pattern.compile(pattern, 66));
            }
        }

        public static class PatternMatcher
        extends StringMatcher {
            protected final String pattern;

            public PatternMatcher(String pattern) {
                this.pattern = pattern;
            }

            @Override
            public boolean matches(String value) {
                return this.matchesPattern(value, this.pattern, 0, value.length(), 0, this.pattern.length());
            }

            protected boolean matchesPattern(String value, String pattern, int curV, int maxV, int curG, int maxG) {
                while (curG < maxG) {
                    char g = pattern.charAt(curG);
                    if (g == '*') {
                        while (true) {
                            if (this.matchesPattern(value, pattern, curV, maxV, curG + 1, maxG)) {
                                return true;
                            }
                            if (curV >= maxV) break;
                            ++curV;
                        }
                        return false;
                    }
                    if (curV >= maxV) break;
                    if (g != '?') {
                        if (g == '\\' && curG + 1 < maxG) {
                            g = pattern.charAt(++curG);
                        }
                        if (!this.charsEqual(g, value.charAt(curV))) {
                            return false;
                        }
                    }
                    ++curG;
                    ++curV;
                }
                return curG == maxG && curV == maxV;
            }

            protected boolean charsEqual(char p, char v) {
                return p == v;
            }
        }

        public static class RegexMatcher
        extends StringMatcher {
            protected final Pattern pattern;

            public RegexMatcher(String pattern) {
                this(Pattern.compile(pattern));
            }

            protected RegexMatcher(Pattern pattern) {
                this.pattern = pattern;
            }

            @Override
            public boolean matches(String value) {
                return this.pattern.matcher(value).matches();
            }
        }

        public static class DirectMatcher
        extends StringMatcher {
            protected final String pattern;

            public DirectMatcher(String pattern) {
                this.pattern = pattern;
            }

            @Override
            public boolean matches(String value) {
                return this.pattern.equals(value);
            }
        }
    }
}

