/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.com.unascribed.qdcss.QDCSS;
import dev.emi.emi.config.ConfigEnum;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.IntGroup;
import dev.emi.emi.config.ScreenAlign;
import dev.emi.emi.config.SidebarPages;
import dev.emi.emi.config.SidebarSubpanels;
import dev.emi.emi.input.EmiBind;
import dev.emi.emi.input.EmiInput;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.ConfigPresetScreen;
import dev.emi.emi.screen.widget.SizedButtonWidget;
import dev.emi.emi.screen.widget.config.BooleanWidget;
import dev.emi.emi.screen.widget.config.ConfigEntryWidget;
import dev.emi.emi.screen.widget.config.ConfigJumpButton;
import dev.emi.emi.screen.widget.config.ConfigSearch;
import dev.emi.emi.screen.widget.config.EmiBindWidget;
import dev.emi.emi.screen.widget.config.EmiNameWidget;
import dev.emi.emi.screen.widget.config.EnumWidget;
import dev.emi.emi.screen.widget.config.GroupNameWidget;
import dev.emi.emi.screen.widget.config.IntGroupWidget;
import dev.emi.emi.screen.widget.config.IntWidget;
import dev.emi.emi.screen.widget.config.ListWidget;
import dev.emi.emi.screen.widget.config.ScreenAlignWidget;
import dev.emi.emi.screen.widget.config.SidebarPagesWidget;
import dev.emi.emi.screen.widget.config.SidebarSubpanelsWidget;
import dev.emi.emi.screen.widget.config.SubGroupNameWidget;
import dev.emi.emi.search.EmiSearch;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;

public class ConfigScreen
extends class_437 {
    private static final int maxWidth = 240;
    private class_437 last;
    private ConfigSearch search;
    public ListWidget list;
    public EmiBind activeBind;
    public int activeBindOffset;
    public int activeModifiers;
    public int lastModifier;
    public String originalConfig;
    public class_4185 resetButton;

    public ConfigScreen(class_437 last) {
        super((class_2561)EmiPort.translatable("screen.emi.config"));
        this.last = last;
        this.originalConfig = EmiConfig.getSavedConfig();
    }

    public void setActiveBind(EmiBind bind, int offset) {
        this.activeBind = bind;
        this.activeBindOffset = offset;
        this.activeModifiers = 0;
        this.lastModifier = 0;
    }

    public void method_25419() {
        EmiConfig.writeConfig();
        EmiSearch.update();
        class_310.method_1551().method_1507(this.last);
    }

    public static List<class_5684> getFieldTooltip(Field field) {
        EmiConfig.ConfigValue annot = field.getAnnotation(EmiConfig.ConfigValue.class);
        String key = "config.emi.tooltip." + annot.value().replace('-', '_');
        EmiConfig.Comment comment = field.getAnnotation(EmiConfig.Comment.class);
        List<class_5684> text = class_1074.method_4663((String)key) ? Arrays.stream(class_1074.method_4662((String)key, (Object[])new Object[0]).split("\n")).map(EmiPort::literal).map(EmiTooltipComponents::of).toList() : (comment != null ? Arrays.stream(comment.value().split("\n")).map(EmiPort::literal).map(EmiTooltipComponents::of).toList() : null);
        if (text == null) {
            return List.of();
        }
        return text;
    }

    protected void method_25426() {
        super.method_25426();
        int scroll = 0;
        String query = "";
        HashSet collapsed = Sets.newHashSet();
        if (this.list != null) {
            scroll = (int)this.list.getScrollAmount();
            query = this.search.getSearch();
            for (ListWidget.Entry e : this.list.method_25396()) {
                if (!(e instanceof GroupNameWidget)) continue;
                GroupNameWidget g = (GroupNameWidget)e;
                if (!g.collapsed) continue;
                collapsed.add(g.text.getString());
            }
        }
        this.list = new ListWidget(this.field_22787, this.field_22789, this.field_22790, 40, this.field_22790 - 60);
        this.method_37060(new EmiNameWidget(this.field_22789 / 2, 16));
        int w = Math.min(400, this.field_22789 - 40) / 4 * 4;
        int x = (this.field_22789 - w) / 2;
        this.search = new ConfigSearch(x + 3, this.field_22790 - 51, w / 2 - 4, 18);
        this.method_37060((class_4068)this.search.field);
        this.resetButton = EmiPort.newButton(x + 2, this.field_22790 - 30, w / 2 - 2, 20, (class_2561)EmiPort.translatable("gui.done"), button -> {
            EmiConfig.loadConfig(QDCSS.load("revert", this.originalConfig));
            class_310 client = class_310.method_1551();
            this.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
        });
        this.method_37063((class_364)EmiPort.newButton(x + w / 2 + 2, this.field_22790 - 30, w / 2 - 2, 20, (class_2561)EmiPort.translatable("gui.done"), button -> this.method_25419()));
        this.method_37063((class_364)EmiPort.newButton(x + w / 2 + 2, this.field_22790 - 52, w / 2 - 24, 20, (class_2561)EmiPort.translatable("screen.emi.presets"), button -> {
            class_310 client = class_310.method_1551();
            client.method_1507((class_437)new ConfigPresetScreen(this));
        }));
        this.method_37063((class_364)new SizedButtonWidget(x + w - 20, this.field_22790 - 52, 20, 20, 164, 0, () -> true, widget -> {
            EmiConfig.setGlobalState(!EmiConfig.useGlobalConfig);
            this.method_25410(this.field_22787, this.field_22789, this.field_22790);
        }, () -> EmiConfig.useGlobalConfig ? 40 : 0, () -> Arrays.stream(class_1074.method_4662((String)"tooltip.emi.config.global", (Object[])new Object[0]).split("\n")).map(s -> this.field_22787.field_1772.method_27527().method_27495(class_5348.method_29430((String)s), 240, class_2583.field_24360)).flatMap(l -> l.stream()).map(v -> EmiPort.literal(v.getString())).toList()));
        this.method_37063((class_364)this.resetButton);
        this.method_25429((class_364)this.search.field);
        try {
            String lastGroup = "";
            GroupNameWidget lastGroupWidget = null;
            EmiConfig.ConfigGroup currentGroup = null;
            SubGroupNameWidget currentSubGroupWidget = null;
            Supplier<String> searchSupplier = () -> this.search.getSearch();
            for (final Field field : EmiConfig.class.getFields()) {
                boolean endGroup;
                EmiConfig.ConfigGroup configGroup;
                String group;
                EmiConfig.ConfigValue annot = field.getAnnotation(EmiConfig.ConfigValue.class);
                if (annot == null || (group = annot.value().split("\\.")[0]).equals("persistent")) continue;
                if (!group.equals(lastGroup)) {
                    lastGroup = group;
                    class_5250 text = EmiPort.translatable("config.emi.group." + group.replace('-', '_'));
                    lastGroupWidget = new GroupNameWidget(group, (class_2561)text);
                    if (collapsed.contains(text.getString())) {
                        lastGroupWidget.collapsed = true;
                    }
                    this.list.addEntry(lastGroupWidget);
                }
                if ((configGroup = field.getAnnotation(EmiConfig.ConfigGroup.class)) != null) {
                    currentGroup = configGroup;
                    class_5250 text = EmiPort.translatable("config.emi.group." + configGroup.value().replace('-', '_'));
                    currentSubGroupWidget = new SubGroupNameWidget(configGroup.value(), (class_2561)text);
                    if (collapsed.contains(text.getString())) {
                        currentSubGroupWidget.collapsed = true;
                    }
                    currentSubGroupWidget.parent = lastGroupWidget;
                    this.list.addEntry(currentSubGroupWidget);
                }
                Predicate<Object> predicate = EmiConfig.FILTERS.getOrDefault(annot.value(), v -> true);
                class_5250 translation = EmiPort.translatable("config.emi." + annot.value().replace('-', '_'));
                ConfigEntryWidget entry = null;
                if (field.getType() == Boolean.TYPE) {
                    entry = new BooleanWidget((class_2561)translation, ConfigScreen.getFieldTooltip(field), searchSupplier, new Mutator<Boolean>(){

                        @Override
                        public Boolean getValue() {
                            try {
                                return field.getBoolean(null);
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }

                        @Override
                        public void setValue(Boolean value) {
                            try {
                                field.setBoolean(null, value);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                } else if (field.getType() == Integer.TYPE) {
                    entry = new IntWidget((class_2561)translation, ConfigScreen.getFieldTooltip(field), searchSupplier, new Mutator<Integer>(){

                        @Override
                        public Integer getValue() {
                            try {
                                return field.getInt(null);
                            }
                            catch (Exception exception) {
                                return -1;
                            }
                        }

                        @Override
                        public void setValue(Integer value) {
                            try {
                                field.setInt(null, value);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                } else if (field.getType() == EmiBind.class) {
                    entry = new EmiBindWidget(this, ConfigScreen.getFieldTooltip(field), searchSupplier, (EmiBind)field.get(null));
                } else if (field.getType() == ScreenAlign.class) {
                    entry = new ScreenAlignWidget((class_2561)translation, ConfigScreen.getFieldTooltip(field), searchSupplier, this.objectMutator(field));
                } else if (field.getType() == SidebarPages.class) {
                    entry = new SidebarPagesWidget((class_2561)translation, ConfigScreen.getFieldTooltip(field), searchSupplier, this.objectMutator(field));
                } else if (field.getType() == SidebarSubpanels.class) {
                    entry = new SidebarSubpanelsWidget((class_2561)translation, ConfigScreen.getFieldTooltip(field), searchSupplier, this.objectMutator(field));
                } else if (IntGroup.class.isAssignableFrom(field.getType())) {
                    entry = new IntGroupWidget((class_2561)translation, ConfigScreen.getFieldTooltip(field), searchSupplier, this.objectMutator(field));
                } else if (ConfigEnum.class.isAssignableFrom(field.getType())) {
                    entry = new EnumWidget((class_2561)translation, ConfigScreen.getFieldTooltip(field), searchSupplier, this.objectMutator(field), predicate);
                }
                boolean bl = endGroup = field.getAnnotation(EmiConfig.ConfigGroupEnd.class) != null;
                if (entry != null) {
                    entry.group = currentGroup;
                    entry.endGroup = endGroup;
                    this.list.addEntry(entry);
                    if (lastGroupWidget != null) {
                        lastGroupWidget.children.add(entry);
                        entry.parentGroups.add(lastGroupWidget);
                    }
                    if (currentSubGroupWidget != null) {
                        currentSubGroupWidget.children.add(entry);
                        entry.parentGroups.add(currentSubGroupWidget);
                    }
                }
                if (!endGroup) continue;
                currentGroup = null;
                currentSubGroupWidget = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.method_25429((class_364)this.list);
        this.list.setScrollAmount(scroll);
        this.search.setText(query);
        this.addJumpButtons();
        this.updateChanges();
    }

    private void addJumpButtons() {
        ArrayList jumps = Lists.newArrayList((Object[])new String[]{"general", "general.search", "ui", "ui.left-sidebar", "ui.right-sidebar", "ui.top-sidebar", "ui.bottom-sidebar", "binds", "binds.crafts", "binds.cheats", "dev"});
        List<List<String>> removes = List.of(List.of("binds.cheats"), List.of("general.search"), List.of("ui.top-sidebar", "ui.bottom-sidebar"), List.of("binds.crafts"), List.of("ui.left-sidebar", "ui.right-sidebar"));
        int space = this.list.getLogicalHeight() - 10;
        for (List<String> r : removes) {
            if (jumps.size() * 16 <= space) continue;
            jumps.removeAll(r);
        }
        int y = 40 + (this.list.getLogicalHeight() - jumps.size() * 16) / 2;
        int u = 0;
        int v = -16;
        for (String s : jumps) {
            boolean newGroup;
            boolean bl = newGroup = !s.contains(".");
            if (newGroup) {
                v += 16;
                u = 0;
            } else {
                u += 16;
            }
            this.method_37063((class_364)new ConfigJumpButton(2 + (newGroup ? 0 : 8), y, u, v, w -> this.jump(s), List.of(EmiPort.translatable("config.emi.group." + s.replace('-', '_')))));
            y += 16;
        }
    }

    public void jump(String jump) {
        for (ListWidget.Entry e : this.list.method_25396()) {
            if (!(e instanceof ConfigEntryWidget)) continue;
            ConfigEntryWidget c = (ConfigEntryWidget)e;
            for (GroupNameWidget p : c.parentGroups) {
                if (!p.id.equals(jump)) continue;
                this.list.centerScrollOn(e);
                return;
            }
        }
    }

    public <T> Mutator<T> objectMutator(final Field field) {
        return new Mutator<T>(){

            @Override
            public T getValue() {
                try {
                    return field.get(null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void setValue(T en) {
                try {
                    field.set(null, en);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void updateChanges() {
        String[] oLines = this.originalConfig.split("\n\n");
        String[] cLines = EmiConfig.getSavedConfig().split("\n\n");
        int different = 0;
        for (int i = 0; i < oLines.length && i < cLines.length; ++i) {
            if (oLines[i].equals(cLines[i])) continue;
            ++different;
        }
        this.resetButton.field_22763 = different > 0;
        this.resetButton.method_25355((class_2561)EmiPort.translatable("screen.emi.config.reset", different));
    }

    public void method_25394(class_332 raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        this.list.setScrollAmount(this.list.getScrollAmount());
        this.method_25434(context.raw());
        this.list.method_25394(context.raw(), mouseX, mouseY, delta);
        super.method_25394(context.raw(), mouseX, mouseY, delta);
        if (this.list.getHoveredEntry() != null) {
            EmiRenderHelper.drawTooltip(this, context, this.list.getHoveredEntry().getTooltip(mouseX, mouseY), mouseX, mouseY, Math.min(this.field_22789 / 2 - 16, 240));
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.activeBind != null) {
            this.pushModifier(0);
            this.activeBind.setBind(this.activeBindOffset, new EmiBind.ModifiedKey(class_3675.class_307.field_1672.method_1447(button), this.activeModifiers));
            this.activeBind = null;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void pushModifier(int lastModifier) {
        this.activeModifiers |= EmiInput.maskFromCode(this.lastModifier);
        this.lastModifier = lastModifier;
        this.activeModifiers &= ~EmiInput.maskFromCode(lastModifier);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_342 tfw;
        if (this.activeBind != null) {
            if (EmiInput.maskFromCode(keyCode) != 0) {
                this.pushModifier(keyCode);
            } else {
                this.pushModifier(0);
                if (keyCode == 256) {
                    this.activeBind.setBind(this.activeBindOffset, new EmiBind.ModifiedKey(class_3675.field_16237, 0));
                } else {
                    this.activeBind.setBind(this.activeBindOffset, new EmiBind.ModifiedKey(class_3675.class_307.field_1668.method_1447(keyCode), this.activeModifiers));
                }
                this.activeBind = null;
                this.updateChanges();
            }
            return true;
        }
        if (keyCode == 258) {
            return false;
        }
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        class_364 class_3642 = this.method_25399();
        if (class_3642 instanceof class_342 && (tfw = (class_342)class_3642).method_25370()) {
            if (keyCode == 256) {
                EmiPort.focus(tfw, false);
                return true;
            }
        } else {
            if (keyCode == 256) {
                this.method_25419();
                return true;
            }
            if (this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
                this.method_25419();
                return true;
            }
        }
        return false;
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.activeBind != null) {
            this.activeModifiers &= ~EmiInput.maskFromCode(keyCode);
            if (keyCode == this.lastModifier) {
                this.activeBind.setBind(this.activeBindOffset, new EmiBind.ModifiedKey(class_3675.class_307.field_1668.method_1447(keyCode), this.activeModifiers));
                this.activeBind = null;
            }
            return true;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25422() {
        return false;
    }

    public abstract class Mutator<T> {
        protected abstract T getValue();

        protected abstract void setValue(T var1);

        public T get() {
            return this.getValue();
        }

        public void set(T value) {
            this.setValue(value);
            ConfigScreen.this.updateChanges();
        }
    }
}

