/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.fabric.tag;

import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.fabric.resources.ARRPGenerator;
import java.util.Optional;
import net.devtech.arrp.json.tags.JTag;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_2960;

public class BlockTagCompatRegistration {
    public static final String MINECRAFT_NAMESPACE = "minecraft";
    public static final String COMMON_NAMESPACE = "c";
    public static final String BIOMES_YOULL_GO_NAMESPACE = "byg";
    public static final String REGIONS_UNEXPLORED_NAMESPACE = "regions-unexplored";
    public static final String CHERRY_PLANKS = "cherry_planks";
    public static final String BAMBOO_PLANKS = "bamboo_planks";

    public static void register() {
        BlockTagCompatRegistration.registerCherryPlanksTag();
        BlockTagCompatRegistration.registerBambooPlanksTag();
    }

    private static int checkIfMinecraftVersionIsEqualOrNewer(String version) {
        Optional minecraftModContainer = FabricLoader.getInstance().getModContainer(MINECRAFT_NAMESPACE);
        if (minecraftModContainer.isEmpty()) {
            Forgero.LOGGER.error("Couldn't parse Minecraft version (Minecraft mod container is empty).");
            return -1;
        }
        Version minecraftVersion = ((ModContainer)minecraftModContainer.get()).getMetadata().getVersion();
        try {
            return minecraftVersion.compareTo((Object)SemanticVersion.parse((String)version));
        }
        catch (VersionParsingException e) {
            Forgero.LOGGER.error("Couldn't parse Minecraft version: {}. See stacktrace below:\n{}", (Object)minecraftVersion, (Object)e);
            return -1;
        }
    }

    private static void registerCherryPlanksTag() {
        JTag cherryPlanksTag = new JTag();
        if (BlockTagCompatRegistration.checkIfMinecraftVersionIsEqualOrNewer("1.20") >= 0) {
            cherryPlanksTag.add(new class_2960(MINECRAFT_NAMESPACE, CHERRY_PLANKS));
        }
        if (FabricLoader.getInstance().isModLoaded(BIOMES_YOULL_GO_NAMESPACE)) {
            cherryPlanksTag.add(new class_2960(BIOMES_YOULL_GO_NAMESPACE, CHERRY_PLANKS));
        }
        if (FabricLoader.getInstance().isModLoaded(REGIONS_UNEXPLORED_NAMESPACE)) {
            cherryPlanksTag.add(new class_2960(REGIONS_UNEXPLORED_NAMESPACE, CHERRY_PLANKS));
        }
        ARRPGenerator.RESOURCE_PACK.addTag(new class_2960(COMMON_NAMESPACE, CHERRY_PLANKS), cherryPlanksTag);
    }

    private static void registerBambooPlanksTag() {
        JTag bambooPlanksTag = new JTag();
        if (BlockTagCompatRegistration.checkIfMinecraftVersionIsEqualOrNewer("1.20") >= 0) {
            bambooPlanksTag.add(new class_2960(MINECRAFT_NAMESPACE, BAMBOO_PLANKS));
        }
        ARRPGenerator.RESOURCE_PACK.addTag(new class_2960(COMMON_NAMESPACE, CHERRY_PLANKS), bambooPlanksTag);
    }
}

