/*
 * Decompiled with CFR 0.152.
 */
package net.lostluma.battery.impl;

import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import net.lostluma.battery.api.Battery;
import net.lostluma.battery.api.State;
import net.lostluma.battery.api.Technology;
import net.lostluma.battery.impl.ManagerImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BatteryImpl
implements Battery {
    final long ptr;
    private final ManagerImpl manager;
    private final Technology technology;
    @Nullable
    private final String vendor;
    @Nullable
    private final String model;
    @Nullable
    private final String serialNumber;
    private float stateOfCharge;
    private float energy;
    private float energyFull;
    private float energyFullDesign;
    private float energyRate;
    private float voltage;
    private float stateOfHealth;
    private State state;
    private float temperature = Float.NaN;
    private long cycleCount = Long.MIN_VALUE;
    @Nullable
    private Duration timeToFull;
    @Nullable
    private Duration timeToEmpty;

    private BatteryImpl(long ptr, ManagerImpl manager, Technology technology, @Nullable String vendor, @Nullable String model, @Nullable String serialNumber) {
        this.ptr = ptr;
        this.manager = manager;
        this.technology = technology;
        this.vendor = vendor;
        this.model = model;
        this.serialNumber = serialNumber;
    }

    @Override
    public void update() throws IOException, RuntimeException {
        if (!this.manager.isActive()) {
            throw new RuntimeException("Attached manager is closed.");
        }
        this.update0();
    }

    private native void update0() throws IOException;

    private void update0(float stateOfCharge, float energy, float energyFull, float energyRate, float energyFullDesign, float voltage, float stateOfHealth, State state, float temperature, long cycleCount, float timeToFull, float timeToEmpty) {
        this.stateOfCharge = stateOfCharge;
        this.energy = energy;
        this.energyFull = energyFull;
        this.energyRate = energyRate;
        this.energyFullDesign = energyFullDesign;
        this.voltage = voltage;
        this.stateOfHealth = stateOfHealth;
        this.state = state;
        this.temperature = temperature;
        this.cycleCount = cycleCount;
        this.timeToFull = Float.isNaN(timeToFull) ? null : Duration.of((long)timeToFull, ChronoUnit.SECONDS);
        this.timeToEmpty = Float.isNaN(timeToEmpty) ? null : Duration.of((long)timeToEmpty, ChronoUnit.SECONDS);
    }

    @Override
    public float stateOfCharge() {
        return this.stateOfCharge;
    }

    @Override
    public float energy() {
        return this.energy;
    }

    @Override
    public float energyFull() {
        return this.energyFull;
    }

    @Override
    public float energyFullDesign() {
        return this.energyFullDesign;
    }

    @Override
    public float energyRate() {
        return this.energyRate;
    }

    @Override
    public float voltage() {
        return this.voltage;
    }

    @Override
    public float stateOfHealth() {
        return this.stateOfHealth;
    }

    @Override
    @NotNull
    public State state() {
        return this.state;
    }

    @Override
    @NotNull
    public Technology technology() {
        return this.technology;
    }

    @Override
    @NotNull
    public Optional<Float> temperature() {
        float value = this.temperature;
        if (Float.isNaN(value)) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(value));
    }

    @Override
    @NotNull
    public OptionalLong cycleCount() {
        long value = this.cycleCount;
        if (value == Integer.MIN_VALUE) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(value);
    }

    @Override
    @NotNull
    public Optional<String> vendor() {
        if (Objects.isNull(this.vendor)) {
            return Optional.empty();
        }
        return Optional.of(this.vendor);
    }

    @Override
    @NotNull
    public Optional<String> model() {
        if (Objects.isNull(this.model)) {
            return Optional.empty();
        }
        return Optional.of(this.model);
    }

    @Override
    @NotNull
    public Optional<String> serialNumber() {
        if (Objects.isNull(this.serialNumber)) {
            return Optional.empty();
        }
        return Optional.of(this.serialNumber);
    }

    @Override
    @NotNull
    public Optional<Duration> timeToFull() {
        Duration value = this.timeToFull;
        if (Objects.isNull(value)) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    @Override
    @NotNull
    public Optional<Duration> timeToEmpty() {
        Duration value = this.timeToEmpty;
        if (Objects.isNull(value)) {
            return Optional.empty();
        }
        return Optional.of(value);
    }
}

