/*
 * Decompiled with CFR 0.152.
 */
package net.lostluma.battery.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.lostluma.battery.api.exception.LibraryLoadError;
import net.lostluma.battery.impl.Constants;
import net.lostluma.battery.impl.util.CryptoUtil;
import net.lostluma.battery.impl.util.HttpUtil;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NativeUtil {
    private static Path cacheDir = null;
    private static boolean download = true;
    private static boolean isLoaded = false;
    private static final String METADATA = "/battery.natives.properties";
    private static final String BASE_URL = "https://files.lostluma.net/battery-jni/1.0.0/";

    public static void load() throws LibraryLoadError {
        if (isLoaded) {
            return;
        }
        try {
            NativeUtil.load0();
            isLoaded = true;
        }
        catch (IOException e) {
            throw new LibraryLoadError(e);
        }
    }

    public static void setCacheDir(Path path) {
        cacheDir = path;
    }

    public static void setAllowDownloads(boolean value) {
        download = value;
    }

    private static void load0() throws IOException, LibraryLoadError {
        String hash;
        Properties properties = new Properties();
        try (InputStream stream = NativeUtil.class.getResourceAsStream(METADATA);){
            if (stream == null) {
                throw new LibraryLoadError("Failed to read native library info.");
            }
            properties.load(stream);
        }
        String base = NativeUtil.getArch() + "." + NativeUtil.getName();
        if (properties.getProperty(base + ".name") == null) {
            throw new LibraryLoadError("No library found for " + NativeUtil.getArch() + " " + NativeUtil.getName());
        }
        String name = properties.getProperty(base + ".name");
        Path path = cacheDir != null ? cacheDir.resolve(name) : Constants.DEFAULT_CACHE_DIR.resolve(name);
        if (!NativeUtil.isLibraryValid(path, hash = properties.getProperty(base + ".hash"))) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            boolean copied = NativeUtil.copyFileFromJar(name, path);
            if (!copied && download) {
                HttpUtil.download(new URL(BASE_URL + name), path);
            }
            if (!NativeUtil.isLibraryValid(path, hash)) {
                throw new LibraryLoadError("Native library could not be validated.");
            }
        }
        try {
            System.load(path.toAbsolutePath().toString());
        }
        catch (UnsatisfiedLinkError e) {
            throw new LibraryLoadError(e);
        }
    }

    private static String getArch() {
        String arch = System.getProperty("os.arch");
        if (arch.equals("x86_64")) {
            arch = "amd64";
        }
        return arch;
    }

    private static String getName() {
        String name = System.getProperty("os.name").toLowerCase();
        if (name.contains("win")) {
            return "windows";
        }
        if (name.contains("mac")) {
            return "macos";
        }
        return "linux";
    }

    private static boolean isLibraryValid(Path path, String hash) throws IOException {
        return Files.exists(path, new LinkOption[0]) && hash.equals(CryptoUtil.sha512(path));
    }

    private static boolean copyFileFromJar(String name, Path destination) throws IOException {
        name = "/" + name.replace("+", ".");
        try (InputStream stream = NativeUtil.class.getResourceAsStream(name);){
            if (stream != null) {
                Files.copy(stream, destination, StandardCopyOption.REPLACE_EXISTING);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

