/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.IRangedWorkingAreaBlockEntity;
import ad_astra_giselle_addon.common.block.entity.IRocketSensingType;
import ad_astra_giselle_addon.common.block.entity.RocketSensingType;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.menu.RocketSensorMenu;
import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RocketSensorBlockEntity
extends ContainerMachineBlockEntity
implements IRangedWorkingAreaBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY));
    public static final String DATA_WORKINGAREA_VISIBLE_KEY = "workingAreaVisible";
    public static final String DATA_SENSING_TYPE_KEY = "sensingType";
    public static final String DATA_INVERTED_KEY = "inverted";
    public static final String DATA_ANALOG_SIGNAL_KEY = "analogSignal";
    public static final int CONTAINER_SIZE = 0;
    private boolean workingAreaVisible = false;
    private IRocketSensingType sensingType = RocketSensingType.DISABLED;
    private boolean inverted = false;
    private int analogSignal = 0;
    private Rocket cachedTarget;

    public RocketSensorBlockEntity(class_2338 pos, class_2680 state) {
        super(pos, state, 0);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.workingAreaVisible = tag.method_10577(DATA_WORKINGAREA_VISIBLE_KEY);
        this.sensingType = IRocketSensingType.readNBT(tag.method_10580(DATA_SENSING_TYPE_KEY));
        this.inverted = tag.method_10577(DATA_INVERTED_KEY);
        this.analogSignal = tag.method_10550(DATA_ANALOG_SIGNAL_KEY);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10556(DATA_WORKINGAREA_VISIBLE_KEY, this.workingAreaVisible);
        tag.method_10566(DATA_SENSING_TYPE_KEY, IRocketSensingType.writeNBT(this.sensingType));
        tag.method_10556(DATA_INVERTED_KEY, this.inverted);
        tag.method_10569(DATA_ANALOG_SIGNAL_KEY, this.analogSignal);
    }

    @Nullable
    public class_1703 createMenu(int windowId, class_1661 inv, class_1657 player) {
        return new RocketSensorMenu(windowId, inv, this);
    }

    public void serverTick(class_3218 level, long time, class_2680 state, class_2338 pos) {
        int analogSignal;
        super.serverTick(level, time, state, pos);
        Rocket newTarget = this.findRocket();
        int n = analogSignal = newTarget != null ? this.getSensingType().getAnalogSignal(newTarget) : 0;
        if (this.isInverted()) {
            analogSignal = 15 - analogSignal;
        }
        if (this.getCachedTarget() != newTarget) {
            this.cachedTarget = newTarget;
            this.analogSignal = analogSignal;
            this.method_5431();
            this.sync();
            this.method_5431();
        } else if (this.getAnalogSignal() != analogSignal) {
            this.analogSignal = analogSignal;
            this.method_5431();
            this.sync();
            this.method_5431();
        }
    }

    public Rocket findRocket() {
        class_1937 level = this.method_10997();
        class_238 workingArea = this.getWorkingArea();
        return level.method_18467(Rocket.class, workingArea).stream().findFirst().orElse(null);
    }

    @Override
    public boolean isWorkingAreaVisible() {
        return this.workingAreaVisible;
    }

    @Override
    public void setWorkingAreaVisible(boolean visible) {
        if (this.isWorkingAreaVisible() != visible) {
            this.workingAreaVisible = visible;
            this.sync();
            this.method_5431();
        }
    }

    @Override
    public int getWorkingRange() {
        return MachinesConfig.ROCKET_SENSOR_WORKING_RANGE;
    }

    @Override
    public class_238 getWorkingArea(double range) {
        return this.getWorkingArea(this.method_11016(), range);
    }

    public Rocket getCachedTarget() {
        return this.cachedTarget;
    }

    @NotNull
    public IRocketSensingType getSensingType() {
        return this.sensingType;
    }

    public void setSensingType(@Nullable IRocketSensingType sensingType) {
        if (sensingType == null) {
            sensingType = RocketSensingType.DISABLED;
        }
        if (this.getSensingType() != sensingType) {
            this.sensingType = sensingType;
            this.sync();
            this.method_5431();
        }
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        if (this.isInverted() != inverted) {
            this.inverted = inverted;
            this.sync();
            this.method_5431();
        }
    }

    public int getAnalogSignal() {
        return this.analogSignal;
    }

    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int[] method_5494(class_2350 pSide) {
        return new int[0];
    }
}

