/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient;

import io.netty.channel.ChannelHandler;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientImpl;
import net.fabricmc.fabric.impl.recipe.ingredient.SupportedIngredientsPacketEncoder;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonNetworkHandlerAccessor;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import org.jetbrains.annotations.Nullable;

public class CustomIngredientSync
implements ModInitializer {
    public static final class_2960 PACKET_ID = new class_2960("fabric", "custom_ingredient_sync");
    public static final int PROTOCOL_VERSION_1 = 1;
    public static final ThreadLocal<Set<class_2960>> CURRENT_SUPPORTED_INGREDIENTS = new ThreadLocal();

    @Nullable
    public static class_2540 createResponsePacket(int serverProtocolVersion) {
        if (serverProtocolVersion < 1) {
            return null;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(1);
        buf.method_34062(CustomIngredientImpl.REGISTERED_SERIALIZERS.keySet(), class_2540::method_10812);
        return buf;
    }

    public static Set<class_2960> decodeResponsePacket(class_2540 buf) {
        int protocolVersion = buf.method_10816();
        switch (protocolVersion) {
            case 1: {
                Set identifiers = (Set)buf.method_34068(HashSet::new, class_2540::method_10810);
                identifiers.removeIf(id -> !CustomIngredientImpl.REGISTERED_SERIALIZERS.containsKey(id));
                return identifiers;
            }
        }
        throw new IllegalArgumentException("Unknown ingredient sync protocol version: " + protocolVersion);
    }

    public void onInitialize() {
        ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
            if (ServerConfigurationNetworking.canSend((class_8610)handler, (class_2960)PACKET_ID)) {
                handler.addTask((class_8605)new IngredientSyncTask());
            }
        });
        ServerConfigurationNetworking.registerGlobalReceiver((class_2960)PACKET_ID, (server, handler, buf, responseSender) -> {
            Set<class_2960> supportedCustomIngredients = CustomIngredientSync.decodeResponsePacket(buf);
            ChannelHandler packetEncoder = ((ServerCommonNetworkHandlerAccessor)handler).getConnection().field_11651.pipeline().get("encoder");
            if (packetEncoder != null) {
                ((SupportedIngredientsPacketEncoder)packetEncoder).fabric_setSupportedCustomIngredients(supportedCustomIngredients);
            }
            handler.completeTask(IngredientSyncTask.KEY);
        });
    }

    private record IngredientSyncTask() implements class_8605
    {
        public static final class_8605.class_8606 KEY = new class_8605.class_8606(PACKET_ID.toString());

        public void method_52376(Consumer<class_2596<?>> sender) {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10804(1);
            sender.accept(ServerConfigurationNetworking.createS2CPacket((class_2960)PACKET_ID, (class_2540)buf));
        }

        public class_8605.class_8606 method_52375() {
            return KEY;
        }
    }
}

