/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.energy.base;

import earth.terrarium.botarium.common.energy.base.EnergySnapshot;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.fabric.ItemStackStorage;
import earth.terrarium.botarium.fabric.energy.PlatformEnergyManager;
import earth.terrarium.botarium.fabric.energy.PlatformItemEnergyManager;
import earth.terrarium.botarium.util.Serializable;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3829;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public interface EnergyContainer
extends Serializable,
class_3829 {
    public static EnergyContainer of(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        return PlatformEnergyManager.of(level, pos, state, entity, direction);
    }

    @Nullable
    public static EnergyContainer of(class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        return EnergyContainer.of(level, pos, null, null, direction);
    }

    @Nullable
    public static EnergyContainer of(class_2586 block, @Nullable class_2350 direction) {
        return EnergyContainer.of(block.method_10997(), block.method_11016(), block.method_11010(), block, direction);
    }

    public static EnergyContainer of(ItemStackHolder holder) {
        return PlatformItemEnergyManager.of(holder);
    }

    public static boolean holdsEnergy(class_1799 stack) {
        return EnergyStorage.ITEM.find(stack, (Object)ItemStackStorage.of(stack)) != null;
    }

    public static boolean holdsEnergy(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        return EnergyStorage.SIDED.find(level, pos, state, entity, (Object)direction) != null;
    }

    public static boolean holdsEnergy(class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        return EnergyContainer.holdsEnergy(level, pos, null, null, direction);
    }

    public static boolean holdsEnergy(class_2586 block, @Nullable class_2350 direction) {
        return EnergyContainer.holdsEnergy(block.method_10997(), block.method_11016(), block.method_11010(), block, direction);
    }

    public long insertEnergy(long var1, boolean var3);

    default public long internalInsert(long amount, boolean simulate) {
        return this.insertEnergy(amount, simulate);
    }

    public long extractEnergy(long var1, boolean var3);

    default public long internalExtract(long amount, boolean simulate) {
        return this.extractEnergy(amount, simulate);
    }

    public void setEnergy(long var1);

    public long getStoredEnergy();

    public long getMaxCapacity();

    public long maxInsert();

    public long maxExtract();

    public boolean allowsInsertion();

    public boolean allowsExtraction();

    public EnergySnapshot createSnapshot();

    default public void readSnapshot(EnergySnapshot snapshot) {
        snapshot.loadSnapshot(this);
    }
}

