/*
 * Decompiled with CFR 0.152.
 */
package com.itsjustmiaouss.ijmtweaks.config;

import com.google.gson.GsonBuilder;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.NameableEnum;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class IJMTweaksConfig {
    public static final int IMG_WIDTH = 1920;
    public static final int IMG_HEIGHT = 1080;
    private static final ConfigClassHandler<IJMTweaksConfig> HANDLER = ConfigClassHandler.createBuilder(IJMTweaksConfig.class).id(new class_2960("ijmtweaks", "ijmtweaks")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FabricLoader.getInstance().getConfigDir().resolve("ijmtweaks.json")).appendGsonBuilder(GsonBuilder::setPrettyPrinting).setJson5(false).build()).build();
    @SerialEntry
    public boolean darkLoadingOverlay = true;
    @SerialEntry
    public int pumpkinOverlayOpacity = 40;
    @SerialEntry
    public int blockBreakParticle = 0;
    @SerialEntry
    public boolean experienceBarInCreative = true;
    @SerialEntry
    public boolean autoJumpOnStairs = true;
    @SerialEntry
    public int zoomLevel = 70;
    @SerialEntry
    public boolean singleItemInventorySwap = true;
    @SerialEntry
    public boolean screenshotsFolder = true;
    @SerialEntry
    public boolean debugInvisibleEntities = false;
    @SerialEntry
    public FireOverlayType fireOverlay = FireOverlayType.REDUCED;

    public static void load() {
        HANDLER.load();
    }

    public static void save() {
        HANDLER.save();
    }

    public static IJMTweaksConfig get() {
        return (IJMTweaksConfig)HANDLER.instance();
    }

    public static YetAnotherConfigLib getScreen() {
        return YetAnotherConfigLib.create(HANDLER, (defaults, config, builder) -> {
            Option darkLoadingScreenOpt = IJMTweaksConfig.getGenericOption("darkLoadingOverlay", "dark_overlay").binding((Object)defaults.darkLoadingOverlay, () -> config.darkLoadingOverlay, newVal -> {
                config.darkLoadingOverlay = newVal;
            }).flag(new OptionFlag[]{OptionFlag.ASSET_RELOAD}).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option pumpkinOverlayOpacityOpt = IJMTweaksConfig.getGenericOption("pumpkinOverlayOpacity", "pumpkin_overlay").binding((Object)defaults.pumpkinOverlayOpacity, () -> config.pumpkinOverlayOpacity, newVal -> {
                config.pumpkinOverlayOpacity = newVal;
            }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)10)).formatValue(value -> class_2561.method_43470((String)(value + "%")))).build();
            Option blockBreakParticleScaleOpt = IJMTweaksConfig.getGenericOption("blockBreakParticle", "break_particles").binding((Object)defaults.blockBreakParticle, () -> config.blockBreakParticle, newVal -> {
                config.blockBreakParticle = newVal;
            }).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)4)).step((Number)1)).build();
            Option experienceBarInCreativeOpt = IJMTweaksConfig.getGenericOption("experienceBarInCreative", "experience_bar").binding((Object)defaults.experienceBarInCreative, () -> config.experienceBarInCreative, newVal -> {
                config.experienceBarInCreative = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option autoJumpOnStairsOpt = IJMTweaksConfig.getGenericOption("autoJumpOnStairs", "auto_jump").binding((Object)defaults.autoJumpOnStairs, () -> config.autoJumpOnStairs, newVal -> {
                config.autoJumpOnStairs = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option zoomLevelOpt = IJMTweaksConfig.getGenericOption("zoomLevel", "zoom_level").binding((Object)defaults.zoomLevel, () -> config.zoomLevel, newVal -> {
                config.zoomLevel = newVal;
            }).controller(opt -> ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)100)).step((Number)10)).formatValue(value -> class_2561.method_43470((String)(value + "%")))).build();
            Option fireOverlayOpt = IJMTweaksConfig.getGenericOption("fireOverlay", "fire_overlay").binding((Object)defaults.fireOverlay, () -> config.fireOverlay, newVal -> {
                config.fireOverlay = newVal;
            }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(FireOverlayType.class)).build();
            Option singleItemInventorySwapOpt = IJMTweaksConfig.getGenericOption("singleItemInventorySwap", "inventory_swap").binding((Object)defaults.singleItemInventorySwap, () -> config.singleItemInventorySwap, newVal -> {
                config.singleItemInventorySwap = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option screenshotsFolderOpt = IJMTweaksConfig.getGenericOption("screenshotsFolder", "screenshots_folder").binding((Object)defaults.screenshotsFolder, () -> config.screenshotsFolder, newVal -> {
                config.screenshotsFolder = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            Option debugInvisibleEntitiesOpt = IJMTweaksConfig.getGenericOption("debugInvisibleEntities", "debug_invisible_entities").binding((Object)defaults.debugInvisibleEntities, () -> config.debugInvisibleEntities, newVal -> {
                config.debugInvisibleEntities = newVal;
            }).controller(opt -> BooleanControllerBuilder.create((Option)opt).trueFalseFormatter()).build();
            return builder.title(class_2561.method_30163((String)"IJM's Tweaks")).category(ConfigCategory.createBuilder().name(IJMTweaksConfig.getCategoryName("overlay")).options(List.of(darkLoadingScreenOpt, pumpkinOverlayOpacityOpt, fireOverlayOpt)).build()).category(ConfigCategory.createBuilder().name(IJMTweaksConfig.getCategoryName("utility")).options(List.of(experienceBarInCreativeOpt, autoJumpOnStairsOpt, zoomLevelOpt, singleItemInventorySwapOpt, screenshotsFolderOpt)).build()).category(ConfigCategory.createBuilder().name(IJMTweaksConfig.getCategoryName("rendering")).options(List.of(blockBreakParticleScaleOpt, debugInvisibleEntitiesOpt)).build()).save(IJMTweaksConfig::save);
        });
    }

    private static <T> Option.Builder<T> getGenericOption(String name, String image) {
        return Option.createBuilder().name(IJMTweaksConfig.getOptionName(name)).description(OptionDescription.createBuilder().text(new class_2561[]{IJMTweaksConfig.getDesc(name)}).image(IJMTweaksConfig.getImage(image), 1920, 1080).build());
    }

    private static class_2561 getCategoryName(String category) {
        return class_2561.method_43471((String)String.format("category.%s.%s", "ijmtweaks", category));
    }

    private static class_2561 getOptionName(String option) {
        return class_2561.method_43471((String)String.format("option.%s.%s.name", "ijmtweaks", option));
    }

    private static class_2561 getDesc(String option) {
        return class_2561.method_43471((String)String.format("option.%s.%s.desc", "ijmtweaks", option));
    }

    private static class_2960 getImage(String name) {
        return new class_2960("ijmtweaks", String.format("config/%s.png", name));
    }

    public static enum FireOverlayType implements NameableEnum
    {
        DEFAULT,
        REDUCED,
        HIDDEN;


        public class_2561 getDisplayName() {
            return class_2561.method_43471((String)String.format("enum.%s.fireOverlayType.%s", "ijmtweaks", this.name().toLowerCase()));
        }
    }
}

