/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.compat.comforts.ComfortsCompat;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import net.minecraft.class_8957;

public class ShapedBackpackRecipe
extends class_1869 {
    public ShapedBackpackRecipe(String group, class_7710 category, class_8957 raw, class_1799 result, boolean showNotification) {
        super(group, category, raw, result, showNotification);
    }

    public class_1799 method_17727(class_8566 inv, class_5455 manager) {
        class_1799 output = super.method_17727(inv, manager);
        if (!output.method_7960()) {
            for (int i = 0; i < inv.method_5439(); ++i) {
                class_1799 ingredient = inv.method_5438(i);
                if (!ingredient.method_7960() && ingredient.method_7909() instanceof TravelersBackpackItem) {
                    class_2487 compound = ingredient.method_7969();
                    output.method_7980(compound);
                    break;
                }
                if (ingredient.method_7960() || !ingredient.method_31573(ModTags.SLEEPING_BAGS)) continue;
                output.method_7948().method_10569("SleepingBagColor", ShapedBackpackRecipe.getProperColor(ingredient.method_7909()));
            }
        }
        return output;
    }

    public static int getProperColor(class_1792 item) {
        class_1747 blockItem;
        if (item instanceof class_1747 && (blockItem = (class_1747)item).method_7711() instanceof SleepingBagBlock) {
            return ((SleepingBagBlock)blockItem.method_7711()).method_9487().method_7789();
        }
        if (TravelersBackpack.comfortsLoaded) {
            return ComfortsCompat.getComfortsSleepingBagColor(item);
        }
        return class_1767.field_7964.method_7789();
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializers.BACKPACK_SHAPED;
    }

    public static class Serializer
    implements class_1865<ShapedBackpackRecipe> {
        public static final Codec<ShapedBackpackRecipe> CODEC = RecordCodecBuilder.create(p_309256_ -> p_309256_.group((App)class_5699.method_53049((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(p_309251_ -> p_309251_.method_8112()), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(p_309253_ -> p_309253_.method_45441()), (App)class_8957.field_47321.forGetter(p_309254_ -> p_309254_.field_47320), (App)class_1799.field_47309.fieldOf("result").forGetter(p_309252_ -> p_309252_.field_9053), (App)class_5699.method_53049((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(p_309255_ -> p_309255_.method_49188())).apply((Applicative)p_309256_, ShapedBackpackRecipe::new));

        public Codec<ShapedBackpackRecipe> method_53736() {
            return CODEC;
        }

        public ShapedBackpackRecipe read(class_2540 packetByteBuf) {
            String string = packetByteBuf.method_19772();
            class_7710 craftingRecipeCategory = (class_7710)packetByteBuf.method_10818(class_7710.class);
            class_8957 rawShapedRecipe = class_8957.method_55090((class_2540)packetByteBuf);
            class_1799 itemStack = packetByteBuf.method_10819();
            boolean bl = packetByteBuf.readBoolean();
            return new ShapedBackpackRecipe(string, craftingRecipeCategory, rawShapedRecipe, itemStack, bl);
        }

        public void write(class_2540 packetByteBuf, ShapedBackpackRecipe shapedBackpackRecipe) {
            packetByteBuf.method_10814(shapedBackpackRecipe.method_8112());
            packetByteBuf.method_10817((Enum)shapedBackpackRecipe.method_45441());
            shapedBackpackRecipe.field_47320.method_55087(packetByteBuf);
            packetByteBuf.method_10793(shapedBackpackRecipe.field_9053);
            packetByteBuf.method_52964(shapedBackpackRecipe.method_49188());
        }
    }
}

