/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.InventoryImproved;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackItemScreenHandler;
import com.tiviacz.travelersbackpack.inventory.screen.slot.ToolSlot;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import com.tiviacz.travelersbackpack.inventory.sorter.wrappers.CombinedInvWrapper;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.impl.transfer.fluid.FluidVariantImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackInventory
implements ITravelersBackpackInventory {
    private final InventoryImproved inventory = this.createInventory(Tiers.LEATHER.getStorageSlots(), true);
    private final InventoryImproved craftingInventory = this.createInventory(9, false);
    private final InventoryImproved toolSlots = this.createToolsInventory(Tiers.LEATHER.getToolSlots());
    private final InventoryImproved fluidSlots = this.createTemporaryInventory();
    private final FluidTank leftTank = this.createFluidTank(Tiers.LEATHER.getTankCapacity());
    private final FluidTank rightTank = this.createFluidTank(Tiers.LEATHER.getTankCapacity());
    private final SlotManager slotManager = new SlotManager(this);
    private final SettingsManager settingsManager = new SettingsManager(this);
    private final class_1657 player;
    private class_1799 stack;
    private Tiers.Tier tier;
    private boolean ability;
    private int lastTime;
    private final byte screenID;

    public TravelersBackpackInventory(@Nullable class_1799 stack, class_1657 player, byte screenID) {
        this.player = player;
        this.stack = stack;
        this.screenID = screenID;
        if (stack != null) {
            this.readAllData(stack.method_7948());
        }
    }

    public void setStack(class_1799 stack) {
        this.stack = stack;
    }

    public void readTier(class_2487 compound) {
        if (!compound.method_10545("Tier")) {
            compound.method_10569("Tier", TravelersBackpackConfig.getConfig().backpackSettings.enableTierUpgrades ? Tiers.LEATHER.getOrdinal() : Tiers.DIAMOND.getOrdinal());
        }
        if (compound.method_10573("Tier", 8)) {
            Tiers.Tier tier = Tiers.of(compound.method_10558("Tier"));
            compound.method_10551("Tier");
            compound.method_10569("Tier", tier.getOrdinal());
        }
        this.tier = Tiers.of(compound.method_10550("Tier"));
    }

    @Override
    public InventoryImproved getInventory() {
        return this.inventory;
    }

    @Override
    public InventoryImproved getToolSlotsInventory() {
        return this.toolSlots;
    }

    @Override
    public InventoryImproved getCraftingGridInventory() {
        return this.craftingInventory;
    }

    @Override
    public InventoryImproved getFluidSlotsInventory() {
        return this.fluidSlots;
    }

    @Override
    public class_1263 getCombinedInventory() {
        return new CombinedInvWrapper(this, this.getInventory(), this.getToolSlotsInventory(), this.getFluidSlotsInventory(), this.getCraftingGridInventory());
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    @Override
    public void writeItems(class_2487 compound) {
        compound.method_10566("Inventory", (class_2520)this.inventory.writeNbt());
        compound.method_10566("ToolsInventory", (class_2520)this.toolSlots.writeNbt());
        compound.method_10566("CraftingInventory", (class_2520)this.craftingInventory.writeNbt());
    }

    @Override
    public void readItems(class_2487 compound) {
        this.inventory.readNbt(compound.method_10562("Inventory"));
        this.toolSlots.readNbt(compound.method_10562("ToolsInventory"));
        this.craftingInventory.readNbt(compound.method_10562("CraftingInventory"));
        if (compound.method_10573("Inventory", 9)) {
            this.inventory.readNbtOld(compound, true);
        }
        if (compound.method_10573("CraftingInventory", 9)) {
            this.craftingInventory.readNbtOld(compound, false);
        }
    }

    @Override
    public void writeTanks(class_2487 compound) {
        compound.method_10566("LeftTank", (class_2520)this.leftTank.writeToNbt(new class_2487()));
        compound.method_10566("RightTank", (class_2520)this.rightTank.writeToNbt(new class_2487()));
        if (compound.method_10545("LeftTankAmount")) {
            compound.method_10551("LeftTankAmount");
        }
        if (compound.method_10545("RightTankAmount")) {
            compound.method_10551("RightTankAmount");
        }
    }

    @Override
    public void readTanks(class_2487 compound) {
        this.leftTank.readNbt(compound.method_10562("LeftTank"));
        this.rightTank.readNbt(compound.method_10562("RightTank"));
        if (compound.method_10573("LeftTankAmount", 4)) {
            this.leftTank.readOldNbt(compound, true);
        }
        if (compound.method_10573("RightTankAmount", 4)) {
            this.rightTank.readOldNbt(compound, false);
        }
    }

    @Override
    public void writeColor(class_2487 compound) {
    }

    @Override
    public void readColor(class_2487 compound) {
    }

    @Override
    public void writeSleepingBagColor(class_2487 compound) {
    }

    @Override
    public void readSleepingBagColor(class_2487 compound) {
    }

    @Override
    public void writeAbility(class_2487 compound) {
        compound.method_10556("Ability", this.ability);
    }

    @Override
    public void readAbility(class_2487 compound) {
        this.ability = !compound.method_10545("Ability") && TravelersBackpackConfig.getConfig().backpackAbilities.forceAbilityEnabled || compound.method_10577("Ability");
    }

    @Override
    public void writeTime(class_2487 compound) {
        compound.method_10569("LastTime", this.lastTime);
    }

    @Override
    public void readTime(class_2487 compound) {
        this.lastTime = compound.method_10550("LastTime");
    }

    @Override
    public void writeAllData(class_2487 compound) {
        this.writeItems(compound);
        this.writeTanks(compound);
        this.writeAbility(compound);
        this.writeTime(compound);
        this.slotManager.writeUnsortableSlots(compound);
        this.slotManager.writeMemorySlots(compound);
        this.settingsManager.writeSettings(compound);
    }

    @Override
    public void readAllData(class_2487 compound) {
        this.readTier(compound);
        this.readItems(compound);
        this.readTanks(compound);
        this.readAbility(compound);
        this.readTime(compound);
        this.slotManager.readUnsortableSlots(compound);
        this.slotManager.readMemorySlots(compound);
        this.settingsManager.readSettings(compound);
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 0, this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), 2, this.player);
    }

    public void sendPackets() {
        if (this.screenID == 2) {
            ComponentUtils.sync(this.player);
        }
    }

    @Override
    public boolean hasColor() {
        return this.stack.method_7948().method_10545("Color");
    }

    @Override
    public int getColor() {
        if (this.hasColor()) {
            return this.stack.method_7948().method_10550("Color");
        }
        return 0;
    }

    @Override
    public boolean hasSleepingBagColor() {
        return this.stack.method_7948().method_10545("SleepingBagColor");
    }

    @Override
    public int getSleepingBagColor() {
        if (this.hasSleepingBagColor()) {
            return this.stack.method_7948().method_10550("SleepingBagColor");
        }
        return class_1767.field_7964.method_7789();
    }

    @Override
    public boolean getAbilityValue() {
        return TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities ? (TravelersBackpackConfig.isAbilityAllowed(this.getItemStack()) ? this.ability : false) : false;
    }

    @Override
    public void setAbility(boolean value) {
        this.ability = value;
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public int getRows() {
        return (int)Math.ceil((double)this.getInventory().method_5439() / 9.0);
    }

    @Override
    public int getYOffset() {
        return 18 * Math.max(0, this.getRows() - 3);
    }

    @Override
    public boolean hasTileEntity() {
        return false;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return false;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    @Override
    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @Override
    public Tiers.Tier getTier() {
        return this.tier;
    }

    @Override
    public class_1937 method_10997() {
        return this.player.method_37908();
    }

    @Override
    public class_2338 getPosition() {
        return this.player.method_24515();
    }

    @Override
    public byte getScreenID() {
        return this.screenID;
    }

    @Override
    public class_1799 getItemStack() {
        return this.stack == null ? class_1799.field_8037 : this.stack;
    }

    @Override
    public void setUsingPlayer(@Nullable class_1657 player) {
    }

    @Override
    public void markDataDirty(byte ... dataIds) {
        if (this.method_10997().field_9236 || this.stack == null) {
            return;
        }
        for (byte data : dataIds) {
            switch (data) {
                case 0: {
                    this.stack.method_7948().method_10566("Inventory", (class_2520)this.inventory.writeNbt());
                }
                case 1: {
                    this.stack.method_7948().method_10566("ToolsInventory", (class_2520)this.toolSlots.writeNbt());
                }
                case 2: {
                    this.stack.method_7948().method_10566("CraftingInventory", (class_2520)this.craftingInventory.writeNbt());
                }
                case 3: {
                    this.writeItems(this.stack.method_7948());
                }
                case 4: {
                    this.writeTanks(this.stack.method_7948());
                }
                case 5: {
                    this.writeColor(this.stack.method_7948());
                }
                case 6: {
                    this.writeSleepingBagColor(this.stack.method_7948());
                }
                case 7: {
                    this.writeAbility(this.stack.method_7948());
                }
                case 8: {
                    this.writeTime(this.stack.method_7948());
                }
                case 9: {
                    this.slotManager.writeUnsortableSlots(this.stack.method_7948());
                    this.slotManager.writeMemorySlots(this.stack.method_7948());
                }
                case 10: {
                    this.settingsManager.writeSettings(this.stack.method_7948());
                }
                case 11: {
                    this.writeAllData(this.stack.method_7948());
                }
            }
        }
        this.sendPackets();
    }

    @Override
    public void method_5431() {
    }

    public static void abilityTick(class_1657 player) {
        if (player.method_5805() && ComponentUtils.isWearingBackpack(player) && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, ComponentUtils.getWearingBackpack(player))) {
            TravelersBackpackInventory inv = ComponentUtils.getBackpackInv(player);
            if (!inv.method_10997().field_9236 && inv.getLastTime() > 0) {
                inv.setLastTime(inv.getLastTime() - 1);
                inv.markDataDirty(8);
            }
            if (inv.getAbilityValue()) {
                BackpackAbilities.ABILITIES.abilityTick(ComponentUtils.getWearingBackpack(player), player, null);
            }
        }
    }

    public static void openHandledScreen(class_1657 player, final class_1799 stack, final byte screenID) {
        if (!player.method_37908().field_9236) {
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                    buf.method_52997((int)screenID);
                }

                public class_2561 method_5476() {
                    return class_2561.method_43471((String)"screen.travelersbackpack.item");
                }

                @Nullable
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    if (screenID == 2) {
                        return new TravelersBackpackItemScreenHandler(syncId, inv, ComponentUtils.getBackpackInv(player));
                    }
                    return new TravelersBackpackItemScreenHandler(syncId, inv, new TravelersBackpackInventory(stack, player, screenID));
                }
            });
        }
    }

    public InventoryImproved createInventory(int size, final boolean isInventory) {
        return new InventoryImproved(size){

            @Override
            public void method_5431() {
                if (isInventory) {
                    TravelersBackpackInventory.this.markDataDirty(0);
                } else {
                    TravelersBackpackInventory.this.markDataDirty(2);
                }
            }

            @Override
            public void readNbt(class_2487 nbt) {
                if (isInventory) {
                    this.setSize(nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : TravelersBackpackInventory.this.tier.getStorageSlots());
                    class_2499 tagList = nbt.method_10554("Items", 10);
                    for (int i = 0; i < tagList.size(); ++i) {
                        class_2487 itemTags = tagList.method_10602(i);
                        int slot = itemTags.method_10550("Slot");
                        if (slot < 0 || slot >= this.stacks.size()) continue;
                        this.stacks.set(slot, (Object)class_1799.method_7915((class_2487)itemTags));
                    }
                } else {
                    super.readNbt(nbt);
                }
            }
        };
    }

    private InventoryImproved createToolsInventory(int size) {
        return new InventoryImproved(size){

            @Override
            public void method_5431() {
                TravelersBackpackInventory.this.markDataDirty(1);
            }

            @Override
            public boolean method_5437(int slot, class_1799 stack) {
                return ToolSlot.isValid(stack);
            }

            @Override
            public void readNbt(class_2487 nbt) {
                this.setSize(nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : TravelersBackpackInventory.this.tier.getToolSlots());
                class_2499 tagList = nbt.method_10554("Items", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    class_2487 itemTags = tagList.method_10602(i);
                    int slot = itemTags.method_10550("Slot");
                    if (slot < 0 || slot >= this.stacks.size()) continue;
                    this.stacks.set(slot, (Object)class_1799.method_7915((class_2487)itemTags));
                }
            }
        };
    }

    public FluidTank createFluidTank(long tankCapacity) {
        return new FluidTank(tankCapacity){

            protected void onFinalCommit() {
                TravelersBackpackInventory.this.markDataDirty(4);
            }

            @Override
            public FluidTank readNbt(class_2487 nbt) {
                this.setCapacity(nbt.method_10545("capacity") ? nbt.method_10537("capacity") : TravelersBackpackInventory.this.tier.getTankCapacity());
                this.variant = FluidVariantImpl.fromNbt((class_2487)nbt.method_10562("variant"));
                this.amount = nbt.method_10537("amount");
                return this;
            }
        };
    }
}

