/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.screen;

import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.init.ModScreenHandlerTypes;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackBaseScreenHandler;
import com.tiviacz.travelersbackpack.inventory.screen.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_3917;

public class TravelersBackpackItemScreenHandler
extends TravelersBackpackBaseScreenHandler {
    public TravelersBackpackItemScreenHandler(int windowID, class_1661 playerInventory, class_2540 data) {
        this(windowID, playerInventory, TravelersBackpackItemScreenHandler.createInventory(playerInventory, data));
    }

    public TravelersBackpackItemScreenHandler(int windowID, class_1661 playerInventory, ITravelersBackpackInventory inventory) {
        super((class_3917<?>)ModScreenHandlerTypes.TRAVELERS_BACKPACK_ITEM, windowID, playerInventory, inventory);
    }

    private static TravelersBackpackInventory createInventory(class_1661 playerInventory, class_2540 data) {
        class_1799 stack;
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        byte screenID = data.readByte();
        if (screenID == 1) {
            stack = playerInventory.field_7546.method_6118(class_1304.field_6173);
        } else if (data.writerIndex() == 94) {
            int entityId = data.readInt();
            stack = ComponentUtils.getWearingBackpack((class_1657)playerInventory.field_7546.method_37908().method_8469(entityId));
            if (stack.method_7909() instanceof TravelersBackpackItem) {
                return ComponentUtils.getBackpackInv((class_1657)playerInventory.field_7546.method_37908().method_8469(entityId));
            }
        } else {
            stack = ComponentUtils.getWearingBackpack(playerInventory.field_7546);
        }
        if (stack.method_7909() instanceof TravelersBackpackItem) {
            if (screenID == 2) {
                return ComponentUtils.getBackpackInv(playerInventory.field_7546);
            }
            if (screenID == 1) {
                return new TravelersBackpackInventory(stack, playerInventory.field_7546, screenID);
            }
        }
        throw new IllegalStateException("ItemStack is not correct! " + String.valueOf(stack));
    }

    @Override
    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if (this.inventory.getScreenID() == 1 && actionType == class_1713.field_7791) {
            class_1799 stack = player.method_31548().method_5438(button);
            class_1799 currentItem = player.method_31548().method_7391();
            if (!currentItem.method_7960() && stack == currentItem) {
                return;
            }
        }
        super.method_7593(slotIndex, button, actionType, player);
    }

    @Override
    public void addPlayerInventoryAndHotbar(class_1661 playerInv, int currentItemIndex) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.method_7621(new class_1735((class_1263)playerInv, x + y * 9 + 9, 44 + x * 18, 71 + this.inventory.getYOffset() + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            if (x == currentItemIndex && this.inventory.getScreenID() == 1) {
                this.method_7621(new DisabledSlot((class_1263)playerInv, x, 44 + x * 18, 129 + this.inventory.getYOffset()));
                continue;
            }
            this.method_7621(new class_1735((class_1263)playerInv, x, 44 + x * 18, 129 + this.inventory.getYOffset()));
        }
    }
}

