/*
 * Decompiled with CFR 0.152.
 */
package io.github.hornster.itemfig.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class SerializationHelper {
    public static void addProperty(Field field, JsonObject jsonObject, Object src) throws IllegalAccessException, Exception {
        Class<?> fieldType = field.getType();
        boolean wasAccessible = field.canAccess(src);
        field.setAccessible(true);
        if (fieldType.equals(Character.class)) {
            jsonObject.addProperty(field.getName(), (Character)field.get(src));
        } else if (fieldType.equals(Integer.class)) {
            jsonObject.addProperty(field.getName(), (Number)((Integer)field.get(src)));
        } else if (fieldType.equals(Short.class)) {
            jsonObject.addProperty(field.getName(), (Number)((Short)field.get(src)));
        } else if (fieldType.equals(Float.class)) {
            jsonObject.addProperty(field.getName(), (Number)((Float)field.get(src)));
        } else if (fieldType.equals(Double.class)) {
            jsonObject.addProperty(field.getName(), (Number)((Double)field.get(src)));
        } else if (fieldType.equals(String.class)) {
            jsonObject.addProperty(field.getName(), (String)field.get(src));
        } else if (fieldType.equals(Long.class)) {
            jsonObject.addProperty(field.getName(), (Number)((Long)field.get(src)));
        } else if (fieldType.equals(Boolean.class)) {
            jsonObject.addProperty(field.getName(), (Boolean)field.get(src));
        } else {
            if (!wasAccessible) {
                field.setAccessible(false);
            }
            throw new Exception("Unknown field type during serialization: " + fieldType.getTypeName());
        }
        if (!wasAccessible) {
            field.setAccessible(false);
        }
    }

    public static void readProperty(Field field, JsonObject jsonObject, Object dest) throws Exception {
        Class<?> fieldType = field.getType();
        JsonElement jsonFieldElement = jsonObject.get(field.getName());
        if (jsonFieldElement == null) {
            return;
        }
        if (!jsonFieldElement.isJsonPrimitive()) {
            throw new Exception("Objects as config fields are not supported at the moment!");
        }
        JsonPrimitive jsonFieldVal = jsonFieldElement.getAsJsonPrimitive();
        boolean wasAccessible = field.canAccess(dest);
        field.setAccessible(true);
        if (fieldType.equals(Character.class)) {
            String val = jsonFieldVal.getAsString();
            if (val != null) {
                field.set(dest, Character.valueOf(val.charAt(0)));
            }
        } else if (fieldType.equals(Integer.class)) {
            field.set(dest, jsonFieldVal.getAsInt());
        } else if (fieldType.equals(Short.class)) {
            field.set(dest, jsonFieldVal.getAsShort());
        } else if (fieldType.equals(Float.class)) {
            float val = jsonFieldVal.getAsFloat();
            field.set(dest, Float.valueOf(val));
        } else if (fieldType.equals(Double.class)) {
            field.set(dest, jsonFieldVal.getAsDouble());
        } else if (fieldType.equals(String.class)) {
            field.set(dest, jsonFieldVal.getAsString());
        } else if (fieldType.equals(Long.class)) {
            field.set(dest, jsonFieldVal.getAsLong());
        } else if (fieldType.equals(Boolean.class)) {
            field.set(dest, jsonFieldVal.getAsBoolean());
        } else {
            if (!wasAccessible) {
                field.setAccessible(false);
            }
            throw new Exception("Unknown field type during serialization: " + fieldType.getTypeName());
        }
        if (!wasAccessible) {
            field.setAccessible(false);
        }
    }

    public static Map<String, JsonElement> getAsMap(JsonObject jsonObject) {
        LinkedHashMap<String, JsonElement> map = new LinkedHashMap<String, JsonElement>();
        Set entries = jsonObject.entrySet();
        for (Map.Entry entry : entries) {
            map.put((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        return map;
    }
}

