/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stoneworks.world.block.variant;

import com.google.common.collect.Maps;
import fuzs.stoneworks.Stoneworks;
import fuzs.stoneworks.config.CommonConfig;
import fuzs.stoneworks.world.block.variant.BlockVariant;
import fuzs.stoneworks.world.block.variant.StoneBlockVariant;
import fuzs.stoneworks.world.block.variant.StoneType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class StoneVariantsProvider {
    private static final Map<String, StoneBlockVariant> STONE_BLOCK_VARIANTS = Maps.newLinkedHashMap();
    @Nullable
    private static Collection<class_1799> sortedVariantItems;

    public static void invalidateItems() {
        sortedVariantItems = null;
    }

    public static Stream<StoneBlockVariant> getAllStoneBlockVariants() {
        return STONE_BLOCK_VARIANTS.values().stream();
    }

    public static Stream<StoneBlockVariant> getStoneBlockVariants() {
        return STONE_BLOCK_VARIANTS.values().stream().filter(Predicate.not(StoneBlockVariant::isVanillaVariant));
    }

    public static class_1799[] getDisplayItemStacks() {
        return (class_1799[])StoneVariantsProvider.getAllStoneBlockVariants().filter(variant -> variant.blockVariant() == BlockVariant.REGULAR).map(StoneBlockVariant::block).map(class_1799::new).toArray(class_1799[]::new);
    }

    public static Collection<class_1799> getSortedVariantItems() {
        if (sortedVariantItems == null) {
            Stream<StoneBlockVariant> stream = Stoneworks.CONFIG.getHolder(CommonConfig.class).isAvailable() && ((CommonConfig)Stoneworks.CONFIG.get(CommonConfig.class)).vanillaVariantsInCreativeTab ? StoneVariantsProvider.getAllStoneBlockVariants() : StoneVariantsProvider.getStoneBlockVariants();
            sortedVariantItems = stream.sorted(Comparator.comparingInt(v -> v.stoneType().ordinal()).thenComparingInt(v -> v.blockVariant().ordinal())).flatMap(StoneBlockVariant::allBlocks).map(class_2248::method_8389).map(class_1799::new).toList();
        }
        return sortedVariantItems;
    }

    private static void registerAllStoneBlockVariants() {
        for (StoneType stoneType : StoneType.values()) {
            for (BlockVariant blockVariant : BlockVariant.values()) {
                StoneVariantsProvider.registerStoneBlockVariant(new StoneBlockVariant(stoneType, blockVariant), false);
            }
        }
    }

    private static void registerStoneBlockVariant(StoneBlockVariant variant, boolean replace) {
        if (STONE_BLOCK_VARIANTS.put(variant.name(), variant) == null && replace) {
            throw new IllegalStateException("unable to replace stone block variant %s".formatted(variant.name()));
        }
    }

    public static StoneBlockVariant getStoneVariant(StoneType stoneType, BlockVariant blockVariant) {
        return STONE_BLOCK_VARIANTS.get(blockVariant.getName(stoneType));
    }

    private static void registerVanillaOverrides() {
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.REGULAR, class_2246.field_10340);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.COBBLED, class_2246.field_10445);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.MOSSY_COBBLED, class_2246.field_9989);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.BRICKS, class_2246.field_10056);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.MOSSY_BRICKS, class_2246.field_10065);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.CRACKED_BRICKS, class_2246.field_10416);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.POLISHED, class_2246.field_10360);
        StoneVariantsProvider.registerVanillaOverride(StoneType.STONE, BlockVariant.CHISELED, class_2246.field_10552);
        StoneVariantsProvider.registerVanillaOverride(StoneType.ANDESITE, BlockVariant.REGULAR, class_2246.field_10115);
        StoneVariantsProvider.registerVanillaOverride(StoneType.ANDESITE, BlockVariant.POLISHED, class_2246.field_10093);
        StoneVariantsProvider.registerVanillaOverride(StoneType.GRANITE, BlockVariant.REGULAR, class_2246.field_10474);
        StoneVariantsProvider.registerVanillaOverride(StoneType.GRANITE, BlockVariant.POLISHED, class_2246.field_10289);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DIORITE, BlockVariant.REGULAR, class_2246.field_10508);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DIORITE, BlockVariant.POLISHED, class_2246.field_10346);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.REGULAR, class_2246.field_28888);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.COBBLED, class_2246.field_29031);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.BRICKS, class_2246.field_28900);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.CRACKED_BRICKS, class_2246.field_29222);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.POLISHED, class_2246.field_28892);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.CHISELED, class_2246.field_28904);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.TILES, class_2246.field_28896);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DEEPSLATE, BlockVariant.CRACKED_TILES, class_2246.field_29223);
        StoneVariantsProvider.registerVanillaOverride(StoneType.CALCITE, BlockVariant.REGULAR, class_2246.field_27114);
        StoneVariantsProvider.registerVanillaOverride(StoneType.TUFF, BlockVariant.REGULAR, class_2246.field_27165);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BASALT, BlockVariant.REGULAR, class_2246.field_22091);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BASALT, BlockVariant.POLISHED, class_2246.field_29032);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BASALT, BlockVariant.PILLAR, class_2246.field_23151);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.REGULAR, class_2246.field_23869);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.BRICKS, class_2246.field_23874);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.CRACKED_BRICKS, class_2246.field_23875);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.POLISHED, class_2246.field_23873);
        StoneVariantsProvider.registerVanillaOverride(StoneType.BLACKSTONE, BlockVariant.CHISELED, class_2246.field_23876);
        StoneVariantsProvider.registerVanillaOverride(StoneType.NETHERRACK, BlockVariant.REGULAR, class_2246.field_10515);
        StoneVariantsProvider.registerVanillaOverride(StoneType.NETHERRACK, BlockVariant.CHISELED, class_2246.field_23866);
        StoneVariantsProvider.registerVanillaOverride(StoneType.NETHERRACK, BlockVariant.TILES, class_2246.field_10266);
        StoneVariantsProvider.registerVanillaOverride(StoneType.NETHERRACK, BlockVariant.CRACKED_TILES, class_2246.field_23867);
        StoneVariantsProvider.registerVanillaOverride(StoneType.END_STONE, BlockVariant.REGULAR, class_2246.field_10471);
        StoneVariantsProvider.registerVanillaOverride(StoneType.END_STONE, BlockVariant.BRICKS, class_2246.field_10462);
        StoneVariantsProvider.registerVanillaOverride(StoneType.PURPUR, BlockVariant.PLATES, class_2246.field_10286, class_2246.field_9992, class_2246.field_10175);
        StoneVariantsProvider.registerVanillaOverride(StoneType.PURPUR, BlockVariant.PILLAR, class_2246.field_10505);
        StoneVariantsProvider.registerVanillaOverride(StoneType.PRISMARINE, BlockVariant.REGULAR, class_2246.field_10135);
        StoneVariantsProvider.registerVanillaOverride(StoneType.PRISMARINE, BlockVariant.SHINGLES, class_2246.field_10006);
        StoneVariantsProvider.registerVanillaOverride(StoneType.DARK_PRISMARINE, BlockVariant.PAVERS, class_2246.field_10297);
        StoneVariantsProvider.registerVanillaOverride(StoneType.SANDSTONE, BlockVariant.REGULAR, class_2246.field_9979);
        StoneVariantsProvider.registerVanillaOverride(StoneType.SANDSTONE, BlockVariant.POLISHED, class_2246.field_10361);
        StoneVariantsProvider.registerVanillaOverride(StoneType.SANDSTONE, BlockVariant.CHISELED, class_2246.field_10292);
        StoneVariantsProvider.registerVanillaOverride(StoneType.RED_SANDSTONE, BlockVariant.REGULAR, class_2246.field_10344);
        StoneVariantsProvider.registerVanillaOverride(StoneType.RED_SANDSTONE, BlockVariant.POLISHED, class_2246.field_10518);
        StoneVariantsProvider.registerVanillaOverride(StoneType.RED_SANDSTONE, BlockVariant.CHISELED, class_2246.field_10117);
        StoneVariantsProvider.registerVanillaOverride(StoneType.QUARTZ, BlockVariant.REGULAR, class_2246.field_10153);
        StoneVariantsProvider.registerVanillaOverride(StoneType.QUARTZ, BlockVariant.BRICKS, class_2246.field_23868);
        StoneVariantsProvider.registerVanillaOverride(StoneType.QUARTZ, BlockVariant.CHISELED, class_2246.field_10044);
        StoneVariantsProvider.registerVanillaOverride(StoneType.QUARTZ, BlockVariant.PILLAR, class_2246.field_10437);
    }

    private static void registerVanillaOverride(StoneType stoneType, BlockVariant blockVariant, class_2248 ... blocks) {
        StoneVariantsProvider.registerStoneBlockVariant(new VanillaStoneBlockVariant(stoneType, blockVariant, blocks), true);
    }

    static {
        StoneVariantsProvider.registerAllStoneBlockVariants();
        StoneVariantsProvider.registerVanillaOverrides();
    }

    private static class VanillaStoneBlockVariant
    extends StoneBlockVariant {
        private final String block;
        private final boolean deviates;

        VanillaStoneBlockVariant(StoneType stoneType, BlockVariant blockVariant, class_2248 ... blocks) {
            super(stoneType, blockVariant, Arrays.copyOf(blocks, 4));
            if (blocks.length < 1 || blocks.length > 4) {
                throw new IllegalStateException("wrong number of blocks provided");
            }
            this.block = class_7923.field_41175.method_10221((Object)blocks[0]).method_12832();
            this.deviates = !this.blockName().equals(this.name());
        }

        @Override
        public String blockName() {
            return this.block;
        }

        @Override
        public String stairsName() {
            return this.deviates ? this.blockName() + "_stairs" : super.stairsName();
        }

        @Override
        public String slabName() {
            return this.deviates ? this.blockName() + "_slab" : super.slabName();
        }

        @Override
        public String wallName() {
            return this.deviates ? this.blockName() + "_wall" : super.wallName();
        }

        @Override
        public class_2960 id(String key) {
            return new class_2960(key);
        }

        @Override
        public boolean isVanillaVariant() {
            return true;
        }
    }
}

