/*
 * Decompiled with CFR 0.152.
 */
package com.vinurl.exe;

import com.vinurl.VinURL;
import com.vinurl.VinURLClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.commons.lang3.SystemUtils;

@Environment(value=EnvType.CLIENT)
public class Executable {
    private final String FILENAME;
    private final File DIRECTORY;
    private final String REPOSITORY_FILE;
    private final String REPOSITORY_NAME;
    private final Path FILEPATH;

    public Executable(String fileName, File directory, String repository_file, String repository_name) {
        this.FILENAME = fileName;
        this.DIRECTORY = directory;
        this.REPOSITORY_FILE = repository_file;
        this.REPOSITORY_NAME = repository_name;
        this.FILEPATH = this.DIRECTORY.toPath().resolve(this.FILENAME);
    }

    public void checkForExecutable() throws IOException, URISyntaxException {
        if (this.DIRECTORY.exists() || this.DIRECTORY.mkdirs()) {
            if (!this.FILEPATH.toFile().exists()) {
                this.downloadExecutable();
            } else if (VinURLClient.CONFIG.UpdateCheckingOnStartup().booleanValue()) {
                this.checkForUpdates();
            }
        }
    }

    public boolean checkForUpdates() {
        try {
            if (!this.currentVersion(this.FILEPATH.getParent().resolve("version.txt")).equals(this.latestVersion())) {
                this.downloadExecutable();
                return true;
            }
            return false;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private void downloadExecutable() throws IOException, URISyntaxException {
        try (InputStream inputStream = this.getDownloadInputStream();){
            if (this.REPOSITORY_FILE.endsWith(".zip")) {
                try (ZipInputStream zipInput = new ZipInputStream(inputStream);){
                    ZipEntry zipEntry = zipInput.getNextEntry();
                    while (zipEntry != null) {
                        if (zipEntry.getName().endsWith(this.FILENAME)) {
                            Files.copy(zipInput, this.FILEPATH, StandardCopyOption.REPLACE_EXISTING);
                        }
                        zipEntry = zipInput.getNextEntry();
                    }
                }
            } else {
                Files.copy(inputStream, this.FILEPATH, StandardCopyOption.REPLACE_EXISTING);
            }
            if (SystemUtils.IS_OS_UNIX) {
                Runtime.getRuntime().exec(new String[]{"chmod", "+x", this.FILEPATH.toString()});
            }
            this.createVersionFile(this.latestVersion(), this.FILEPATH.getParent().resolve("version.txt"));
        }
    }

    private void createVersionFile(String version, Path versionFilePath) throws IOException {
        try (FileWriter writer = new FileWriter(versionFilePath.toFile());){
            writer.write(version);
        }
    }

    private String currentVersion(Path filePath) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath.toFile()));){
            String string = reader.readLine().trim();
            return string;
        }
    }

    private String latestVersion() {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(String.format("https://api.github.com/repos/%s/releases/latest", this.REPOSITORY_NAME)).openStream()));
        try {
            string = reader.readLine().split("\"tag_name\":\"")[1].split("\",\"target_commitish\"")[0];
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ArrayIndexOutOfBoundsException e) {
                return "";
            }
        }
        reader.close();
        return string;
    }

    private InputStream getDownloadInputStream() throws IOException, URISyntaxException {
        return new URI(String.format("https://github.com/%s/releases/latest/download/%s", this.REPOSITORY_NAME, this.REPOSITORY_FILE)).toURL().openStream();
    }

    public boolean executeCommand(String ... arguments) {
        try {
            Process process = Runtime.getRuntime().exec((String[])Stream.concat(Stream.of(this.FILEPATH.toString()), Arrays.stream(arguments)).toArray(String[]::new));
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String line;
                while ((line = errorReader.readLine()) != null) {
                    VinURL.LOGGER.info(line);
                }
                if (process.waitFor() != 0) {
                    throw new IOException();
                }
            }
            return true;
        }
        catch (IOException | InterruptedException e) {
            return false;
        }
    }
}

