/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.particles.systems;

import io.wispforest.owo.Owo;
import io.wispforest.owo.network.NetworkException;
import io.wispforest.owo.network.OwoHandshake;
import io.wispforest.owo.particles.systems.ParticleSystem;
import io.wispforest.owo.particles.systems.ParticleSystemExecutor;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.endec.ReflectiveEndecBuilder;
import io.wispforest.owo.util.OwoFreezer;
import io.wispforest.owo.util.ReflectionUtils;
import io.wispforest.owo.util.VectorSerializer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import org.jetbrains.annotations.ApiStatus;

public class ParticleSystemController {
    @ApiStatus.Internal
    public static final Map<class_2960, ParticleSystemController> REGISTERED_CONTROLLERS = new HashMap<class_2960, ParticleSystemController>();
    @ApiStatus.Internal
    public final Int2ObjectMap<ParticleSystem<?>> systemsByIndex = new Int2ObjectOpenHashMap();
    public final class_2960 channelId;
    private int maxIndex = 0;
    private final String ownerClassName;

    public ParticleSystemController(class_2960 channelId) {
        OwoFreezer.checkRegister("Particle system controllers");
        if (REGISTERED_CONTROLLERS.containsKey(channelId)) {
            throw new IllegalStateException("Controller with id '" + channelId + "' was already registered from class '" + ParticleSystemController.REGISTERED_CONTROLLERS.get((Object)channelId).ownerClassName + "'");
        }
        this.channelId = channelId;
        this.ownerClassName = ReflectionUtils.getCallingClassName(2);
        OwoHandshake.enable();
        OwoHandshake.requireHandshake();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)channelId, new Client()::handler);
        }
        REGISTERED_CONTROLLERS.put(channelId, this);
    }

    public <T> ParticleSystem<T> register(Class<T> dataClass, Endec<T> endec, ParticleSystemExecutor<T> executor) {
        int index = this.maxIndex++;
        ParticleSystem<T> system = new ParticleSystem<T>(this, dataClass, index, endec, executor);
        this.systemsByIndex.put(index, system);
        return system;
    }

    public <T> ParticleSystem<T> register(Class<T> dataClass, ParticleSystemExecutor<T> executor) {
        return this.register(dataClass, ReflectiveEndecBuilder.get(dataClass), executor);
    }

    public <T> ParticleSystem<T> registerDeferred(Class<T> dataClass, Endec<T> endec) {
        int index = this.maxIndex++;
        ParticleSystem<T> system = new ParticleSystem<T>(this, dataClass, index, endec, null);
        this.systemsByIndex.put(index, system);
        return system;
    }

    public <T> ParticleSystem<T> registerDeferred(Class<T> dataClass) {
        return this.registerDeferred(dataClass, ReflectiveEndecBuilder.get(dataClass));
    }

    <T> void sendPacket(ParticleSystem<T> particleSystem, class_3218 world, class_243 pos, T data) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(particleSystem.index);
        VectorSerializer.write(buf, pos);
        buf.write(particleSystem.endec, data);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)class_2338.method_49638((class_2374)pos))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)this.channelId, (class_2540)buf);
        }
    }

    private void verify() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            for (ParticleSystem system : this.systemsByIndex.values()) {
                if (system.handler != null) continue;
                throw new NetworkException("Some particle systems of " + this.channelId + " don't have handlers registered");
            }
        }
    }

    static {
        OwoFreezer.registerFreezeCallback(() -> {
            for (ParticleSystemController controller : REGISTERED_CONTROLLERS.values()) {
                controller.verify();
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    private class Client {
        private Client() {
        }

        private void handler(class_310 client, class_634 networkHandler, class_2540 buf, PacketSender sender) {
            int index = buf.method_10816();
            class_243 pos = VectorSerializer.read(buf);
            if (ParticleSystemController.this.maxIndex <= index || index < 0) {
                Owo.LOGGER.warn("Received unknown particle system index {} on channel {}", (Object)index, (Object)ParticleSystemController.this.channelId);
                return;
            }
            ParticleSystem system = (ParticleSystem)ParticleSystemController.this.systemsByIndex.get(index);
            Object data = buf.read(system.endec);
            client.execute(() -> system.handler.executeParticleSystem((class_1937)client.field_1687, pos, data));
        }
    }
}

