/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.base;

import io.wispforest.owo.Owo;
import io.wispforest.owo.mixin.ui.SlotAccessor;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.PositionedRectangle;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.inject.GreedyInputComponent;
import io.wispforest.owo.ui.util.DisposableScreen;
import io.wispforest.owo.ui.util.UIErrorToast;
import io.wispforest.owo.util.pond.OwoSlotExtension;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_465;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public abstract class BaseOwoHandledScreen<R extends ParentComponent, S extends class_1703>
extends class_465<S>
implements DisposableScreen {
    protected OwoUIAdapter<R> uiAdapter = null;
    protected boolean invalid = false;

    protected BaseOwoHandledScreen(S handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @NotNull
    protected abstract OwoUIAdapter<R> createAdapter();

    protected abstract void build(R var1);

    protected void method_25426() {
        super.method_25426();
        if (this.invalid) {
            return;
        }
        if (this.uiAdapter != null) {
            this.uiAdapter.moveAndResize(0, 0, this.field_22789, this.field_22790);
            this.method_37063(this.uiAdapter);
        } else {
            try {
                this.uiAdapter = this.createAdapter();
                this.build(this.uiAdapter.rootComponent);
                this.uiAdapter.inflateAndMount();
            }
            catch (Exception error) {
                Owo.LOGGER.warn("Could not initialize owo screen", (Throwable)error);
                UIErrorToast.report(error);
                this.invalid = true;
            }
        }
    }

    protected void disableSlot(int index) {
        ((OwoSlotExtension)this.field_2797.field_7761.get(index)).owo$setDisabledOverride(true);
    }

    protected void disableSlot(class_1735 slot) {
        ((OwoSlotExtension)slot).owo$setDisabledOverride(true);
    }

    protected void enableSlot(int index) {
        ((OwoSlotExtension)this.field_2797.field_7761.get(index)).owo$setDisabledOverride(false);
    }

    protected void enableSlot(class_1735 slot) {
        ((OwoSlotExtension)slot).owo$setDisabledOverride(true);
    }

    protected boolean isSlotEnabled(int index) {
        return ((OwoSlotExtension)this.field_2797.field_7761.get(index)).owo$getDisabledOverride();
    }

    protected boolean isSlotEnabled(class_1735 slot) {
        return ((OwoSlotExtension)slot).owo$getDisabledOverride();
    }

    protected SlotComponent slotAsComponent(int index) {
        return new SlotComponent(index);
    }

    protected <C extends Component> C component(Class<C> expectedClass, String id) {
        return this.uiAdapter.rootComponent.childById(expectedClass, id);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void method_25394(class_332 vanillaContext, int mouseX, int mouseY, float delta) {
        OwoUIDrawContext context = OwoUIDrawContext.of(vanillaContext);
        if (!this.invalid) {
            super.method_25394((class_332)context, mouseX, mouseY, delta);
            if (this.uiAdapter.enableInspector) {
                context.method_51448().method_46416(0.0f, 0.0f, 500.0f);
                for (int i = 0; i < this.field_2797.field_7761.size(); ++i) {
                    class_1735 slot = (class_1735)this.field_2797.field_7761.get(i);
                    if (!slot.method_7682()) continue;
                    context.drawText((class_2561)class_2561.method_43470((String)("H:" + i)), this.field_2776 + slot.field_7873 + 15, this.field_2800 + slot.field_7872 + 9, 0.5f, 38655, OwoUIDrawContext.TextAnchor.BOTTOM_RIGHT);
                    context.drawText((class_2561)class_2561.method_43470((String)("I:" + slot.method_34266())), this.field_2776 + slot.field_7873 + 15, this.field_2800 + slot.field_7872 + 15, 0.5f, 5767423, OwoUIDrawContext.TextAnchor.BOTTOM_RIGHT);
                }
                context.method_51448().method_46416(0.0f, 0.0f, -500.0f);
            }
            this.method_2380(context, mouseX, mouseY);
        } else {
            this.method_25419();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        GreedyInputComponent inputComponent;
        Component component;
        if ((modifiers & 2) == 0 && (component = this.uiAdapter.rootComponent.focusHandler().focused()) instanceof GreedyInputComponent && (inputComponent = (GreedyInputComponent)component).onKeyPress(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.uiAdapter.method_25403(mouseX, mouseY, button, deltaX, deltaY) || super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Nullable
    public class_364 method_25399() {
        return this.uiAdapter;
    }

    public void method_25432() {
        super.method_25432();
        if (this.uiAdapter != null) {
            this.uiAdapter.cursorAdapter.applyStyle(CursorStyle.NONE);
        }
    }

    @Override
    public void dispose() {
        if (this.uiAdapter != null) {
            this.uiAdapter.dispose();
        }
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
    }

    public class SlotComponent
    extends BaseComponent {
        protected final class_1735 slot;
        protected boolean didDraw = false;

        protected SlotComponent(int index) {
            this.slot = BaseOwoHandledScreen.this.field_2797.method_7611(index);
        }

        @Override
        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            this.didDraw = true;
            int[] scissor = new int[4];
            GL11.glGetIntegerv((int)3088, (int[])scissor);
            ((OwoSlotExtension)this.slot).owo$setScissorArea(PositionedRectangle.of(scissor[0], scissor[1], scissor[2], scissor[3]));
        }

        @Override
        public void update(float delta, int mouseX, int mouseY) {
            super.update(delta, mouseX, mouseY);
            ((OwoSlotExtension)this.slot).owo$setDisabledOverride(!this.didDraw);
            this.didDraw = false;
        }

        @Override
        public void drawTooltip(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            if (!this.slot.method_7681()) {
                super.drawTooltip(context, mouseX, mouseY, partialTicks, delta);
            }
        }

        @Override
        public boolean shouldDrawTooltip(double mouseX, double mouseY) {
            return super.shouldDrawTooltip(mouseX, mouseY);
        }

        @Override
        protected int determineHorizontalContentSize(Sizing sizing) {
            return 16;
        }

        @Override
        protected int determineVerticalContentSize(Sizing sizing) {
            return 16;
        }

        @Override
        public void updateX(int x) {
            super.updateX(x);
            ((SlotAccessor)this.slot).owo$setX(x - BaseOwoHandledScreen.this.field_2776);
        }

        @Override
        public void updateY(int y) {
            super.updateY(y);
            ((SlotAccessor)this.slot).owo$setY(y - BaseOwoHandledScreen.this.field_2800);
        }
    }
}

