/*
 * Decompiled with CFR 0.152.
 */
package io.github.prismwork.emitrades.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import io.github.prismwork.emitrades.EMITradesPlugin;
import io.github.prismwork.emitrades.util.EntityEmiStack;
import io.github.prismwork.emitrades.util.ListEmiStack;
import io.github.prismwork.emitrades.util.TradeProfile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1830;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_3988;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class VillagerTrade
implements EmiRecipe {
    private final TradeProfile profile;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;
    private final List<EmiIngredient> catalysts;
    private final int id;
    private final class_5250 title;

    public VillagerTrade(TradeProfile profile, int id) {
        this.profile = profile;
        this.inputs = new ArrayList<EmiIngredient>();
        this.outputs = new ArrayList<EmiStack>();
        this.catalysts = profile.villager() != null ? List.of(EntityEmiStack.ofScaled((class_1297)profile.villager(), 12.0f)) : List.of();
        this.id = id;
        class_3852 internalProf = profile.profession();
        this.title = internalProf.equals((Object)EMITradesPlugin.WANDERING_TRADER_PLACEHOLDER) ? class_2561.method_43471((String)"emi.emitrades.placeholder.wandering_trader") : class_2561.method_43471((String)("entity.minecraft.villager." + profile.profession().comp_818().substring(profile.profession().comp_818().lastIndexOf(":") + 1))).method_27693(" - ").method_10852((class_2561)class_2561.method_43471((String)("emi.emitrades.profession.lvl." + profile.level())));
        class_3853.class_1652 offer = profile.offer();
        if (offer instanceof class_3853.class_4161) {
            class_3853.class_4161 factory = (class_3853.class_4161)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((class_1799)factory.field_45130, (long)factory.field_18549));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.of((class_1935)class_1802.field_8687));
        } else if (offer instanceof class_3853.class_4165) {
            class_3853.class_4165 factory = (class_3853.class_4165)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8687, (long)factory.field_18572));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.of((class_1799)factory.field_18571));
        } else if (offer instanceof class_3853.class_4166) {
            class_3853.class_4166 factory = (class_3853.class_4166)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8687, (long)1L));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            class_1799 stack = new class_1799((class_1935)class_1802.field_8766, 1);
            class_1830.method_53209((class_1799)stack, (List)factory.field_45756);
            this.outputs.add(0, EmiStack.of((class_1799)stack));
        } else if (offer instanceof class_3853.class_4164) {
            class_3853.class_4164 factory = (class_3853.class_4164)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8687, (long)factory.field_18565));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((class_1799)factory.field_18563));
            this.outputs.add(0, EmiStack.of((class_1799)factory.field_18566));
        } else if (offer instanceof class_3853.class_4163) {
            class_3853.class_4163 factory = (class_3853.class_4163)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8687, (long)Math.min(factory.field_18559 + 5, 64)));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            ArrayList out = new ArrayList();
            int enchantability = factory.field_18558.method_7909().method_7837();
            int power = 21 + (enchantability / 4 + 1) + (enchantability / 4 + 1);
            class_1890.method_8229((int)power, (class_1799)factory.field_18558, (boolean)false).forEach(entry -> {
                class_1887 enchantment = entry.field_9093;
                for (int i = enchantment.method_8187(); i <= enchantment.method_8183(); ++i) {
                    class_1799 stack = factory.field_18558.method_7972();
                    stack.method_7978(entry.field_9093, i);
                    out.add(EmiStack.of((class_1799)stack));
                }
            });
            this.outputs.add(0, new ListEmiStack(out, factory.field_18558.method_7947()));
        } else if (offer instanceof class_3853.class_4162) {
            class_3853.class_4162 factory = (class_3853.class_4162)offer;
            ArrayList stacks = new ArrayList();
            factory.field_18553.values().forEach(item -> stacks.add(EmiStack.of((class_1935)item)));
            this.inputs.add(0, (EmiIngredient)new ListEmiIngredient(stacks, (long)factory.field_18554));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.of((class_1935)class_1802.field_8687));
        } else if (offer instanceof class_3853.class_4167) {
            class_3853.class_4167 factory = (class_3853.class_4167)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8687, (long)factory.field_18583));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((class_1935)factory.field_18586, (long)factory.field_18587));
            ArrayList out = new ArrayList();
            class_7923.field_41179.method_10220().filter(potion -> !potion.method_8049().isEmpty() && class_1845.method_20361((class_1842)potion)).forEach(potion -> {
                class_1799 stack = class_1844.method_8061((class_1799)factory.field_18581, (class_1842)potion);
                out.add(EmiStack.of((class_1799)stack));
            });
            this.outputs.add(0, new ListEmiStack(out, factory.field_18582));
        } else if (offer instanceof class_3853.class_1648) {
            class_3853.class_1648 factory = (class_3853.class_1648)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8687, (long)5L));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8529));
            ArrayList out = new ArrayList();
            factory.field_45131.forEach(enchantment -> {
                int min = Math.max(enchantment.method_8187(), factory.field_45132);
                int max = Math.min(enchantment.method_8183(), factory.field_45133);
                for (int i = min; i <= max; ++i) {
                    class_1799 stack = class_1772.method_7808((class_1889)new class_1889(enchantment, i));
                    out.add(EmiStack.of((class_1799)stack));
                }
            });
            this.outputs.add(0, new ListEmiStack(out, 1L));
        } else if (offer instanceof class_3853.class_1654) {
            class_3853.class_1654 factory = (class_3853.class_1654)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8687, (long)factory.field_18589));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8251));
            this.outputs.add(0, EmiStack.of((class_1935)class_1802.field_8204));
        } else if (offer instanceof class_3853.class_4160) {
            class_3853.class_4160 factory = (class_3853.class_4160)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8687, (long)factory.field_18545));
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.of((class_1935)factory.field_18544));
        } else if (offer instanceof EMITradesPlugin.FakeFactory) {
            EMITradesPlugin.FakeFactory factory = (EMITradesPlugin.FakeFactory)offer;
            this.inputs.add(0, (EmiIngredient)EmiStack.of((class_1799)factory.first));
            this.inputs.add(1, (EmiIngredient)EmiStack.of((class_1799)factory.second));
            this.outputs.add(0, EmiStack.of((class_1799)factory.sell));
        } else {
            this.inputs.add(0, (EmiIngredient)EmiStack.EMPTY);
            this.inputs.add(1, (EmiIngredient)EmiStack.EMPTY);
            this.outputs.add(0, EmiStack.EMPTY);
        }
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    public EmiRecipeCategory getCategory() {
        return EMITradesPlugin.VILLAGER_TRADES;
    }

    @Nullable
    public class_2960 getId() {
        return new class_2960("emitrades", "villager_trades/" + this.profile.profession().comp_818().substring(this.profile.profession().comp_818().lastIndexOf(":") + 1) + "_" + this.id);
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int extraWidth = this.catalysts.isEmpty() ? 0 : 21;
        return this.catalysts.isEmpty() || !EMITradesPlugin.CONFIG.enable3DVillagerModelInRecipes ? Math.max(86, textRenderer.method_27525((class_5348)this.title) + 2) : Math.max(extraWidth + 85, extraWidth + textRenderer.method_27525((class_5348)this.title));
    }

    public int getDisplayHeight() {
        return 28;
    }

    public void addWidgets(WidgetHolder widgets) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (this.catalysts.isEmpty() || !EMITradesPlugin.CONFIG.enable3DVillagerModelInRecipes) {
            widgets.addText((class_2561)this.title, (this.getDisplayWidth() - textRenderer.method_27525((class_5348)this.title)) / 2, 0, 0xFFFFFF, true);
            widgets.addSlot(this.inputs.get(0), this.getDisplayWidth() / 2 - 42, 10);
            widgets.addSlot(this.inputs.get(1), this.getDisplayWidth() / 2 - 22, 10);
            widgets.addTexture(EmiTexture.EMPTY_ARROW, this.getDisplayWidth() / 2 - 3, 10);
            SlotWidget outputSlot = new SlotWidget((EmiIngredient)this.outputs.get(0), this.getDisplayWidth() / 2 + 22, 10).recipeContext((EmiRecipe)this);
            this.wrapOutput(widgets, outputSlot);
        } else {
            SlotWidget villagerSlot = new SlotWidget(this.catalysts.get(0), 1, 6).drawBack(false);
            class_3988 class_39882 = this.profile.villager();
            if (class_39882 instanceof class_1646) {
                class_1646 villager = (class_1646)class_39882;
                villagerSlot.appendTooltip((class_2561)class_2561.method_43471((String)("emi.emitrades.profession.lvl." + villager.method_7231().method_16925())).method_27692(class_124.field_1054));
            }
            widgets.add((Widget)villagerSlot);
            widgets.addText((class_2561)this.title, 21, 0, 0xFFFFFF, true);
            widgets.addSlot(this.inputs.get(0), 21, 10);
            widgets.addSlot(this.inputs.get(1), 41, 10);
            widgets.addTexture(EmiTexture.EMPTY_ARROW, 60, 10);
            SlotWidget outputSlot = new SlotWidget((EmiIngredient)this.outputs.get(0), 85, 10).recipeContext((EmiRecipe)this);
            this.wrapOutput(widgets, outputSlot);
        }
    }

    private void wrapOutput(WidgetHolder widgets, SlotWidget outputSlot) {
        if (this.profile.offer() instanceof class_3853.class_4160) {
            outputSlot = outputSlot.appendTooltip((class_2561)class_2561.method_43471((String)"emi.emitrades.random_colored").method_27692(class_124.field_1054));
        } else if (this.profile.offer() instanceof class_3853.class_4166) {
            outputSlot = outputSlot.appendTooltip((class_2561)class_2561.method_43471((String)"emi.emitrades.random_effect").method_27692(class_124.field_1054));
        } else if (this.profile.offer() instanceof class_3853.class_1654) {
            outputSlot = outputSlot.appendTooltip((class_2561)class_2561.method_43471((String)"emi.emitrades.random_structure").method_27692(class_124.field_1054));
        }
        widgets.add((Widget)outputSlot);
    }
}

